/* qwrite.c
 */


int    qwrite(int row, int col, char attrib, char *string)
{
   extern int far *scrptr;
   int far *farptr;
   register int j;

   row *= 80;  /* reset row for offset into video buffer */

   row += col; /* add column offset to get to first byte */

   if(!string[0])  /* if no bytes to be written, return */
       return row;

   farptr = scrptr + row;
   if( scrptr == (int far *)0xb8000000)
       WaitForRetrace();

       /* put attribute into DH and while not end of string */
   for( j = 0, _DH = attrib; string[j]; j++)
   {
       _DL =  string[j];   /* put character into DL */
       farptr[j] = _DX;    /* poke them into the buffer */
   }
   return row;
}

#ifdef OLD
WaitForRetrace()
{
   _DX = 0x3da;                        /* get address of video port */
   while(( inportb(_DX) & 8) != 8);    /* wait if retrace in progress */
   while(( inportb(_DX) & 8) == 8);    /* wait for next retrace */
}
#endif
WaitForRetrace()
{
   _DX = 0x3da;                    /* get address of video port */
   while(!( inportb(_DX) & 8));    /* wait if retrace in progress */
   while(( inportb(_DX) & 8));     /* wait for next retrace */
}
int far *scrptr;
Init_scrptr()
{
   if( peekb(0x40, 0x49) == 0x7)       /* test for mono */
       scrptr = (int far *)0xb0000000;/* set pointer to mono screen buffer */
   else
       scrptr = (int far *)0xb8000000;/* set pointer to color screen buffer */
}

main()
{
   int i,j;

   Init_scrptr();

   for( i = j = 0; i < 24; i++, j++)
       qwrite(i,j,0x7, "This is normal video ");
   getch();
   for( i = j = 0; i < 24; i++, j++)
       qwrite(i,j,0x70,"This is reverse video");
   getch();
   for( i = j = 0; i < 24; i++, j++)
       qwrite(i,j,0x7, "This is normal video ");

}

