CODE    SEGMENT
        ASSUME  CS:CODE, DS:CODE
        ORG     100H

SYSINT  PROC    FAR
        PUSH    BP              ; Save BP - required for BASIC
        MOV     BP,SP           ; Get variable descriptor address
        MOV     BX,[BP+10]      ; Get address of INT no.
        MOV     AX,[BX]         ; Put interrupt number in AX
        MOV     BX,[BP+6]       ; Get REG.OUT%() descriptor
        MOV     CX,BX           ; Store address in CX for now
        MOV     BX,[BP+8]       ; Get REG.IN%() descriptor
        PUSH    ES              ; Save ES - required for BASIC
        PUSH    DS              ; Save DS - required for BASIC
        CALL    BEGIN           ; Skip past data
REG_OUT DW      ?               ; [BP] pointer to REG.OUT%(0)

INT     PROC    NEAR            ; Called to execute interrupt
        INT     0               ; [BP+3] where we place Int number
        RET                     ; Return
INT     ENDP

BEGIN:  POP     BP              ; Get base address for variables
        MOV     [BP+3],AL       ; Put interrupt number into this code
        MOV     [BP],CX         ; Store REG.OUT%(0) address
        MOV     CX,[BX+4]       ; Set CX from REG.IN%(2)
        MOV     DX,[BX+6]       ; Set DX from REG.IN%(3)
        MOV     SI,[BX+8]       ; Set SI from REG.IN%(4)
        MOV     DI,[BX+10]      ; Set DI from REG.IN%(5)
        MOV     AX,[BX+14]      ; Put ES in AX
        CMP     AX,0FFFFH       ; Is it -1?
        JE      DEF_ES          ; If yes, take default value
        MOV     ES,AX           ; otherwise set ES
DEF_ES:
        MOV     AX,[BX+12]      ; Get DS in AX
        CMP     AX,0FFFFH       ; Is it -1?
        JE      DEF_DS          ; If yes, take default value
        MOV     DS,AX           ; otherwise set DS
DEF_DS:
        MOV     AX,SS:[BX]      ; Set AX from REG.IN%(0) - SS still points
                                ; to BASIC dataseg, even if DS doesn't
        MOV     BX,SS:[BX+2]    ; Set BX from REG.IN%(2)
        CALL    INT             ; Execute interrupt
        PUSH    BX              ; Save returned BX temporarily
        MOV     BX,SS:[BP]      ; Set BX to base REG.OUT%() address
        MOV     SS:[BX],AX      ; Set AX in REG.OUT%(0)
        POP     SS:[BX+2]       ; Set BX in REG.OUT%(1)
        MOV     AX,DS           ; Get DS in AX
        MOV     SS:[BX+12],AX   ; Set DS in REG.OUT%(6)
        POP     DS              ; Get old DS - DS now points to BASIC dataseg
        MOV     AX,ES           ; Get returned ES in AX
        MOV     [BX+14],AX      ; Set ES in REG.OUT%(7)
        POP     ES              ; Get old ES
        MOV     [BX+4],CX       ; Set CX in REG.OUT%(2)
        MOV     [BX+6],DX       ; Set DX in REG.OUT%(3)
        MOV     [BX+8],SI       ; Set SI in REG.OUT%(4)
        MOV     [BX+10],DI      ; Set DI in REG.OUT%(5)

        POP     BP              ; Get original BP for BASIC
        RET     6               ; Return, skipping 3 parameters
SYSINT  ENDP
CODE    ENDS
        END     SYSINT

