 * WC.C a wordcount/linecount program
 */

#include <stdio.h>  /* header for getchar() */
#include <ctype.h>  /* header for isalpha() */

#ifndef    YES
#define    YES 1
#endif

#ifndef    NO
#define    NO  0
#endif

main()
{
   int character, wordcount, linecount, in_word = NO;

   wordcount = linecount = 0;

                       /* get characters from standard input */
   while( (character = getchar()) != EOF)
   {
       if (character == '\n')      /* if it's a Newline        */
           ++linecount;            /* increment the line count     */
       if (!isalpha(character))    /* if not an alpha character    */
           in_word = NO;           /* set the in_word flag     */
       else if (in_word == NO)     /* else it's not alpha,     */
       {                           /* and was in a word        */
           in_word = YES;          /* reset in_word flag, and  */
           ++wordcount;            /* increment the wordcount  */
       }
   }
                                   /* print the results */
   printf("     Number of words: %d\n", wordcount);
   printf("     Number of lines: %d\n", linecount);
}

