PROGRAM LinkText;
USES Crt;     { Omit this line for version 3 }
TYPE
  AnyStr = STRING[255];
  LinePtr = ^LineRecType;
  LineRecType = RECORD
                  NextLine : LinePtr;
                  LineField : AnyStr;
                END;              { of LineRecType }

VAR
  TextFile : Text;                { Input File     }
  Head : LinePtr;                 { Head of List   }
  Hold : LinePtr;                 { Place Holder   }
  Cur : LinePtr;                  { Current Line   }
  FileName : AnyStr;              { File Name      }
  Ok : Boolean;                   { I/O Error Flag }
  LineBuf : AnyStr;               { Input String   }
  L : Integer;                    { Line Number    }


  PROCEDURE LoadFile;
  { LoadFile prompts for a file name and
   loads the file into a linked list }
  BEGIN
    ClrScr;
    Write('Enter File Name: ');
    ReadLn(FileName);
    Assign(TextFile, FileName);
    {$I-} Reset(TextFile) {I+} ;
    Ok := (IoResult = 0);
    IF Ok THEN
      BEGIN
        GetMem(Head, 4);
        Head^.NextLine := NIL;    { Initialize Head }
        Hold := Head;
        WHILE NOT Eof(TextFile) DO
          BEGIN
            ReadLn(TextFile, LineBuf);
            GetMem(Cur, Length(LineBuf)+5); { Allocate Memory }
            Hold^.NextLine := Cur; { Set previous pointer }
            Cur^.NextLine := NIL; { Cur goes at end of list }
            Hold := Cur;          { Save Current pointer }
            Cur^.LineField := LineBuf;
          END;
        Close(TextFile);
      END;
  END;                            { of LoadFile }

  PROCEDURE DisplayFile;
  { DisplayFile traverses the list and writes each line }
  BEGIN
    ClrScr;
    Cur := Head^.NextLine;
    WHILE Cur <> NIL DO
      BEGIN
        WriteLn(Cur^.LineField);
        Cur := Cur^.NextLine;
      END;
  END;                            { of DisplayFile }

  PROCEDURE DeleteLine(N : Integer);
  { DeleteLine deletes the Nth line of the buffer. }
  VAR
    Count : Integer;
  BEGIN
    Hold := Head;
    Cur := Head^.NextLine;
    Count := 1;
    WHILE (Count < N) AND (Cur <> NIL) DO
      BEGIN
        Hold := Cur;              { Save Current pointer }
        Cur := Cur^.NextLine;     { Advance to next line }
        Count := Succ(Count);     { Increment counter    }
      END;
    IF (Cur <> NIL) AND (Count = N) THEN
      BEGIN
        Hold^.NextLine := Cur^.NextLine; {  skip current line }
        FreeMem(Cur, Length(Cur^.LineField)+5);
      END;
  END;                            { of DeleteLine }

  PROCEDURE InsertLine(N : Integer; NewStr : AnyStr);
  { InsertLine inserts the line NewStr before line N. }
  VAR
    Count : Integer;
    NewLine : LinePtr;
  BEGIN
    Hold := Head;
    Cur := Head^.NextLine;
    Count := 1;
    WHILE (Count < N) AND (Cur <> NIL) DO
      BEGIN
        Hold := Cur;              { Save current pointer }
        Cur := Cur^.NextLine;     { Advance to next line }
        Count := Succ(Count);     { Increment counter    }
      END;
    GetMem(NewLine, Length(NewStr)+5);
    Hold^.NextLine := NewLine;    { Change pointers to link }
    NewLine^.NextLine := Cur;     {   in the new line       }
    NewLine^.LineField := NewStr;
  END;                            { of InsertLine }

BEGIN                             { Main }
  LoadFile;
  IF Ok THEN
    BEGIN
      DisplayFile;
      WriteLn; Write('Enter line number to delete: '); ClrEol;
      ReadLn(L);
      DeleteLine(L);
      DisplayFile;
      WriteLn; Write('Insert string before what line? '); ClrEol;
      ReadLn(L);
      InsertLine(L, 'This string to be inserted before line specified');
      DisplayFile;
    END
  ELSE WriteLn(FileName, ' NOT FOUND');
END.
