BANK.PAS

PROGRAM bankdemo;
(* Turbo Pascal 5.5 program *)
USES queues,crt;
TYPE
  PatronPt = ^PatronItem;
  PatronItem = OBJECT (GenericItem)
    TaskTime : Word;
    CONSTRUCTOR Init(min,max : Byte);
    FUNCTION GetTime : Word;
    DESTRUCTOR Done; virtual;
  END;

  ActionType = (NewPatron, Serving, Idle);

  Bank = Object
    Q : queue;
    time, timeleft, idletime : Word;
    AvgMins, Shortest, Longest : Byte;
    CONSTRUCTOR Init(AMBP, ST, LT : Byte);
    DESTRUCTOR  Done;
    FUNCTION    GetTime : Word;
    PROCEDURE   Tick;
  END;

  CONSTRUCTOR PatronItem.Init(min,max : Byte);
  BEGIN
    TaskTime := 10*(min+random(succ(max-min)));
  END;

  DESTRUCTOR PatronItem.Done;
  BEGIN  END;

  FUNCTION PatronItem.GetTime : Word;
  BEGIN  GetTime := TaskTime;  END;

  CONSTRUCTOR Bank.Init(AMBP, ST, LT : Byte);
  BEGIN
    Randomize;
    Q.Init;
    time := 0; timeLeft := 0; idletime := 0;
    AvgMins := AMBP;
    Shortest := ST;
    Longest := LT;
    Write('Now beginning bank simulation.  ');
    WriteLn('New patrons arrive on the average of');
    Write('every ',AvgMins,' minutes.  Their business ');
    WriteLn('takes from ',shortest,' to ',longest,' minutes.');
  END;

  DESTRUCTOR Bank.Done;
  BEGIN
    WriteLn;
    Write('The simulation ran for ',time DIV 10,'.',time MOD 10);
    WriteLn(' simulated minutes.  Of that time, the clerk');
    Write('was idle for ',idletime DIV 10,'.',idletime MOD 10);
    Write(' simulated minutes.  Maximum length of ');
    WriteLn('queue was ',Q.GetMax);
    Q.done;
  END;

  FUNCTION Bank.GetTime : Word;
  BEGIN  GetTime := Time;  END;

  PROCEDURE Bank.Tick;
  VAR
    A : PatronPt;
    G : ItemPtr;

    PROCEDURE Event(Act : ActionType; T, L : Word);
    BEGIN
      Write(T DIV 10:4,'.',T MOD 10,' minutes   ');
      CASE Act OF
        NewPatron : Write('New patron joined queue.  ');
        Serving   : Write('Clerk is serving a patron.');
        Idle      : Write('Clerk is idle.            ');
      END;
      WriteLn('  ',L:4,' in queue.');
    END;

  BEGIN
    Write(time DIV 10:4,'.',time MOD 10,^M);
    IF random(10*AvgMins) = 0 THEN
      BEGIN
        Q.enqueue(new(PatronPt,Init(Shortest, Longest)));
        Event(NewPatron, time, Q.length);
      END;
    IF timeleft <= 1 THEN
      BEGIN
        A := PatronPt(Q.dequeue);
        IF A <> NIL THEN
          BEGIN
            timeleft := A^.GetTime;
            Dispose(A,done);
            Event(Serving, time, Q.length);
          END
        ELSE
          BEGIN
            Inc(IdleTime);
            IF timeleft = 1 THEN Event(idle, time, Q.length);
          END;
      END;
    Inc(Time);
    IF timeleft > 0 THEN dec(timeleft);
    delay(100);
  END;


VAR FirstNational : Bank;

BEGIN
  Randomize;
  FirstNational.Init(4,3,5);
  REPEAT
    FirstNational.tick;
  UNTIL KeyPressed OR (FirstNational.GetTime >= 600);
  FirstNational.done;
END.



