/*******************************************************************
 *
 * Name:      vgares.c
 *
 * Function:  select vertical resolution in VGA alphanumeric modes
 *
 * Syntax:    VGARES [vertical resolution]
 *
 * Notes:     Specified vertical resolution must be 200, 350, or 400
 *             scan lines.  If no resolution is specified, the
 *             program displays the current vertical resolution.
 *
 ******************************************************************/

#include <dos.h>

main( argc, argv )
int     argc;
char    **argv;
{
    struct WORDREGS    regs;            /* used by int86() */
    unsigned char far  *FLAGS = (unsigned char far *)0x00400089;
    int                ScanLines;

    /* set vertical resolution if specified in command line */

    if( argc == 2 )
    {
      sscanf( argv[1], "%d", &ScanLines );

     /* validate scan lines arg & set up for INT 10H func 12H */

      switch( ScanLines )
      {
        case 200:
          regs.ax = 0x1200;
          break;

        case 350:
          regs.ax = 0x1201;
          break;

        case 400:
          regs.ax = 0x1202;
          break;

        default:
          printf( "\nError: Scan lines value should be");
          printf( " 200, 350, or 400\n" );
          exit( 1 );
      }                           /* end of switch */

      /* bl = 30h, Select scan lines */
      regs.bx = 0x30;
      int86( 0x10, &regs, &regs );

      /* set scan lines by setting video mode to current value */
      regs.ax = 0x0F00;           /* Get Video Mode */
      int86( 0x10, &regs, &regs );

      regs.ax &= 0x00FF;          /* Set it to same mode (in AL) */
      int86( 0x10, &regs, &regs );
    }                             /* endif argc == 2 */

    /* show current vertical resolution */
    /* test bits 4 and 7 of BIOS flags byte  @ addr 40:89 */
    switch( *FLAGS & 0x90 )
    {
      case 0x00:
        ScanLines = 350;
        break;

      case 0x10:
        ScanLines = 400;
        break;

      case 0x80:
        ScanLines = 200;
        break;
    }

    printf( "\nCurrent vertical resolution (scan lines) is %d\n",
      ScanLines );

    exit( 0 );
}
