/*+
    Name:       HLTEXT.C
    Author:     Kent J. Quirk
		(c) Copyright 1988 Ziff Communications Co.
    Abstract:   Tests a system's text speed by:
		1)  using DOS to spit out X short and long lines of text
		2)  using BIOS to scroll the same data
		3)  using MSC's _outtext function to scroll the same data
		4)  using _outtext to scroll the data inside a window
		The user can set the video mode and the quantity of text.
    History:	09-Sep-88   kjq     Version 1.00
-*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <graph.h>
#include <bios.h>
#include "hl.h"
#include "hltimes.h"

char *text[] = {
		/* Rene Descartes */
"Cogito, ergo sum.\r\n",
		/* Oscar Wilde */
"Nothing that is worth knowing can be taught.\r\n",
		/* Arthur C. Clarke */
"Any sufficiently advanced technology is indistinguishable from magic.\r\n"
};

#define T_SHORT 0
#define T_MEDIUM 1
#define T_LONG 2

#define T_TOTAL 3

#define DOS 0
#define BIOS 1
#define MSC 2
#define WIN_MSC 3

#define PTIMER(n,fmt) stop_timer(); printf(fmt,n)

void bios_text(index, nlines)
int index;
int nlines;
{
    char *p;
    union REGS regs;
	 
    while (nlines--)
    {
	p = text[index];
	while (regs.h.al = *p++)
	{    
	    regs.h.ah = 0x0E;		/* write TTY */
	    int86(0x10, &regs, &regs);
	}
    }
}

void dos_text(index, nlines)
int index;
int nlines;
{
    while (nlines--)
	fputs(text[index], stdout);
}

void msc_text(index, nlines)
int index;
int nlines;
{
    _settextwindow(1,1,25,80);
    _settextposition(25,1);
    while (nlines--)
	_outtext(text[index]);
}

void win_text(index, nlines)
int index;
int nlines;
{
	_settextwindow(10,20,20,50);
	_wrapon(_GWRAPOFF);
	_settextposition(25,1);
	while (nlines--)
		_outtext(text[index]);
}

void usage()
{
	printf("Usage:  HLTEXT [-?] [-nNLINES]\n");
	printf("        NLINES is the number of lines to scroll for\n");
	printf("        each subtest (default = 200)\n");
	exit(1);
}

char *rowname[4] = { "BIOS", "DOS", "MSC", "Windowed" };
void (*scroll[4])() = {
	bios_text, dos_text, msc_text, win_text
};
long times[4][4] = { 0 };

TIME_REC trec[] = {
	{ 0L, "Total: Text Scrolling" },
	{ 0L, "BIOS Scrolling" },
	{ 0L, "DOS Scrolling" },
	{ 0L, "MSC Scrolling" },
	{ 0L, "Windowed Scrolling" },
	{ -1L, "HLTEXT" }
};

main(argc, argv)
int argc;
char *argv[];
{
	int i, j;
	int nlines = 200;
	int graphics = 0;
	struct videoconfig config;
	char *filename = NULL;
	int program = -1;
	int bench = 0;
	int batch = 0;

	for (i=1; i<argc; i++)
	{
		if (argv[i][0] != '-')
			usage();

		switch(tolower(argv[i][1])) {
		case 'a':
			batch = 1;
			break;      /* ignore batch switch */
		case 'b':
			bench = 1;
			break;
		case 'n':
			nlines = atoi(argv[i]+2);
			break;
		case 'g':
			graphics = 1;
			break;
		case 'p':
			program = atoi(argv[i]+2);
			break;
		case 'f':
			filename = argv[i]+2;
			break;
		default:
		case '?':
			usage();
			break;
		}
	}

	start_timer(0);
	for (i=0; i<4; i++)
	{
		start_timer(1);
		start_timer(2);
		(*scroll[i])(T_SHORT, nlines);
		stop_timer();
		times[i][T_SHORT] = get_timer(2);

		start_timer(2);
		(*scroll[i])(T_MEDIUM, nlines);
		stop_timer();
		times[i][T_MEDIUM] = get_timer(2);

		start_timer(2);
		(*scroll[i])(T_LONG, nlines);
		stop_timer();
		times[i][T_LONG] = get_timer(2);
		times[i][T_TOTAL] = get_timer(1);
	}
	trec[0].ticks=get_timer(0);

	for (i=0; i<25; i++)
		printf("\n");

	if ((!bench) && (!batch))
	{
		printf("%12.12s%10s%10s%10s%10s\n",
			" ", "Short", "Medium", "Long", "Total");
		printf("%12.12s  %2d bytes  %2d bytes  %2d bytes\n",
			" ", strlen(text[0]), strlen(text[1]), strlen(text[2]));
		for (i=0; i<4; i++)
		{
			printf("\n%10.10s: ", rowname[i]);
			for (j=0; j<4; j++)
			{
				printf("%10s", time_secs(times[i][j]));
			}
			trec[i+1].ticks = times[i][T_TOTAL];
		}
		printf("\n");
		printf("\nTotal time: %s\n", time_secs(trec[0].ticks));
	}
	else
	{
		for (i=0; i<4; i++)
			trec[i+1].ticks = times[i][T_TOTAL];
	}

	if ((filename != NULL) && (program >= 0))
	{
		if (opentime(filename))
		{
			for (i=0; i<(sizeof(trec)/sizeof(trec[0])); i++)
			{
				savetime(program, i, &trec[i]);
			}
		}
	}
	closetime();
	return(0);
}
