/*
	ANIMLIB.H
	Fonctions d'animations
	Animation tools
	(c) 1996 D.G. Sureau
*/

#define FP_OFF(fp)	((unsigned)(fp))
#define FP_SEG(fp)	((unsigned)((unsigned long)(fp) >> 16))
#define MK_FP(seg,ofs)	((void far *) \
			   (((unsigned long)(seg) << 16) | (unsigned)(ofs)))


/* Nombre maximal de sprites dans un fichier */
#define MAXSPRITES 1024

extern long *SPVECTOR;     /* Pointer on sprites' adresses */
extern char *SPVECTORchar;
extern int  *SPVECTORint;
extern char *SPCODE;       /* Pointer on sprites' code */

extern char FRAMESIZE;     /* Max frame number for any series */

/* GET SERIES
   Return series number for a sprite
   Retourne le numro de srie  laquelle appartient un sprite
*/

int get_series(int sprite);

/* GET ANIM FRAME
   Return frame number in a series for a sprite
   Retourne le no de frame dans sa srie pour un sprite
*/

int get_anim_frame(int sprite);

/* GET FIRST
   Return first sprite in a series
   Donne le premier sprite d'une srie
*/

int get_first(int series);

/* GET FRAME NUMBER
   Return number of image in a series
   Nombre d'images dans une srie
*/

int get_frame_number(int series);

/* SPRITE CODE
   Return sprite's type code
   Retourne le code du type de sprite
   1 = 256 colors
   4 = 16  colors compressed
   5 = 16  colors
*/

int sprite_code(int sprite);

/* MCGA ANIMATE
   Single function to animate series
   Fonction simple pour animer une srie
*/

void MCGAanimate(int series, int x, int y, int xdepl, int ydepl);

/*
   FILE UTILITIES
*/

int  FileExist(char *);
long File_Length(char *);

/*
   SPRITES LOAD
   Sprites loading.   Input: Filename, size
   Chargement des sprites.  Entre: Nom de fichier, taille maximale
*/

int sprites_load(char *filename, long buffersize);

/*
   SPRITE ALLOC
   Allocate space for sprite and set pointers
   Allocation d'espace pour les sprites et affectation des pointeurs
*/

int sprite_alloc();
