
{   ANIMLIB  (c) 1996-97 D.G. Sureau

{   ANIMLIB library
{   This unit allows to use series
{   Most functions are not useful for a standard table of sprite with
{   no series that is the default for Artist Of Virtuality  and ISD.

{   Librairie ANIMLIB
{   Cette unit permet d'utiliser les sries de sprites.
{   La plupart des foonctions sont inutiles avec les fichiers de sprite
{   sans series crs  par Artist of Virtuality ou ISD en
{   configuration par dfaut.
}

UNIT Animlib;

INTERFACE

Uses Mcgalib, Crt, Memory;

{ These type may be changed by the user to larger size
{ - Change spriteadr for more sprites
{ - Change codeadr for larger table of sprite

{ Ces types peuvent tre modifis pour une taille plus grande
{ - Changer spriteadr pour plus de sprites
{ - Changer codeadr pour une table de sprite plus grande

{ SPVECTOR:     Addresses of sprites }
{ SPCODE:       Pointer on start of code of sprites }
{ FRAMESIZE:    Size of animation (Default is 1 frame }
{ SPRITEHEADER: Header of each sprite in the code buffer }
{ MAXSPRITES:   Maximal number of sprites in loaded file }
{ BUFFERSIZE:   Maximal size of code of images in loaded file }
{ FILEHEADER    is also the first item of SPVECTOR for compatibility
                with the C Langage. It is the header of the file }

Const
 MAXSPRITES = 1024;
 BUFFERSIZE = 65512;

Type
 SPRITEHEADER = RECORD
                Rows    : Word;
                Width   : Word;
                Code    : Byte;     { 1 = 256, 5 = 16 colours }
                Palette : Byte;     { Palette = Plane = Row of 16 colours }
                END;

Var
 SPCODE       : Pointer;
 SPVECTOR     : array[0..MAXSPRITES + 5] of pointer;
 SPVECTORlong : array[0..MAXSPRITES + 5] of longint absolute SPVECTOR;
 FILEHEADER   : Record
                 Spritenumber : Integer;
                 Framenumber  : Byte;
                 Reserved     : Byte;
                End absolute SPVECTOR;

 FRAMESIZE: byte;

Function Get_Series(sprite: integer): integer;
Function Get_Anim_Frame(sprite: integer): integer;
Function Get_First(series: integer): integer;
Function Get_Frame_Number(series: integer): integer;
Function Sprite_Code(sprite: integer): integer;
Function Sprites_Load(filename: string; Maxmem: word): integer;
Function Sprite_Alloc(Allocsize: word): Boolean;
Procedure MCGAanimate(series, x, y, xmove, ymove: integer);
Function AdjustPointer(OldPointer: pointer; MoreOff: longint): Pointer;
Function FileExist(fname : string) : Boolean;
Function FileLength(fname : string) : longint;


IMPLEMENTATION

{ Return number of series the sprite is included inside }
{ No de squence  laquelle appartient un sprite }


Function Get_Series(sprite: integer): integer;
var i: integer;
Begin
 i := FRAMESIZE;
 if(i = 0) then i := 1;
 get_series := (sprite - 1)  DIV i;
End;

{ Return number of a frame }
{ Numro de frame }

Function  Get_Anim_Frame(sprite: integer): integer;
var
 i : integer;
 Begin
 i := FRAMESIZE;
 if(i = 0) then i := 1;
 get_anim_frame:= sprite - (i * get_series(sprite));
End;


{ Return number of first sprite in series }
{ Premier sprite d'une srie }


Function Get_First(series: integer): integer;
Begin
 get_first := 1 + series * FRAMESIZE;
End;


{ Return size of series }
{ Nombre de frames rel dans une srie }


Function Get_Frame_Number(series: integer): integer;
Label loop;
Var
 spr, nbr: integer;

Begin
 nbr := 0;
 spr := series * FRAMESIZE;

loop:
 spr := spr + 1;                           { Next sprite / Sprite suivant }
 if ((spr = 1) OR (SPVECTOR[spr] <> NIL))   { Slot used / Case utilise }
 Then
 Begin
  nbr := nbr + 1;
  if(nbr < FRAMESIZE) then goto loop;
 End;

 get_frame_number := nbr;
End;


{ Return the sprite's code of format }
{ Donne le code de format d'un sprite }


Function Sprite_Code(sprite: integer): integer;
Var
 adr : ^SPRITEHEADER;
Begin
 adr := SPVECTOR[sprite];
 sprite_code := adr^.Code;
End;


{ Example of animation in VGA 19 mode }
{ Exemple d'animation en mode VGA 19  }


Procedure MCGAanimate(series, x, y, xmove, ymove: integer);
Var
 number: integer;
 sprite: integer;

Begin
 number := get_frame_number(series);
 sprite := get_first(series);

 while(number <> 0) Do
 Begin
  sprite256(x, y, SPVECTOR[sprite]);
  sprite := sprite + 1;
  x := x + xmove;
  y := y + ymove;
  Delay(20);
  number := number - 1;
 End;
End;


{  AFJUST POINTER
{  Add an offset to an address and adjust the segment
{  Ajoute un dplacement  une adresse et ajuste le segment

{  Formats Pointer:  $ssssoooo
{	   Segment:  $ssss
{	   Offset:   $oooo
{          Address:  Segment * 16 + Offset
}

Function AdjustPointer(OldPointer: pointer; MoreOff: longint): Pointer;
Var
 NewSeg: Word;

Begin
 MoreOff       := MoreOff + OFS(OldPointer^);  { Offset total }
 NewSeg        := SEG(OldPointer^);            { Old segment }
 NewSeg        := NewSeg + (MoreOff SHR 4);    { Segment updated }
 AdjustPointer := ptr(NewSeg, MoreOff AND 15); { Offset reduced  }
End;


   { Test if the file exists / Vrifie l'existence du fichier }

Function FileExist(fname : string) : Boolean;
 Var fptr : File;
Begin
  Assign(fptr, fname);
  { $I-; }
  Reset(fptr);
  Close(fptr);
  { $I+ }
  FileExist := ( IOresult = 0) AND (fname <> '');
End;


   { Size of a file / Taille d'un fichier }

Function FileLength(fname : string) : longint;
Var fptr : File;
    size_of_file : Longint;
Begin
 Assign(fptr, fname);
 Reset(fptr, 1);
 size_of_file := FileSize(fptr);
 Close(fptr);
 FileLength := size_of_file;
End;


{
  SPRITES LOAD
  Load a file of sprites and convert relatives addresses
  to absolute ones
  Input: Filename,
         Allocated memory size
         SPVECTOR a pointer on addresses or array

  Charge un fichier de sprites et
  convertit les adresses relatives en adresses absolues
  Entre: Nom du fichier
          Taille de mmoire alloue aux sprites
	  SPVECTOR pointeur sur les adresses ou tableau
}

Function sprites_load(filename: string; Maxmem: word): integer;
Label Finish;
var
 i:       Integer;
 arrsize: Word;
 SPRMAX:  Word;
 sprfile: File;
 result:  Word;
 ch :     Char;
 lus:     Word;
 Adr :    Pointer;

Begin
 if FileExist(filename) = False Then
 Begin
  Writeln(filename, ' no found....');
  SPRMAX := 0;
  goto Finish;
 End;

   { Reading the file header / Lecture de l'en-tte du fichier }

 Assign(sprfile, filename);
 Reset(sprfile, 1);
 Blockread(sprfile, FILEHEADER, Sizeof(FILEHEADER));
 SPRMAX    := FILEHEADER.spritenumber;
 FRAMESIZE := FILEHEADER.framenumber;

 If FRAMESIZE > 1 Then Arrsize := (MAXSPRITES + 5) * 4
 Else
  Begin
   Arrsize   := SPRMAX * 4 + 4;
   FRAMESIZE := 1;
  End;

  { Reading remaining array of sprite's addresses }
  { Lecture de la suite du tableau d'adresses des sprites }

 Reset(sprfile, 4);
 Seek(sprfile, 1);
 for i:= 1 to MAXSPRITES + 5 Do        { Number 0 is already loaded }
 Begin
   Blockread(sprfile, SPVECTOR[i], 1, result);
 End;

 { Reading code of sprites / Lecture de l'encodage des sprites }

 Reset(sprfile, 1);
 Seek(sprfile, arrsize + SizeOf(FILEHEADER));

 lus := 0;
 Adr := SPCODE;
 Repeat
  Blockread(sprfile, Adr^, 32768, result);
  Adr := AdjustPointer(Adr, 32768);
  lus := lus + result;
 until (result < 32768) OR (lus = BUFFERSIZE);

 close(sprfile);

  { Converting offset of sprites in the file to absolute adr. in memory }
  { Conversion des adr. relatives du fichier en adr. absolues en mmoire }

 For i := 1 To  MAXSPRITES Do
 Begin
   if (SPVECTOR[i] <> NIL) OR (i = 1) Then
   Begin
     SPVECTOR[i] := AdjustPointer(SPCODE, SPVECTORlong[i]);
   End;
 End;

Finish:
 sprites_load := SPRMAX;
End;


{
{  SPRITE ALLOC
{  Allocate memory for sprite file loading
{  Alloue la mmoire pour charger le fichier de sprites
}

Function Sprite_Alloc(AllocSize: word): Boolean;
Begin
 SPCODE := NIL;
 GetMem(SPCODE, AllocSize);
 Sprite_Alloc := seg(SPCODE^) <> 0;
End;

End.