#open "graphics";;
#open "turtle";;

let MX = 255;;
let nround x y = (2*x+y)/(2*y);;
let rgb_of_hsb(H, S, V) =
  let H = H*6 in
  let I = H/MX*MX in
  let F = H-I in
  let M = V*(MX-S)/MX and N = V*(MX-S*F/MX)/MX
  and K = V*(MX-S*(MX-F)/MX)/MX in
  (
    nround (MX*(
      match I/MX with
        0 | 6 -> V | 1 -> N | 2 -> M | 3 -> M | 4 -> K | 5 -> V
      | _ -> failwith "red_of_hsb"
    )) MX,
    nround (MX*(
      match I/MX with
        0 | 6 -> K | 1 -> V | 2 -> V | 3 -> N | 4 -> M | 5 -> M
      | _ -> failwith "green_of_hsb"
    )) MX,
    nround (MX*(
      match I/MX with
        0 | 6 -> M | 1 -> M | 2 -> K | 3 -> V | 4 -> V | 5 -> N
      | _ -> failwith "blue_of_hsb"
    )) MX
  )
;;

let coltab = vect_of_list (f 32)
  where rec f s =
    if s < 0 then []
    else
      let (r, g, b) = rgb_of_hsb (8 * s, 255, 255) in
      rgb r g b::f (s-1)
;;

let spira a l i = spir_rec a 0
  where rec spir_rec a c =
    if key_pressed() then () else begin
      color coltab.(c);
      forward l; right a;
      spir_rec (a+.i) ((c+1) mod (vect_length coltab))
    end
;;

let spirl a l i = spir_rec l 0
  where rec spir_rec l c =
    if key_pressed() then () else begin
      color coltab.(c);
      forward l; right a;
      spir_rec (l+.i) ((c+1) mod (vect_length coltab))
    end
;;

open_graph "";;
init ();;
hide ();;
width 5;;

if vect_length sys__command_line <> 4 
or sys__command_line.(1) = "-stdlib"
then begin (* Toplevel or no arguments. *)
     spira 178.0 7.0 (-17.5);
     read_key();
     init (); hide (); width 5;
     spirl 100.0 10.0 0.1;
     read_key();
     ()
end else begin (* Standalone with arguments. *)
     spira (float_of_string sys__command_line.(1))
	   (float_of_string sys__command_line.(2))
	   (float_of_string sys__command_line.(3));
     read_key();
     ()
end;
close_graph();;

