(* $Id$ *)

type token =
  Tident of string | Tinfix of string | Tint of int | Tchar of char
| Tfloat of float | Tstring of string | Tqualid of string * token
(* keywords *)
| Tand | Tas | Tbegin | Tdo | Tdone | Telse | Tend | Texception | Tfor
| Tfun | Tfunction | Tif | Tin | Tlet | Tmatch | Tmutable | Tof | Tor | Tprefix
| Trec | Tthen | Tto | Ttry | Ttype | Tvalue | Twhere | Twhile | Twith
(* sequences of special characters *)
| Tampersand | Tat | Tbang | Tbangequal | Tbar | Tbarrbracket | Tcaret | Tcolon
| Tcoloncolon | Tcolonequal | Tcomma | Tdot | Tdotdot | Tdotlparen
| Tequal | Tequalequal | Tgreater | Tgreaterequal | Tgreaterrbracket
| Tlbrace | Tlbracket | Tlbracketbar | Tlbracketless | Tless | Tlessequal
| Tlessgreater | Tlessminus | Tlparen | Tminus | Tminusgreater | Tplus
| Tquote | Trbrace | Trbracket | Trparen | Tsemi | Tsemisemi | Tsharp
| Tslash | Tstar | Tunderscore
;;

value add_infix : string -> unit;;
value remove_infix : string -> unit;;

exception Lex_error;;
value next_token : char stream -> token;;
