/*\c
 * \secb{Declarations for lx2l_ini}
 * Copyright (C) 1995 -- 1998  Michael Plugge (m.plugge@fh-mannheim.de)
 *
 * This file is part of the cvt2ltx package, a package of LaTeX
 * converters. The whole package is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License. See the files
 * config.h and COPYING for further details.
 */

%{
#define BUFSIZE 32768         /* main buffer size */
#define MAX_CONDITIONALS 200  /* limit for number of conditionals */

#if VMS
#  include <unixio.h>
#endif
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#if VMS
#  undef ECHO
#  define ECHO (yyleng==1) ? fputc(*yytext,yyout) : fprintf(yyout,"%s",yytext)
#endif

#define COND_NO 1
#define COND_YES 2
#define COND_UNDEFINED 8
#define COND_NOT_SET 16
#define CON1 MAX_CONDITIONALS+1

char *ptr,*ptr1,*mptr,*bu_ptr,*cptr,*filename="lx2l.lxx",*def_name[CON1],
   current_condition[CON1],condition[CON1],old_current,current_valid=1,
   default_value,valid,need_cfgfile,lx_only;

int i,idx,ret_val,skip_start,skip_startline,c_mode,sc;
long line=1;

int die(char *cmd,int mode);
int get_condition_index(char *ptr);
void check_list_condition(void);
void check_all_conditions(void);
void second_definition(int i,char *filename,int line);
%}

WS     [ \t\n]
SP     [ \t]+
SPO    [ \t]*
CONDITION_NAME [A-Z][A-Z0-9$_]*
CNN            {CONDITION_NAME}(\,{CONDITION_NAME})*
CMODE          (#|[+-]{1,2})
CONDITIONAL    \{!@@#[A-Z][A-Z0-9$_]*
COND_LIST      \{!@@[&|]{CMODE}{CNN}(\,?{CMODE}{CNN})*\}
LX_CONDITIONAL \{!@@#{CONDITION_NAME}(\+|\-|#|"++"|"--"|"+-")\}

%x DECLARE DECLARE_VALUE SKIP CONDITION_LIST_AND CONDITION_LIST_OR
%option 8bit noyywrap never-interactive outfile="lx2l_ini.c"

%%

   BEGIN(DECLARE);

<INITIAL,DECLARE,DECLARE_VALUE>"{@@##}\n"{SPO}  /* continuation line; ignore */
<SKIP,DECLARE,INITIAL>{
 {LX_CONDITIONAL} {
      for(ptr=yytext+5,ptr1=bu_ptr;*ptr!='+' && *ptr!='-' && *ptr!='#';)*ptr1++= *ptr++;
      *ptr1=0;
      i=get_condition_index(bu_ptr);
      if(!condition[i] && *ptr!='#'){
         fprintf(stderr,"warning: condition %s not defined in line %ld of %s\n",
            yytext,line,filename);
         valid=0;
         ret_val|=2;
      }
      else switch(*ptr){
         case '+':
            valid=condition[i]&COND_YES;  /* {@@#NAME+} */
            break;
         case '-':
            valid=condition[i]&COND_NO; /* {@@#NAME-} */
           break;
         case '#':
            valid=1;
            break;
         default:
            valid=0;
            break;
      }
      old_current=current_valid;
      current_condition[i]=valid;
      if(current_valid && !valid)current_valid=0;
      if(!current_valid && valid)   /* check all conditions */
         for(cptr=current_condition,current_valid=1;cptr<current_condition+MAX_CONDITIONALS;)
            if(!*cptr++)current_valid=0;  /* found an invalid condition */
      if(old_current && !current_valid)BEGIN(SKIP);
      if(!old_current && current_valid){
         BEGIN(skip_start);
         current_valid=1;
      }
      if(*(yytext+yyleng-1)=='\n')line++;
   }
 {COND_LIST} {
      sc=YY_START;
      if(*(yytext+4)=='&')
         BEGIN(CONDITION_LIST_AND);
      else
         BEGIN(CONDITION_LIST_OR);
      yyless(5);
   }
}

<CONDITION_LIST_AND,CONDITION_LIST_OR>\,    /* ignore */
<CONDITION_LIST_AND>{
 {CONDITION_NAME} check_list_condition();
 "#"     c_mode=0;
 "+"     c_mode=1;
 "++"    c_mode=2;
 "+-"    c_mode=3;
 "-"     c_mode=4;
 "--"    c_mode=5;
 \}      check_all_conditions();
}

<SKIP,DECLARE>{
 [{!@]       /* ignore */
 [^{!@\n]+   /* ignore */
 \n         line++;
}

<DECLARE>{
 ^"{@@-}"{SPO}\n {   /* beginning of part 2 of the lx file */
      line++;
      BEGIN(INITIAL);
   }
 ^"@@#"{SP}{CONDITION_NAME} {
      for(ptr=yytext+3;*ptr==' '||*ptr=='\t';ptr++);
      for(ptr1=bu_ptr;*ptr1++= *ptr++;);
      idx=get_condition_index(bu_ptr);
      default_value=0;
      BEGIN(DECLARE_VALUE);
   }
}

<DECLARE_VALUE>{
 {SP}   /* skip */
 {SP}("default"|"DEFAULT"){SPO}={SPO}  default_value=1;
 \n line++; BEGIN(DECLARE); if(condition[idx]==COND_NOT_SET)condition[idx]=COND_UNDEFINED;
 [01] |   /* numeric: 0=NO, 1=YES */
 "NO"|"YES" {
      if(condition[idx]==COND_NOT_SET){   /* the condition is not set */
            switch(*yytext){
               case 'N':
               case '0':
                  condition[idx]=COND_NO;
                  break;
               case '1':
               case 'Y':
                  condition[idx]=COND_YES;
                  break;
               default:  /* this should never occur, but who knows... */
                  break;
            }
      }
      else
         if(!default_value)second_definition(idx,filename,line);
      if(condition[idx]==COND_NOT_SET)condition[idx]=COND_UNDEFINED;
      BEGIN(DECLARE);
   }
 .  BEGIN(DECLARE); if(condition[idx]==COND_NOT_SET)condition[idx]=COND_UNDEFINED;
}

\n+ {
      if(!lx_only)
         ECHO; 
      else{
         line++;
         for(ptr=yytext+1;*ptr;ptr++){
            line++;
            fputc(*ptr,yyout);
         }
      }
      lx_only=1; 
   }
\{       |
[^{\n]+  lx_only=0; ECHO;

%%

int get_condition_index(char *ptr)
{
   int i;

   for(i=0;i<MAX_CONDITIONALS && def_name[i];i++)
      if(strcmp(def_name[i],ptr)==0)return(i);
   if(YY_START!=DECLARE){
      fprintf(stderr,"Warning: condition %s is not defined in line %ld of %s\n",
         ptr,line,filename);
      ret_val|=4;
      return(0);
   }
   if(ptr!=bu_ptr)strcpy(bu_ptr,ptr);
   def_name[i]=bu_ptr;
   bu_ptr+=strlen(bu_ptr)+1;
   return(i);
}

void second_definition(int i,char *filename,int line)
{
   fprintf(stderr,"warning: %s redefined in %s line %d; use old value ",
      def_name[i],filename,line);
   switch(condition[i]){
      case COND_NO: fprintf(stderr,"NO\n"); break;
      case COND_YES: fprintf(stderr,"YES\n"); break;
      default: fprintf(stderr,"(%d)\n",condition[i]); break;
   }
}

void check_list_condition(void)
{
   i=get_condition_index(yytext);
   if(!condition[i] && c_mode){
      fprintf(stderr,"warning: condition %s not defined in line %ld of %s\n",
         yytext,line,filename);
      valid=0;
      ret_val|=2;
   }
   else switch(c_mode){
      case 0: /* {@@#NAME#} */
         valid=1;
         break;
      case 1: /* {@@#NAME+} */
         valid=condition[i]&COND_YES;
         break;
      case 4:  /* {@@#NAME-} */
         valid=condition[i]&COND_NO;
         break;
      default:
         valid=0;
         break;
   }
   current_condition[i]=valid;
}

void check_all_conditions(void)
{
   old_current=current_valid;
   if(current_valid && !valid)current_valid=0;
   for(cptr=current_condition,current_valid=1;cptr<current_condition+MAX_CONDITIONALS;)
      if(!*cptr++)current_valid=0;  /* found an invalid condition */
   if(!current_valid){
      if(old_current)skip_start=sc;
      BEGIN(SKIP);
   }
   else if(!old_current && current_valid){
      BEGIN(skip_start);
      current_valid=1;
   }
   else
      BEGIN(sc);
}

int die(char *cmd,int mode)
{
   switch(mode){
      case 1:
         fprintf(stderr,"Can't open %s for read; exit\n",cmd);
         exit(4);
      case 2:
         fprintf(stderr,"Can't open %s for write; exit\n",cmd);
         exit(4);
      case 3:
         fprintf(stderr,"%s\n",cmd);
         exit(4);
      default:
         return 0;
   }
}

main(int argc,char **argv)
{
#if VMS
   ret_val=1;
#else
   ret_val=0;
#endif
   bu_ptr=calloc(BUFSIZE,1);
   for(i=1;i<=MAX_CONDITIONALS;i++){
      condition[i]=COND_NOT_SET;
      current_condition[i]=COND_UNDEFINED;
   }
   def_name[0]="NEVER"; /* dummy condition: always false */
   condition[0]=current_condition[0]=4;
   (yyin=fopen("lx2l.lxx","r")) || die("lx2l.lxx",1);
   (yyout=fopen("lx2l.l","w")) || die("lx2l.l",2);
#ifdef FLEX_DEBUG
   if(yy_flex_debug){
      fprintf(stderr,"redirect stderr to file lx2l_ini.dbg\n");
      freopen("lx2l_ini.dbg","w",stderr);
   }
#endif   /* FLEX_DEBUG */
   yylex();
   fclose(yyin);
   fclose(yyout);
   return(ret_val);
}
