#   Syntax10.Scn.Fnt  	   	  MODULE Biorhythm; (*J. Gutknecht, 10.7.92*)
  IMPORT In, Out;

  (* Call Biorhythm.Show day month year month year,
      where first date is birth date and second date is desired month,
      for example Biorhythm.Show 14 3 1879 4 1955 *)

  VAR
    I: ARRAY 33 OF INTEGER; (*intellectual cycle*) 
    E: ARRAY 28 OF INTEGER; (*emotional cycle*)
    P: ARRAY 23 OF INTEGER; (*physical cycle*) 
    M: ARRAY 12 OF INTEGER; (*accumulated days*)

  PROCEDURE NofDays (d, m, y: LONGINT): LONGINT;
  BEGIN
    IF y = 0 THEN RETURN M[m-1] + d - 1
    ELSE
      IF (y MOD 4 = 0) & (m > 2) THEN INC(d) END;
      RETURN y*365 + (y - 1) DIV 4 + M[m-1] + d - 1
    END
  END NofDays;

  PROCEDURE Show*;
    VAR b, c, d, m, n: INTEGER; N: LONGINT;
  BEGIN
    In.Open; In.Int(d); In.Int(m); In.Int(b); In.Int(n); In.Int(c);
    N := (b DIV 100 - c DIV 100)*36524
      + NofDays(1, n, c MOD 100) - NofDays(d, m, b MOD 100);
    d := 1;
    REPEAT
      Out.String("day = "); Out.Int(d, 1);
      Out.String("   I = "); Out.Int(I[N MOD 33], 1);
      Out.String("   E = " ); Out.Int(E[N MOD 28], 1);
      Out.String("   P = "); Out.Int(P[N MOD 23], 1);
      Out.Ln;
      INC(d); INC(N)
    UNTIL d = 32;
    Out.Ln
  END Show;

BEGIN
  M[0] := 0; M[1] := 31; M[2] := 59; M[3] := 90; M[4] := 120;
  M[5] := 151; M[6] := 181; M[7] := 212; M[8] := 243; M[9] := 273;
  M[10] := 304; M[11] := 334;

  I[0] := 0; I[1] := 19; I[2] := 37; I[3] := 54; I[4] := 69;
  I[5] := 81; I[6] := 91; I[7] := 97; I[8] := 100; I[9] := 99;
  I[10] := 95; I[11] := 87; I[12] := 76; I[13] := 62; I[14] := 46;
  I[15] := 28; I[16] := 10; I[17] := -10; I[18] := -28; I[19] := -46;
  I[20] := -62; I[21] := -76; I[22] := -87; I[23] := -94; I[24] := -99;
  I[25] := -100; I[26] := -97; I[27] := -91; I[28] := -81; I[29] := -69;
  I[30] := -54; I[31] := -37; I[32] := -19;

  E[0] := 0; E[1] := 22; E[2] := 43; E[3] := 62; E[4] := 78;
  E[5] := 90; E[6] := 97; E[7] := 100; E[8] := 97; E[9] := 90;
  E[10] := 78; E[11] := 62; E[12] := 43; E[13] := 22; E[14] := 0;
  E[15] := -22; E[16] := -43; E[17] := -62; E[18] := -78; E[19] := -90;
  E[20] := -97; E[21] := -100; E[22] := -97; E[23] := -90; E[24] := -78;
  E[25] := -62; E[26] := -43; E[27] := -22;

  P[0] := 0; P[1] := 27; P[2] := 52; P[3] := 73; P[4] := 89;
  P[5] := 98; P[6] := 100; P[7] := 94; P[8] := 82; P[9] := 63;
  P[10] := 40; P[11] := 14; P[12] := -14; P[13] := -40; P[14] := -63;
  P[15] := -82; P[16] := -94; P[17] := -100; P[18] := -98; P[19] := -89;
  P[20] := -73; P[21] := -52; P[22] := -27
END Biorhythm.

