//******************************************************************************
// PLC: MAIN (& COMPILER)                                                     **
//                                                                            **
// Copyright 1997 Adept Software, All Rights Reserved                         **
//******************************************************************************

#ifndef PLC_MAIN_H
	#define PLC_MAIN_H
	#if defined (INTERNAL_SETUP) || defined (PLC_MAIN_C)
		#include "_PLC_Set.H"
	#endif

	#include "Adept.H"
	#include "PLC_DT.H"

//**************************************
// GLOBAL CONSTANTS

	// ENVIRONMENT (controls scope)
	struct PLC_ENVIR
	{
		LNK_LINK		Link;
		struct PLC_ENVIR	*Parent;
		LNK_LINK		List_Tokens,
						List_Envirs,
						List_DataTypes,
						List_Symbols,
						List_Variables,
						List_Routines;
	};
	typedef struct PLC_ENVIR PLC_ENVIR;

	// SYMBOL
	#define PLC_SYMBOL_NAMEMAX		32
	typedef struct
	{
		LNK_LINK		Link;
		byte			Name[PLC_SYMBOL_NAMEMAX+1];
		byte			Extra[4];
			#define PLC_SYMBOL__TOKEN(Symbol)		( ((PLC_TOKEN**)((Symbol)->Extra))[0] )
	} PLC_SYMBOL;

	// VARIABLE
	typedef struct
	{
		LNK_LINK		Link;
		PLC_SYMBOL		*Symbol;
		PLC_DATATYPE	DataType;
	} PLC_VARIABLE;

	// ROUTINE
	typedef struct
	{
		LNK_LINK		Link;
		PLC_SYMBOL		*Symbol;
		PLC_ENVIR		*Envir;
		void			(*CommandPtr)(LNK_LINK *);
		LNK_LINK		List_Parms;
	} PLC_ROUTINE;

	// TOKEN
	typedef struct
	{
		LNK_LINK	Link;
		// TYPES
		enum
		{
			PLC_TT_NONE=0,
			// STATEMENT ELEMENTS
			PLC_TT_COMPOUND,
			PLC_TT_EXPRESSION,
			PLC_TT_KEYWORD,
			PLC_TT_LABEL,

			// EXPRESSION ELEMENTS
			PLC_TT_OPERATOR,
			PLC_TT_DATATYPE,
			PLC_TT_VARIABLE,
			PLC_TT_ROUTINE,
			PLC_TT_SYMBOL,
			PLC_TT_PARMLIST,
		} Type;
		enum
		{
			// variables
			PLC_TT_NORMAL=0,
			PLC_TT_NEW,
		} SubType;
		word	LineNum;
		byte		Extra[sizeof(LNK_LINK)];
			#define PLC_TOK_Anchor(Token)	((LNK_LINK*)(Token)->Extra)
			#define PLC_TOK_Pointer(Token)	(_voidptr((Token)->Extra[0]))
	} PLC_TOKEN;

	#define PLC_COMMON_STRMAX		80
	typedef struct
	{
		// single char
		byte	*ParmSeparator,
				*ParmOpen,*ParmClose,
				*ExprOpen,*ExprClose,
				*StringOpen,*StringClose;
		// char list
		byte	*Whitespace,*EndLine,
				*StatementTerminator,*DeclarationTerminator,
				*Number,*DataTypeStart,
				*Symbol,*SymbolStart;
		// string
		byte	*CommentLine,
				*CommentStart,*CommentEnd,
				*CompoundOpen,*CompoundClose,
				*LabelOpen,*LabelClose,
				*KeyOpen,*KeyClose,
				*KeyDivider;
	} PLC_COMMON;

	#define PLC_KEYWORD_NAMEMAX		12
	#define PLC_KEYWORD_FORMATMAX	15
	typedef struct
	{
		byte	Name[PLC_KEYWORD_NAMEMAX+1],
				String1[PLC_KEYWORD_NAMEMAX+1],String2[PLC_KEYWORD_NAMEMAX+1];
		enum
		{
			PLC_KEY_DONE,
			PLC_KEY_STRING1,PLC_KEY_STRING2,
			PLC_KEY_OPEN,PLC_KEY_CLOSE,PLC_KEY_DIVIDER,
			PLC_KEY_STATEMENT,
			PLC_KEY_EXPRESSION,
			PLC_KEY_SYMBOL,
			PLC_KEY_DATATYPE,
		} Format[PLC_KEYWORD_FORMATMAX];
	} PLC_KEYWORD;

	#define PLC_OPERATOR_NAMEMAX		12
	typedef struct
	{
		byte	Name[PLC_OPERATOR_NAMEMAX+1];
		byte	Precedence;
		flag	Reverse;
		enum
		{
			PLC_OP_PREV,PLC_OP_NEXT,
			PLC_OP_PREVIFNONEXT,PLC_OP_NEXTIFNOPREV,	// operator used only if there is nothing on one side
			PLC_OP_BOTH,
		}Type;
	} PLC_OPERATOR;

	//**************************************
	// ERROR SYSTEM
	enum
	{
		PLC_STATE_NONE,
		PLC_STATE_COMPILING,
		PLC_STATE_EXECUTING,
		PLC_STATE_CUSTOM,
	};

	typedef enum
	{
		PLC_ERR_FATAL,

		PLC_ERR_OUT_OF_,
		PLC_ERR_UNEXPECTED_EOB,

		PLC_ERR_ERROR,

		PLC_ERR_SYNTAX,PLC_ERR_SYNTAXNEAR_,
		PLC_ERR_EXPECTING_SYMBOL,
		PLC_ERR_EXPECTING_,
		PLC_ERR_EXPECTING_ITEM_,
		PLC_ERR_EXPECTING_TYPE_,
		PLC_ERR_UNKNOWN_SYMBOL_,
		PLC_ERR_UNKNOWN_ROUTINE_,
		PLC_ERR_SYMBOL_EXISTS_,
		PLC_ERR_PARM_WRONGNUM,PLC_ERR_PARMS,
		PLC_ERR_ILLEGAL_OPERATION,
		PLC_ERR_ILLEGAL_ASSIGNMENT,
		PLC_ERR_INVALID_COMPARISON,
		PLC_ERR_UNKNOWN_CHARACTER,
		PLC_ERR_STRING_TOO_LONG,
		PLC_ERR_DIV_ZERO,

		PLC_ERR_WARNING,

		PLC_ERR_VARIABLE_REFERENCED_,
	} PLC_ERR_VALUE;

//**************************************
// GLOBAL VARIABLES

	#undef GLOBAL
	#ifdef PLC_MAIN_C
		#define GLOBAL
	#else
		#define GLOBAL	extern
	#endif

	GLOBAL	PLC_ENVIR	*PLC_Envir,*PLC_EnvirGlobal;
	GLOBAL	byte		PLC_ErrState;
	GLOBAL	byte		*PLC_SourceBuf;
	GLOBAL	dword		PLC_SourceLine;
	GLOBAL	byte		PLC_KeywordMax,PLC_OperatorMax;
	GLOBAL	PLC_COMMON	PLC_Common;
	GLOBAL	PLC_KEYWORD		*PLC_Keywords;
	GLOBAL	PLC_OPERATOR	*PLC_Operators;
	GLOBAL	void			(*PLC_Preprocess)(void);

//**************************************
// GLOBAL	ROUTINE PROTOTYPES

	// SETUP
	void	PLC_Startup			(dword EnvirMax,dword DataTypeMax,dword SymbolMax,dword VariableMax,dword RoutineMax,dword TokenMax);
	void	PLC_Shutdown		(void);
	void	PLC_Reset			(void);

	// COMPILATION
	void	PLC_Compile			(byte *SourceBuf);
	void	PLC_CompileStatements	(byte *RoutineName,byte *SourceBuf);

	// COMMANDS
	void	PLC_AddCommand		(byte *Name,void (*Routine)(LNK_LINK*),byte ParmCount);
	byte	PLC_GetParms		(flag VarParms,LNK_LINK *DataTypeList,PLC_DATATYPE *Parms[],byte ParmCount);
	void	PLC_Err				(PLC_ERR_VALUE ErrVal,...);

#endif
