//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW IDE                       |
// |  File:        OPTIONS.CPP                          |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Options Manager implementation       |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_stdio
#define uses_string

#define uses_app
#define uses_check
#define uses_combo
#define uses_editor
#define uses_hist
#define uses_ht
#define uses_icons
#define uses_input
#define uses_stddlg
#define uses_system
#define uses_table
#define uses_txt

#include "PVUSES.H"
#include "W.H"
#include "TLOG.H"
#include "TPROJECT.H"
#include "COMPILE.H"

#define _DECLARE_OPTIONS_H
  #include "OPTIONS.H"
#undef  _DECLARE_OPTIONS_H


/*
STATIC DATA
*/
  static char pvo_signature[] = "\r\nPower View IDE options file.\r\n\032";


#pragma off( unreferenced )
  static Tcombo_box *of_target, *of_calls, *of_cpu, *of_debug, *of_optimize;
  static void options_fast_handler( Titem *p )
  {
    of_optimize->set_state( isDISABLED, (compiler_options.debug_options&doOPTIMIZATIONS) && of_debug->cursor() );
    of_cpu->set_enable( 0, of_target->cursor()<7 );
    of_cpu->set_enable( 1, of_target->cursor()<7 );
    of_cpu->set_enable( 2, of_target->cursor()<7 );
    of_calls->set_enable( 0, of_target->cursor()>6 );
    if( !of_cpu  ->enabled(of_cpu  ->cursor()) ) of_cpu  ->set_data( 5 );
    if( !of_calls->enabled(of_calls->cursor()) ) of_calls->set_data( 1 );
  }
#pragma on( unreferenced )

void options_fast( void )
{
  uint cpu=compiler_options.cpu-1,
       calls=compiler_options.calling_conventions-1,
       model=compiler_options.memory_model-1,
       align=compiler_options.alignment-1,
       optimize=(compiler_options.options&opOPTIMIZATIONS)? compiler_options.optimize_for : 0,
       debug=(compiler_options.options&opDEBUG_INFO)? compiler_options.debug_level : 0,
       fp=compiler_options.fp_instructions-1,
       target=linker_options.target_os? linker_options.target_os-1 : 0;
  _help( htD_FAST_OPTIONS );
  dialog( "Fast compiler/linker options" ); hspacing( 4 );
  handler( options_fast_handler );
  of_target = combo_box( "|~Target ", target, 35 );
  for( uint i=1; i<TO_COUNT; i++ )
    of_target->add( target_os[i].title );
  push();
  _combo_lines( 6 );
  of_cpu = combo_box( "C|~PU    ", cpu, 7 );
    of_cpu->add( "8086" );
    of_cpu->add( "80186" );
    of_cpu->add( "80286" );
    of_cpu->add( "80386" );
    of_cpu->add( "80486" );
    of_cpu->add( "Pentium" );
  _combo_lines( 2 );
  of_calls = combo_box( "|~Calls  ", calls, 7 );
    of_calls->add( "Regs" );
    of_calls->add( "Stack" );
  _combo_lines( 5 );
  Tcombo_box *of_model = combo_box( "|~Model  ", model, 7 );
    of_model->add( "Small" );
    of_model->add( "Medium" );
    of_model->add( "Compact" );
    of_model->add( "Large" );
    of_model->add( "Flat" );
  _combo_lines( 4 );
  Tcombo_box *of_align = combo_box( "|~Align  ", align, 7 );
    of_align->add( "Byte" );
    of_align->add( "Word" );
    of_align->add( "Dword" );
    of_align->add( "Qword" );
  nc();
  _combo_lines( 4 );
  of_optimize = combo_box( "|~Optimize", optimize, 10 );
    of_optimize->add( "OFF" );
    of_optimize->add( "Speed" );
    of_optimize->add( "Size" );
    of_optimize->add( "Speed/Size" );
  _combo_lines( 3 );
  of_debug = combo_box( "De|~bug   ", debug, 10 );
    of_debug->add( "OFF" );
    of_debug->add( "Lines" );
    of_debug->add( "Full" );
  _combo_lines( 3 );
  Tcombo_box *of_float = combo_box( "|~FP      ", fp, 10 );
    of_float->add( "Calls" );
    of_float->add( "Emulation" );
    of_float->add( "Inline" );
  linput( "|~Stack   ", linker_options.stack_size, 1024, 0x10000000 );
  pop(); hor(); hspacing( 2 );
  _history( &compiler_options.defines );
  input( "|~Defines", compiler_options.defines, 127, 34 );
  nl();
  cinput( "|~Warnings level", compiler_options.warn_level, 0,   4 );
  hspaces( 4 );
  cinput( "|~Errors limit",   compiler_options.max_errors, 1, 255 );
  nl();
  check( "Warnings a|~re errors",  compiler_options.debug_options, doWARN_IS_ERR );
  check( "Precompiled |~headers", compiler_options.options, opPRECOMPILE );
  options_fast_handler( NULL );
  if( bkch() )
  {
    options_changed = 1;
    compiler_options.code_size = target>6? cs32BITS : cs16BITS;
    linker_options.target_os=++target,
    compiler_options.cpu=++cpu,
    compiler_options.calling_conventions=++calls,
    compiler_options.memory_model=++model,
    compiler_options.alignment=++align,
    compiler_options.fp_instructions=++fp;
    switch( compiler_options.memory_model )
    {
      case mmSMALL:
      case mmMEDIUM:
      case mmFLAT_HUGE:
        compiler_options.ds_segment = dsPEGGED;
        compiler_options.fsgsss_segments = 0;
        break;
      default:
        compiler_options.ds_segment = dsFLOATS;
        compiler_options.fsgsss_segments = ssNEQDGROUP;
        break;
    }
    if( !of_optimize->state( isDISABLED ) )
      if( optimize )
      {
        compiler_options.optimize_for=optimize,
        compiler_options.options|=opOPTIMIZATIONS,
        compiler_options.optimizations|=opLOOP|opREORDER|opCALLRET|opRELAX|opNUMERICALLY|opPENTIUM;
        if( optimize==1 )
          compiler_options.optimizations|=opINLINE|opINTRINSIC;
        else
          compiler_options.optimizations&=~(opINLINE|opINTRINSIC|opUSER);
      }
      else
        compiler_options.options&=~opOPTIMIZATIONS;
    if( debug )
      compiler_options.debug_level=debug,
      compiler_options.options|=opDEBUG_INFO;
    else
      compiler_options.options&=~opDEBUG_INFO;
  }
}


/*
COMPILER
*/
    static Tradio *r16, *r32, *r086, *r186, *r286, *r386, *calls_stack, *calls_regs, *rm_flat;
    static void occg_handler( Titem *p )
    {
      boolean m16 = ( p == r16 );
      boolean m32 = ( p == r32 );
      if( !m16 && !m32 ) return;
      if( m16 )
      {
        calls_stack->press();
        rm_flat->set_prompt( "|~Huge" );
      }
      else
      {
        if( r086->pressed() || r186->pressed() || r286->pressed() ) r386->press();
        rm_flat->set_prompt( "|~Flat" );
      }
      r086->set_state( isDISABLED, m32 );
      r186->set_state( isDISABLED, m32 );
      r286->set_state( isDISABLED, m32 );
      calls_regs->set_state( isDISABLED, m16 );
    }

  void options_compiler_code_generation( void )
  {
    _help( htD_CODE_GENERATION );
    dialog( "Code generation" ); handler( occg_handler );
    hspacing( 1 );
    frame( "Memory model" );
                radio( "|~Small",      compiler_options.memory_model, mmSMALL     );
                radio( "|~Medium",     compiler_options.memory_model, mmMEDIUM    );
                radio( "|~Compact   ", compiler_options.memory_model, mmCOMPACT   );
                radio( "|~Large",      compiler_options.memory_model, mmLARGE     );
      rm_flat = radio( "|~Flat",       compiler_options.memory_model, mmFLAT_HUGE );
    endfr();
    nc();
    frame( "CPU" );
      r086 = radio( "8|~086",      compiler_options.cpu, cp8086  );
      r186 = radio( "80|~186",     compiler_options.cpu, cp80186 );
      r286 = radio( "80|~286",     compiler_options.cpu, cp80286 );
      r386 = radio( "80|~386",     compiler_options.cpu, cp80386 );
             radio( "80|~486",     compiler_options.cpu, cp80486 );
             radio( "|~Pentium  ", compiler_options.cpu, cp80586 );
    endfr();
    nc();
    frame( "Code size" );
      r16 = radio( "1|~6 bit   ", compiler_options.code_size, cs16BITS );
      r32 = radio( "32 b|~it", compiler_options.code_size, cs32BITS );
    endfr();
    frame( "Calls" );
      calls_stack = radio( "S|~tack    ", compiler_options.calling_conventions, ccSTACK    );
      calls_regs  = radio( "|~Registers",   compiler_options.calling_conventions, ccREGISTER );
    endfr();
    nl(); hor();
    _history( &compiler_options.defines );
    _focused(); input( "|~Defines", compiler_options.defines, 127, 34 );
    nl();
    linput( "F|~ar data", compiler_options.far_data_threshold, 0, 0xFFFFF );
    input( "|~Other", compiler_options.other, 127, 17 );
    occg_handler( ( compiler_options.code_size == cs16BITS )? r16 : r32 );
    if( bkch() ) options_changed = 1;
  }

  void options_compiler_advanced_code_generation( void )
  {
    _help( htD_ADV_CODE_GENERATION );
    dialog( "Advanced code generation" );
    frame( "Options" );
      check( "|~Use precompiled heades",                            compiler_options.options, opPRECOMPILE     );
      check( "C|~hange characters default to signed  ",             compiler_options.options, opSIGNED_CHARS   );
      check( "Force all |~enums to be type int",                    compiler_options.options, opENUMS_AS_INTS  );
      check( "|~All functions must have unique addresses",          compiler_options.options, opUNIQUE         );
      check( "|~Generate function prototypes using base types",     compiler_options.options, opBASE_TYPES     );
      check( "Generate |~calls to grow the stack",                  compiler_options.options, opCALLS2GROW     );
      check( "|~NULL points to valid memory",                       compiler_options.options, opNULLVALID      );
      check( "|~Output function declarations to .def",              compiler_options.options, opOUTPUTDECL     );
      check( "|~Promote to int all function arguments and returns", compiler_options.options, opINTARGS        );
      check( "Place |~literal strings in the code segment",         compiler_options.options, opLITERALSINCODE );
      check( "Place each |~function in separate segment",           compiler_options.options, opSEPARATESEG    );
      check( "|~Save/restore segment registers across calls",       compiler_options.options, opSAVESEGS       );
      check( "S|~yntax check only - no .OBJ output",                compiler_options.options, opSYNTAXONLY     );
      check( "|~Touch stack through SS first",                      compiler_options.options, opTOUCHSTACK     );
    endfr();
    if( bkch() ) options_changed = 1;
  }

  void options_compiler_target( void )
  {
    _help( htD_COMPILER_TARGET );
    dialog( "Build target" );

    _combo_lines( 7 );
    _acenter();
    Tcombo_box *bt = combo_box( "|~Target OS", compiler_options.build_target, 10 );
    for( uint i=0; i<BT_COUNT; i++ )
      bt->add( build_target[i].title );
    check( "|~Multi thread environment",      compiler_options.optimizations, opMULTI_THREAD );
    check( "|~Dynamic link library",          compiler_options.optimizations, opDLL          );
    check( "Default |~windowing application", compiler_options.optimizations, opDEFAULT_WIN  );
    if( bkch() ) options_changed = 1;
  }

#define cmFASTEST_CODE  cmUSER00
#define cmSMALLEST_CODE cmUSER01
    static Tdialog *oco_dialog;
    static Tcheck *oco_checks[12];
    static Tradio *oco_radios[7];
    static Tiinput *oco_input1;
    static Tcheck *oco_control;
    boolean options_compiler_optimizations_validator( uint command )
    {
      if( command == cmFASTEST_CODE )
      {
        oco_checks[ 0]->press( 1 );
        oco_checks[ 2]->press( 1 );
        oco_checks[ 3]->press( 1 );
        oco_checks[ 4]->press( 1 );
        oco_checks[ 5]->press( 1 );
        oco_checks[ 7]->press( 1 );
        oco_checks[ 8]->press( 0 );
        oco_checks[ 9]->press( compiler_options.cpu == cp80586 );
        oco_checks[10]->press( 1 );
        oco_radios[ 3]->press( 1 );
        oco_radios[ 4]->press( 1 );
        return 0;
      }
      if( command == cmSMALLEST_CODE )
      {
        oco_checks[ 0]->press( 1 );
        oco_checks[ 1]->press( 0 );
        oco_checks[ 2]->press( 1 );
        oco_checks[ 3]->press( 1 );
        oco_checks[ 4]->press( 1 );
        oco_checks[ 5]->press( 1 );
        oco_checks[ 7]->press( 0 );
        oco_checks[ 8]->press( 0 );
        oco_checks[ 9]->press( compiler_options.cpu == cp80586 );
        oco_checks[10]->press( 0 );
        oco_checks[11]->press( 0 );
        oco_radios[ 0]->press( 1 );
        oco_radios[ 5]->press( 1 );
        return 0;
      }
      return 1;
    }

    static void oco_handler( Titem *p )
    {
      if( p==oco_control )
      {
        boolean fl = !oco_control->pressed();
        for( int i=0; i<12; i++ )
          oco_checks[i]->set_state( isDISABLED, fl );
        for(     i=0; i<7; i++ )
          oco_radios[i]->set_state( isDISABLED, fl );
        oco_input1 ->set_state( isDISABLED, fl );
        oco_dialog->cstate( cmFASTEST_CODE, !fl );
        oco_dialog->cstate( cmSMALLEST_CODE, !fl );
      }
    }

  void options_compiler_optimizations( void )
  {
    if( (compiler_options.options&opDEBUG_INFO) && (compiler_options.debug_options&doOPTIMIZATIONS) )
    {
      _palert();
      ok( "Optimizations are disabled.\n\nTo enable optimizations, uncheck <Disable optimizations> check box from Debugging Information dialog." );
      return;
    }
    _help( htD_OPTIMIZATIONS );
    oco_dialog = dialog( "Optimizations" );
    validator( options_compiler_optimizations_validator );
    handler( oco_handler );
    hspacing( 1 );
    frame( "Options" );
      oco_checks[ 0] = check( "|~1 Loop optimizations",                         compiler_options.optimizations, opLOOP        );
      oco_checks[ 1] = check( "|~2 Loop unrolling optimizations",               compiler_options.optimizations, opLOOPUNROLL  );
      oco_checks[ 2] = check( "|~3 Reorder instructions for best pipeline",     compiler_options.optimizations, opREORDER     );
      oco_checks[ 3] = check( "|~4 <Call followed by ret>=<jump> optimization", compiler_options.optimizations, opCALLRET     );
      oco_checks[ 4] = check( "|~5 Relax aliasing constraints",                 compiler_options.optimizations, opRELAX       );
      oco_checks[ 5] = check( "|~6 Numerically unstable optimizations",         compiler_options.optimizations, opNUMERICALLY );
      oco_checks[ 6] = check( "|~7 Continue compilation if low on memory",      compiler_options.optimizations, opLOWMEM      );
    endfr();
    nc();
    frame( "Members alignment" );
      ver();
      oco_radios[ 0] = radio( "|~Byte",  compiler_options.alignment, alBYTE  );
      oco_radios[ 1] = radio( "|~Word",  compiler_options.alignment, alWORD  );
      nc();
      oco_radios[ 2] = radio( "|~Dword", compiler_options.alignment, alDWORD );
      oco_radios[ 3] = radio( "|~Qword", compiler_options.alignment, alQWORD );
    endfr();
    frame( "Optimize for" );
      ver();
      oco_radios[ 4] = radio( "S|~peed",          compiler_options.optimize_for, ofSPEED       );
      oco_radios[ 5] = radio( "Si|~ze",           compiler_options.optimize_for, ofSIZE        );
      oco_radios[ 6] = radio( "|~Effectivity   ", compiler_options.optimize_for, ofEFFECTIVITY );
    endfr();
    nl();
    push();
    frame( "Floating-point" );
      oco_checks[ 7] = check( "Inline |~80x87 code for math functions ", compiler_options.optimizations, opINLINE     );
      oco_checks[ 8] = check( "|~Consistent floating-point results",     compiler_options.optimizations, opCONSISTENT );
      oco_checks[ 9] = check( "Opti|~mize for Pentium",                  compiler_options.optimizations, opPENTIUM    );
    endfr();
    _focused();
    oco_control = check( "Enable |~optimizations", compiler_options.options, opOPTIMIZATIONS );
    nc();
    frame( "Expand inline" );
      oco_checks[10] = check( "|~Intrinsic functions  ", compiler_options.optimizations, opINTRINSIC );
      oco_checks[11] = check( "|~User functions",        compiler_options.optimizations, opUSER      );
      vspace();
      oco_input1     = iinput( "User |~threshold", compiler_options.inline_threshold, 0, 32767 );
    endfr();
    pop();
    hor();
    vspace();
    _acenter(); button( "|~Fastest code",  cmFASTEST_CODE  );
                button( "|~Smallest code", cmSMALLEST_CODE );
                kbutton( "  OK  " );
                cbutton( "Cancel" );
                hbutton( " Help " );
    oco_handler( oco_control );
    if( run() == cmOK ) options_changed = 1;
  }
#undef cmFASTEST_CODE
#undef cmSMALLEST_CODE

    static Titem *ocd_items[11];
    static Tcheck *ocd_control;
    static void ocd_handler( Titem *p )
    {
      if( p==ocd_control )
      {
        boolean fl = !ocd_control->pressed();
        for( int i=0; i<11; i++ )
          ocd_items[i]->set_state( isDISABLED, fl );
      }
    }

  void options_compiler_debugging( void )
  {
    _help( htD_DEBUGGING );
    dialog( "Debugging Information" ); handler( ocd_handler );
    hspacing( 1 );
    frame( "Debug level" );
      ocd_items[0] = radio( "|~Line numbers debug info",        compiler_options.debug_level, dlLINENUMS     );
      ocd_items[1] = radio( "|~Full symbolic debug info",       compiler_options.debug_level, dlFULL         );
      ocd_items[2] = radio( "Including |~unreferenced names  ", compiler_options.debug_level, dlUNREFERENCED );
    endfr();
    nc();
    frame( "Debug format" );
      ver();
      ocd_items[3] = radio( "|~Watcom",     compiler_options.debug_format, dfWATCOM   );
      ocd_items[4] = radio( "|~Dwarf",      compiler_options.debug_format, dfDWARF    );
      ocd_items[5] = radio( "|~Codeview  ", compiler_options.debug_format, dfCODEVIEW );
    endfr();
    nl();
    push();
    frame( "Stack frames" );
      ver();
      ocd_items[6] = radio( "|~Generate as needed", compiler_options.stack_frames, sfNEED   );
      ocd_items[7] = radio( "Generate |~always",    compiler_options.stack_frames, sfALWAYS );
    endfr();
    _focused();
    ocd_control = check( "|~Enable debug info", compiler_options.options, opDEBUG_INFO );
    nc();
    frame( "Options" );
      ver();
      ocd_items[8]  = check( "|~Stack overflow checks",  compiler_options.debug_options, doSTACK         );
      ocd_items[9]  = check( "Disable |~optimizations",  compiler_options.debug_options, doOPTIMIZATIONS );
      ocd_items[10] = check( "Generate |~browsing info", compiler_options.debug_options, doBROWSING      );
    endfr();
    ocd_handler( ocd_control );
    if( bkch() ) options_changed = 1;
  }

  void options_compiler_floating_point( void )
  {
    _help( htD_FLOATING );
    dialog( "Floating-point" );
    frame( "Floating-point instructions" );
      radio( "|~Calls to floating-point library", compiler_options.fp_instructions, fpCALLS     );
      radio( "Inline |~with emulation",           compiler_options.fp_instructions, fpEMULATION );
      radio( "Inline with|~out emulation",        compiler_options.fp_instructions, fpINLINE    );
    endfr();
    frame( "Portability" );
      radio( "|~Backward compatible 80x87 code ", compiler_options.fp_portability,  fp8087  );
      radio( "|~287 floating-point code",         compiler_options.fp_portability,  fp80287 );
      radio( "|~387 floating-point code",         compiler_options.fp_portability,  fp80387 );
    endfr();
    if( bkch() ) options_changed = 1;
  }

    static Titem *oceh_items[2];
    static Tcheck *oceh_control;
    static void oceh_handler( Titem *p )
    {
      if( p==oceh_control )
      {
        boolean fl = !oceh_control->pressed();
        for( int i=0; i<2; i++ )
          oceh_items[i]->set_state( isDISABLED, fl );
      }
    }

  void options_compiler_exceptions_handling( void )
  {
    _help( htD_EXCEPTIONS );
    dialog( "Exception handling" ); handler( oceh_handler );
    _acenter(); oceh_control = check( "|~Enable exception handling", compiler_options.exception_handling );
    vspace();
    frame( "Options" );
      oceh_items[0] = radio( "|~Direct calls for destruction", compiler_options.destructions, xhDIRECTCALL  );
      oceh_items[1] = radio( "|~Table-driven destructors",     compiler_options.destructions, xhTABLEDRIVEN );
    endfr();
    oceh_handler( oceh_control );
    if( bkch() ) options_changed = 1;
  }

  void options_compiler_segment_registers( void )
  {
    _help( htD_SEGMENTS );
    dialog( "Segment registers" );
    frame( "DS" );
      radio( "Floats (|~not fixed to DGROUP)", compiler_options.ds_segment, dsFLOATS );
      radio( "|~Pegged to DGROUP",             compiler_options.ds_segment, dsPEGGED );
      radio( "|~Load directly from DGROUP",    compiler_options.ds_segment, dsLOAD   );
    endfr();
    frame( "Other" );
      check( "|~FS pegged to a segment      ", compiler_options.fsgsss_segments, fsPEGGED    );
      check( "|~GS pegged to a segment",       compiler_options.fsgsss_segments, gsPEGGED    );
      check( "|~SS != DGROUP",                 compiler_options.fsgsss_segments, ssNEQDGROUP );
    endfr();
    if( bkch() ) options_changed = 1;
  }

    static Titem *ocpf_items[5];
    static Tcheck *ocpf_control;
    static void ocpf_handler( Titem *p )
    {
      if( p==ocpf_control )
      {
        boolean fl = !ocpf_control->pressed();
        for( int i=0; i<5; i++ )
          ocpf_items[i]->set_state( isDISABLED, fl );
      }
    }

  void options_compiler_preprocess_files( void )
  {
    _help( htD_PREPROCESS );
    dialog( "Preprocess files" ); handler( ocpf_handler );
      _acenter(); ocpf_control = check( "Preprocessor |~only", compiler_options.exception_handling );
      nl();
      vspace(); hspaces( 3 );
      frame( "Options" );
        ocpf_items[0] = check( "|~Encrypt identifiers",     compiler_options.preprocess_options, pfENCRYPT  );
        ocpf_items[1] = check( "|~Insert #line directives", compiler_options.preprocess_options, pfLINE     );
        ocpf_items[2] = check( "|~Preserve comments",       compiler_options.preprocess_options, pfPRESERVE );
      endfr();
      nl();
      vspace();
      hor();
      ocpf_items[3] = check( "|~Wrap output", compiler_options.preprocess_options, pfWRAP );
      ocpf_items[4] = iinput( "|~at",  compiler_options.preprocess_wrap, 0, 300 );
      stext( "columns", 9 );
    ocpf_handler( ocpf_control );
    if( bkch() ) options_changed = 1;
  }

  void options_compiler_names( void )
  {
    _help( htD_NAMES );
    dialog( "Names" );
      input( "Code |~group name     ", compiler_options.code_group_name,   25, 25 );
      input( "Code |~class name     ", compiler_options.code_class_name,   25, 25 );
      input( "|~Data segment name   ", compiler_options.data_segment_name, 25, 25 );
      input( "|~Module name         ", compiler_options.module_name,       25, 25 );
      input( "Name of |~text segment", compiler_options.text_segment_name, 25, 25 );
    if( bkch() ) options_changed = 1;
  }

  void options_compiler_messages( void )
  {
    _help( htD_MESSAGES );
    dialog( "Compiler messages" );
    cinput( "|~Warnings: level number  ", compiler_options.warn_level, 0,   4 );
    cinput( "|~Errors:   stop after  ",   compiler_options.max_errors, 1, 255 );
    check( "|~Treat warnings as errors",  compiler_options.debug_options, doWARN_IS_ERR );
    vspace();
    frame( "Portability" );
      radio( "Accept only ISO/|~ANSI C++", compiler_options.portability, poANSI   );
      radio( "Enable e|~xtensions",        compiler_options.portability, poWATCOM );
    endfr();
    if( bkch() ) options_changed = 1;
  }


void options_linker( void )
{
  _help( htD_LINKER );
  dialog( "Linker options" );
  hor();
  linput( "|~Stack size", linker_options.stack_size, 1024, 0x10000000 );
  hspaces( 3 );
  cinput( "|~Errors limit", linker_options.max_errors, 1, 255 );
  nl();
  ver();
  Tcombo_box *os = combo_box( "|~Target", linker_options.target_os, 35 );
  for( uint i=0; i<TO_COUNT; i++ )
    os->add( target_os[i].title );
  memo( "|~Other options", linker_options.other_options, sizeof( linker_options.other_options ), 43, 7 );
  if( bkch() ) options_changed = 1;
}


#define cmCPP_SYNTAX cmUSER00
#define cmASM_SYNTAX cmUSER01
  static void update_editor_options( void )
  {
    strupr( editor_options.extension      );
    strupr( editor_options.cpp_extensions );
    strupr( editor_options.asm_extensions );
    application->redraw();
    editor_flags = editor_options.flags & ~(efSAVE_STATUS|efOPEN_INCLUDE);
    tab_size = editor_options.tab_size;
    for( Tfile_editor *p=open_editors; p!=NULL; p=p->next_editor )
      p->text_editor->set_name( p->text_editor->file_name );
  }

  static boolean oe_validator( uint command )
  {
    if( command==cmCPP_SYNTAX )
    {
      _help( htD_CPP_SYNTAX );
      dialog( "C++ syntax hilighting options" );
      input( "E|~xtensions    ", editor_options.cpp_extensions, sizeof(editor_options.cpp_extensions)-1, 26 );
      nl();
      push();
      cinput( "|~Reserved words", cpp_syntax_colors[cppRESERVED_WORDS], 0, 15 )->set_state(isDISABLED,scr_bw);
      cinput( "|~Identifiers   ", cpp_syntax_colors[cppIDENTIFIERS   ], 0, 15 )->set_state(isDISABLED,scr_bw);
      cinput( "|~Numbers       ", cpp_syntax_colors[cppNUMBERS       ], 0, 15 )->set_state(isDISABLED,scr_bw);
      cinput( "|~Strings       ", cpp_syntax_colors[cppSTRINGS       ], 0, 15 )->set_state(isDISABLED,scr_bw);
      nc(); hspaces( 3 );
      cinput( "S|~ymbols       ", cpp_syntax_colors[cppSYMBOLS       ], 0, 15 )->set_state(isDISABLED,scr_bw);
      cinput( "|~Preprocessor  ", cpp_syntax_colors[cppPREPROCESSOR  ], 0, 15 )->set_state(isDISABLED,scr_bw);
      cinput( "|~Comments      ", cpp_syntax_colors[cppCOMMENTS      ], 0, 15 )->set_state(isDISABLED,scr_bw);
      cinput( "|~White space   ", cpp_syntax_colors[cppWHITE         ], 0, 15 )->set_state(isDISABLED,scr_bw);
      if( bkch() )
      {
        options_changed = 1;
        update_editor_options();
      }
      return 0;
    }
    if( command==cmASM_SYNTAX )
    {
      _help( htD_ASM_SYNTAX );
      dialog( "Assembler syntax hilighting options" );
      input( "E|~xtensions    ", editor_options.asm_extensions, sizeof(editor_options.asm_extensions)-1, 26 );
      nl();
      push();
      cinput( "|~Reserved words", asm_syntax_colors[asmRESERVED_WORDS], 0, 15 )->set_state(isDISABLED,scr_bw);
      cinput( "|~Identifiers   ", asm_syntax_colors[asmIDENTIFIERS   ], 0, 15 )->set_state(isDISABLED,scr_bw);
      cinput( "|~Decimals      ", asm_syntax_colors[asmDECIMALS      ], 0, 15 )->set_state(isDISABLED,scr_bw);
      cinput( "|~Hexadecimals  ", asm_syntax_colors[asmHEXADECIMALS  ], 0, 15 )->set_state(isDISABLED,scr_bw);
      cinput( "|~Binaries      ", asm_syntax_colors[asmBINARIES      ], 0, 15 )->set_state(isDISABLED,scr_bw);
      nc(); hspaces( 3 );
      cinput( "|~Strings       ", asm_syntax_colors[asmSTRINGS       ], 0, 15 )->set_state(isDISABLED,scr_bw);
      cinput( "S|~ymbols       ", asm_syntax_colors[asmSYMBOLS       ], 0, 15 )->set_state(isDISABLED,scr_bw);
      cinput( "|~Comments      ", asm_syntax_colors[asmCOMMENTS      ], 0, 15 )->set_state(isDISABLED,scr_bw);
      cinput( "|~White space   ", asm_syntax_colors[asmWHITE         ], 0, 15 )->set_state(isDISABLED,scr_bw);
      if( bkch() )
      {
        options_changed = 1;
        update_editor_options();
      }
      return 0;
    }
    return 1;
  }

void options_editor( void )
{
  _help( htD_EDITOR );
  dialog( "Editor options" ); validator( oe_validator );
  frame( "Options" );
    check( "|~Backup files",            editor_options.flags, efBACKUP_FILES );
    check( "|~Save/restore status",     editor_options.flags, efSAVE_STATUS  );
    check( "Auto |~indent mode",        editor_options.flags, efAUTO_INDENT  );
    check( "|~Hard tabs",               editor_options.flags, efHARD_TABS    );
    check( "|~Open from include dirs ", editor_options.flags, efOPEN_INCLUDE );
  endfr();
  nc();
  hspace();
  frame( "Search/Replace" );
    check( "Case se|~nsitive",     editor_options.flags, efCASE_SENSITIVE    );
    check( "|~Whole words only",   editor_options.flags, efWHOLE_WORDS_ONLY  );
    check( "|~Prompt on replace ", editor_options.flags, efPROMPT_ON_REPLACE );
    check( "|~Replace all",        editor_options.flags, efREPLACE_ALL       );
  endfr();
  nl();
  hor();
  iinput( "|~Tab size", editor_options.tab_size, 2, 32 );
  hspaces( 3 );
  input( "|~Default file name extension", editor_options.extension, _MAX_EXT - 1, _MAX_EXT - 1 );
  nl();
  vspace();
  frame( "Condensed display" );
    iinput( " |~Margin", editor_options.condense_column, 0, 255 );
    iinput( "  Minimum |~length", editor_options.condense_length, 0, 255 );
    stext( "characters", 12 );
  endfr();
  nl(); _acenter(); hspacing( 1 );
#ifndef HGR
  vspaces( !graph_flag );
#endif
  kbutton( "  OK  " );
  button( " |~C++ ", cmCPP_SYNTAX );
  button( " |~Assembler ", cmASM_SYNTAX );
  cbutton( "Cancel" );
  hbutton( " Help " );
  if( run()==cmOK )
  {
    options_changed = 1;
    update_editor_options();
  }
}
#undef cmCPP_SYNTAX
#undef cmASM_SYNTAX


void options_directories( void )
{
  char *s;

  _help( htD_DIRS );
  dialog( "Directories" );
  input( "|~Include directories", default_directories.include,   _MAX_PATH-1, 25 );
  input( "|~Library directories", default_directories.library,   _MAX_PATH-1, 25 );
  input( "|~Target directory   ", default_directories.objects,   _MAX_PATH-1, 25 );
  input( "|~Swap directory     ", default_directories.tmp_files, _MAX_PATH-1, 25 );
  if( bkch() )
  {
    options_changed = 1;
    s = strchr( default_directories.include, 0 );
    if( ( s > default_directories.include ) && ( *(s-1) != '\\' ) )
      strcat( fexpand( default_directories.include ), "\\" );
    s = strchr( default_directories.library, 0 );
    if( ( s > default_directories.library ) && ( *(s-1) != '\\' ) )
      strcat( fexpand( default_directories.library ), "\\" );
    s = strchr( default_directories.objects, 0 );
    if( ( s > default_directories.objects ) && ( *(s-1) != '\\' ) )
      strcat( fexpand( default_directories.objects ), "\\" );
    s = strchr( default_directories.tmp_files, 0 );
    if( ( s > default_directories.tmp_files ) && ( *(s-1) != '\\' ) )
      strcat( fexpand( default_directories.tmp_files ), "\\" );
  }
}


/*
TOOLS
*/
  #define cmOK_CLOSE  cmUSER00
  #define cmADD_TOOL  cmUSER01
  #define cmINS_TOOL  cmUSER02
  #define cmEDIT_TOOL cmOK
  #define cmDEL_TOOL  cmUSER03

      static Tlist_box *tools_list_box;
      static Tinput *oti_title;
      static Tinput *oti_path;
      static Ttools_entry *oti_tool;
      static boolean oti_validator( uint command )
      {
        char buffer[256];
        int trap;

        if( command == cmUSER01 )
        {
          _help( htD_TOOL_OPTIONS );
          dialog( "Tool options" );
          frame( "Options" );
            check( "|~Translator (can be used for make)",  oti_tool->options, teCOMPILER  );
            check( "|~Don't swap screen",                  oti_tool->options, teDONT_SWAP );
            check( "|~Prompt with command line",           oti_tool->options, tePROMPT    );
            check( "Enable |~long command line (@file)",   oti_tool->options, teLONG_CMD  );
            check( "|~Make project before execution",      oti_tool->options, teMAKE      );
            check( "Save |~current file before execution", oti_tool->options, teSAVE_CUR  );
            check( "Save |~all files before execution",    oti_tool->options, teSAVE_ALL  );
          endfr();
          trap = 1;
          if( oti_tool->options & teTRAP_ERRORS ) trap = 2;
          if( oti_tool->options & teTRAP_OUTPUT ) trap = 3;
          frame( "Trap output" );
            radio( "Don't trap |~output", trap, 1 );
            radio( "Temp file > |~specified filter", trap, 2 );
            radio( "Specified |~file", trap, 3 );
            vspace();
            input( "Trap/filter file |~name", oti_tool->trap_file, 12, 12 );
          endfr();
          hor(); hspacing( 1 ); nl(); _acenter();
          kbutton( "  OK  " );
          cbutton( "Cancel" );
          hbutton( " Help " );
          if( run() == cmOK )
          {
            options_changed = 1;
            oti_tool->options &= ~( teTRAP_OUTPUT + teTRAP_ERRORS );
            if( trap == 2 ) oti_tool->options |= teTRAP_ERRORS;
            if( trap == 3 ) oti_tool->options |= teTRAP_OUTPUT;
            strupr( oti_tool->trap_file );
          }
          return 0;
        }
        if( command != cmOK ) return 1;
        oti_title->get_txt( buffer );
        if( *buffer == 0 )
        {
          focus( oti_title );
          return 0;
        }
        oti_path->get_txt( buffer );
        if( *buffer == 0 )
        {
          focus( oti_path );
          return 0;
        }
        return 1;
      }

    static boolean options_tools_input( Ttools_entry &te )
    {
      uint shortcut;
      uint shortcuts[] = { 0, kSHIFT_F1, kSHIFT_F2, kSHIFT_F3, kSHIFT_F4, kSHIFT_F5,
                              kSHIFT_F6, kSHIFT_F7, kSHIFT_F8, kSHIFT_F9, kSHIFT_F10 };
      char buf[20];
      char drive[_MAX_DRIVE];
      char dir[_MAX_DIR];
      boolean result;
      Tcombo_box *cb;
      _help( htD_NEW_TOOL );
      dialog( "Modify/New tool" ); validator( oti_validator );
      oti_tool = &te;
      oti_title = input( "|~Menu title  ", te.title, 20, 20 );
      oti_path  = input( "|~Program path", te.path, _MAX_PATH-1, 20 );
      input( "|~Command line", te.command_line, 127, 20 );
      shortcut = 0;
      for( uint i = 0; i <= 10; i++ )
        if( te.shortcut == shortcuts[i] )
        {
          shortcut = i;
          break;
        }
      cb = combo_box( "|~Shortcut    ", shortcut, 11 );
        cb->add( "No shortcut" );
        for( i = 1; i <= 10; i++ )
        {
          sprintf( buf, "Shift+F%d", i );
          cb->add( buf );
        }
      hor(); hspacing( 1 ); nl(); vspace(); _acenter();
      kbutton( "  OK  " );
       button( "|~Options", cmUSER01 );
      cbutton( "Cancel" );
      hbutton( " Help " );
      result = ( run() == cmOK );
      if( result )
      {
        options_changed = 1;
        te.shortcut = shortcuts[shortcut];
        strupr( te.path );
        _splitpath( te.path, drive, dir, NULL, NULL );
        if( *dir || *drive ) fexpand( te.path );
      }
      return result;
    }

  static void options_tools_edit( uint i )
  {
    Ttools_entry te;
    tools_list_box->get( i, &te );
    if( options_tools_input( te ) ) tools_list_box->put( i, &te );
  }

  static void options_tools_new( uint i )
  {
    Ttools_entry te;
    *te.path = 0;
    *te.command_line = 0;
    te.shortcut = 0;
    te.options = 0;
    *te.title = 0;
    strcpy( te.trap_file, "TEXT2LOG" );
    if( options_tools_input( te ) ) tools_list_box->ins( i, &te );
  }

    static boolean options_tools_validator( uint command )
    {
      Ttools_entry *te;
      boolean result;

      result = 0;
      switch( command )
      {
        case cmEDIT_TOOL:
          options_tools_edit( tools_list_box->vcurrent );
          break;
        case cmADD_TOOL:
          options_tools_new( tools_list_box->vcount );
          break;
        case cmINS_TOOL:
          options_tools_new( tools_list_box->vcurrent );
          break;
        case cmDEL_TOOL:
          te = (Ttools_entry *) tools_list_box->getptr( tools_list_box->vcurrent );
          tools_list_box->del( tools_list_box->vcurrent );
          break;
        default:
          result = 1;
      }
      tools_list_box->cstate( cmADD_TOOL, tools_list_box->vcount < MAX_TOOLS );
      tools_list_box->cstate( cmINS_TOOL, tools_list_box->vcount < MAX_TOOLS );
      tools_list_box->cstate( cmDEL_TOOL, tools_list_box->vcount > 0 );
      tools_list_box->cstate( cmEDIT_TOOL, tools_list_box->vcount > 0 );
      return result;
    }

  void options_tools( void )
  {
    uint i;
    Ttools_entry te;

    _help( htD_TOOLS );
    dialog( "Tools" ); validator( options_tools_validator );
    _lsize( TTOOLS_ENTRY_SIZE );
    i = 0;
    tools_list_box = list_box( "Program titles", i, 20, 12 );
    tools_list_box->set_flags( ifSTAY, 1 );
    nc();
     button( "  O|~K  ", cmOK_CLOSE );
     button( " |~Add  ", cmADD_TOOL );
     button( "|~Insert", cmINS_TOOL )->shortcut = kINS;
     button( "|~Delete", cmDEL_TOOL )->shortcut = kDEL;
    dbutton( " |~Edit ", cmEDIT_TOOL );
    cbutton( "Cancel" );
    hbutton( " Help " );
    for( i = 0; i < ot_tools->vcount; i++ )
    {
      ot_tools->get( i, &te );
      tools_list_box->add( &te );
    }
    tools_list_box->top();
    options_tools_validator( 0 );
    if( run() == cmOK_CLOSE )
    {
      options_changed = 1;
      ot_tools->clear();
      for( i = 0; i < tools_list_box->vcount; i++ )
      {
        tools_list_box->get( i, &te );
        ot_tools->add( &te );
      }
      init_main_menu();
      update_context();
    }
    DELETE( tools_list_box );
  }
  #undef cmOK_CLOSE
  #undef cmADD_TOOL
  #undef cmINS_TOOL
  #undef cmEDIT_TOOL
  #undef cmDEL_TOOL

  void expand_command_line( char *command_line, char *file, char *result )
  {
    char c;
    char *s, *d, *pfile;
    char drive[_MAX_DRIVE], pdrive[_MAX_DRIVE];
    char dir[_MAX_DIR],     pdir[_MAX_DIR];
    char name[_MAX_FNAME],  pname[_MAX_FNAME];
    char ext[_MAX_EXT],     pext[_MAX_EXT];

    *result = *drive  = *dir  = *name  = *ext  =
              *pdrive = *pdir = *pname = *pext = 0;
    pfile = file;
    _splitpath( file, drive,  dir,  name,  ext  );
    _splitpath( file, pdrive, pdir, pname, pext );
    if( project != NULL )
    {
      pfile = project->filename;
      _splitpath( pfile, pdrive, pdir, pname, pext );
    }
    s = command_line - 1;
    d = result - 1;
    do
    {
      *++d = *++s;
      if( *s == '$' )
      {
        switch( c = *++s )
        {
          case 'P':
            strcpy( d, pfile );
            break;
          case 'F':
            strcpy( d, pname );
            strcat( d, pext );
            break;
          case 'N':
            strcpy( d, pname );
            break;
          case 'X':
            strcpy( d, pext );
            break;
          case 'D':
            strcpy( d, pdrive );
            strcat( d, pdir );
            break;
          case 'p':
            strcpy( d, file );
            break;
          case 'f':
            strcpy( d, name );
            strcat( d, ext );
            break;
          case 'n':
            strcpy( d, name );
            break;
          case 'x':
            strcpy( d, ext );
            break;
          case 'd':
            strcpy( d, drive );
            strcat( d, dir );
            break;
          case 'i':
          case 'I':
            strcpy( d, default_directories.include );
            break;
          case 't':
          case 'T':
            strcpy( d, default_directories.objects );
            break;
          case 'w':
          case 'W':
            *d = 0;
            if( current_editor == NULL ) break;
            current_editor->get_word_str( d, 50 );
            if( c == 'W' ) strupr( d );
            break;
          case 'c':
          case 'C':
            strcpy( d, program_params );
            break;
          default:
            continue;
        }
        d = strchr( d, 0 ) - 1;
      }
    }
    while( *s );
    get_local_options( result, file );
  }

  int exec_tool( uint tool, char *file )
  {
    Ttools_entry *te;
    char fn[_MAX_PATH];
    char buffer[256];
    int result;

    te = (Ttools_entry *) ot_tools->getptr( tool );
    strcpy( fn, file );
    if( *fn == 0 )
      if( current_editor!=NULL )
        strcpy( fn, ((Tfile_editor *) current_editor->editor)->text_editor->file_name );
      else
        if( project!=NULL && project->state( isFOCUSED ) )
        {
          Tproject_entry *pe = (Tproject_entry *) project->getptr( project->vcurrent );
          strcpy( fn, pe->filename );
        }
    expand_command_line( te->command_line, fn, buffer );
    if( te->options & teTRAP_ERRORS ) log->clear();
    if( ( te->options & teMAKE ) && !project_make() ) return -1;
    if( te->options & teDONT_SWAP )
      action( "\nExecuting %s", te->path );
    else
      hide_cursor();
    result = exec( te->options, te->path, buffer, te->trap_file, te );
    if( te->options & teDONT_SWAP )
      done_action();
    else
      show_cursor();
    if( te->options & teTRAP_ERRORS ) log->show_first_error();
    application->redraw();
    idle( 0 );
    return result;
  }


/*
OPTIONS I/O
*/
  void options_file_changed( char *filename )
  {
    char buffer[_MAX_PATH];

    strcpy( options_filename, filename );
    strcpy( buffer, filename );
    min_path( buffer );
    short_path( buffer, 20 );
    strcpy( short_options_filename, buffer );
    init_main_menu();
    update_context();
    options_changed = 0;
  }

  boolean load_options( char *filename, boolean show_error )
  {
    FILE *f;
    Tcompiler_options    tmp_compiler_options;
    Tlinker_options      tmp_linker_options;
    Teditor_options      tmp_editor_options;
    char                 tmp_cpp_colors[sizeof(cpp_syntax_colors)];
    char                 tmp_asm_colors[sizeof(asm_syntax_colors)];
    Tdefault_directories tmp_default_directories;
    Tlb_list *           tmp_tools;
    char tmp_signature[ sizeof( pvo_signature ) ];
    Ttools_entry te;
    boolean success;
    uint count, i;

    if( *filename == 0 ) return 0;
    f = fopen( filename, "rb" );
    if( f == NULL )
    {
      if( show_error )
      {
        _terror();
        ok( "Unable to open options file \"%s\".", filename );
      }
      return 0;
    }
    _lsize( TTOOLS_ENTRY_SIZE ); tmp_tools = NEW( Tlb_list );
    memset( tmp_signature, 0, sizeof( tmp_signature ) );
    fread( tmp_signature, sizeof( tmp_signature ), 1, f );
    success = !memcmp( tmp_signature, pvo_signature, sizeof( tmp_signature ) );
    if( !success )
    {
      _terror();
      ok( "\"%s\" is not a Power View IDE options file.", filename );
      goto xit;
    }
    success = (
      ( fread( &tmp_compiler_options,    sizeof( Tcompiler_options    ), 1, f ) == 1 ) &&
      ( fread( &tmp_linker_options,      sizeof( Tlinker_options      ), 1, f ) == 1 ) &&
      ( fread( &tmp_editor_options,      sizeof( Teditor_options      ), 1, f ) == 1 ) &&
      ( fread( tmp_cpp_colors,           sizeof( tmp_cpp_colors       ), 1, f ) == 1 ) &&
      ( fread( tmp_asm_colors,           sizeof( tmp_asm_colors       ), 1, f ) == 1 ) &&
      ( fread( &tmp_default_directories, sizeof( Tdefault_directories ), 1, f ) == 1 ) &&
      ( fread( &count,                   sizeof( count                ), 1, f ) == 1 )
    );
    if( success )
    {
      ++count;
      while( success && --count )
      {
        success = success && ( fread( &te, sizeof( Ttools_entry ), 1, f ) == 1 );
        tmp_tools->add( &te );
      }
    }
    fclose( f );
    if( ferror( f ) || !success )
    {
      _terror();
      ok( "Error reading options file \"%s\".", filename );
    }
    else
    {
      compiler_options = tmp_compiler_options;
      linker_options = tmp_linker_options;
      editor_options = tmp_editor_options;
      if( !scr_bw )
      {
        memcpy( cpp_syntax_colors, tmp_cpp_colors, sizeof(cpp_syntax_colors) );
        memcpy( asm_syntax_colors, tmp_asm_colors, sizeof(asm_syntax_colors) );
      }
      update_editor_options();
      default_directories = tmp_default_directories;
      ot_tools->clear();
      for( i = 0; i < tmp_tools->vcount; i++ )
      {
        tmp_tools->get( i, &te );
        ot_tools->add( &te );
      }
      options_file_changed( filename );
    }
    xit: DELETE( tmp_tools );
    return success;
  }

  void options_save( void )
  {
    FILE *f;
    Ttools_entry te;
    uint i;
    boolean success;

    if( *options_filename==0 )
    {
      strcpy( options_filename, startup_path );
      strcat( options_filename, "SAVED.PVO" );
    }
    f = fopen( options_filename, "wb" );
    if( f == NULL )
    {
      _terror();
      ok( "Unable to create options file \"%s\".", options_filename );
      return;
    }
    success = (
      ( fwrite( pvo_signature,        sizeof( pvo_signature        ), 1, f ) == 1 ) &&
      ( fwrite( &compiler_options,    sizeof( Tcompiler_options    ), 1, f ) == 1 ) &&
      ( fwrite( &linker_options,      sizeof( Tlinker_options      ), 1, f ) == 1 ) &&
      ( fwrite( &editor_options,      sizeof( Teditor_options      ), 1, f ) == 1 ) &&
      ( fwrite( cpp_syntax_colors,    sizeof( cpp_syntax_colors    ), 1, f ) == 1 ) &&
      ( fwrite( asm_syntax_colors,    sizeof( asm_syntax_colors    ), 1, f ) == 1 ) &&
      ( fwrite( &default_directories, sizeof( Tdefault_directories ), 1, f ) == 1 ) &&
      ( fwrite( &ot_tools->vcount,    sizeof( ot_tools->vcount     ), 1, f ) == 1 )
    );
    if( success )
    {
      for( i = 0; success && ( i < ot_tools->vcount ); i++ )
      {
        ot_tools->get( i, &te );
        success = success && ( fwrite( &te, sizeof( Ttools_entry ), 1, f ) == 1 );
      }
    }
    fclose( f );
    if( ferror( f ) || !success )
    {
      remove( options_filename );
      _terror();
      ok( "Error writting options file \"%s\".", options_filename );
    }
    else
      options_file_changed( options_filename );
  }


/*
MENU COMMANDS SERVICE
*/
  void options_open( void )
  {
    char f[_MAX_PATH];

    _filters( "Option files (*.pvo)" );
    if( get_file( "Open options", f ) == cmOK )
      load_options( f, 1 );
  }

  void options_save_as( void )
  {
    _new_file();
    _filters( "Option files (*.pvo)" );
    if( get_file( "Save options as", options_filename ) == cmOK )
      options_save();
  }
