//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVHC.CPP                             |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Power View Help Compiler             |
// |                                                    |
// |  Author:      Georgi Chalakov                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_malloc
#define uses_stdio
#define uses_stdlib
#define uses_string
#define uses_comlin
#define uses_system

#include "PVuses.h"

#define TITLE      "\r\nPower View help file.\r\n\032"
#define HELPIDX    "HELP_INDEX"
#define BUFSIZE    16384
#define MAXTOPICS   2000
#define MAXREF       100

FILE *fi, *fo, *fh;
unsigned char *bufin, *bufout;
int    bufinp = 1;
int    bufinl = 1;
int    bufoutp = 0;
long   putlen;


struct token
{
  char *ident;
  char *title;
  int num;
} tokens[MAXTOPICS];

struct item
{
  long offset;
  int  size;
} index[MAXTOPICS];

int tokenslen = 0;

void error( int flag, char *s, char *m )
{
  if( flag )
  {
    if( bufin!=NULL )
      free( bufin );
    if( bufout!=NULL )
      free( bufout );
    printf( "Error: %s %s\n", s, m );
    exit( -1 );
  }
}

void flushout( void )
{
  fwrite( bufout, 1, bufoutp, fo );
}

void _pch( int ch )
{
  putlen++;
  if( bufoutp == BUFSIZE )
  {
    fwrite( bufout, 1, BUFSIZE, fo );
    bufoutp = 0;
  }
  bufout[ bufoutp++ ] = ch;
}

void pch( int ch )
{
  _pch( ch );
  if( ch == '\r' ) _pch( ch );
}

static int new_line;

int gch( void )
{
  static int ch = '\r';

  new_line = ( ch == '\r' ) || ( ch == '\n' );
  if( !bufinl )
  {
    ch = '\r';
    return -1;
  }
  if( bufinp == bufinl )
  {
    bufinp = 0;
    bufinl = fread( bufin, 1, BUFSIZE, fi );
  }
  else
  {
    ch = bufin[bufinp++];
    if( ch != '\n' ) return ch;
  }
  return gch();
}

int tokencmp( const void *a, const void *b )
{
  return strcmp( ( ( struct token* )a )->title, ( ( struct token* )b )->title );
}

void transfer( void )
{
  char stmp[256], *s;
  int i, j, e;
  int ch, tp, hif;
  boolean dont_wrap = 0;

  memset( tokens, 0, sizeof( tokens ) );
  printf( "Reading help topics...\n" );
  fseek( fi, 0, 0 );
  while( ( ch=gch() ) != -1 )
  {
    if( ch == '@' && new_line )
    {
      s = stmp;
      while( ( ch = gch() ) != '\r' ) *s++ = ch;
      *s = 0;
      tokens[tokenslen].ident = strdup( stmp );
      s = stmp;
      while( ( ch = gch() ) != '\r' ) *s++ = ch;
      *s = 0;
      tokens[tokenslen].title = strdup( stmp );
      for( i=0; ( i < tokenslen ) && strcmp( tokens[i].ident, stmp ); i++ );
      error( i!=tokenslen, "Topic defined twice", tokens[i].ident );
      tokens[tokenslen].num = tokenslen;
      error( ++tokenslen==MAXTOPICS, "Too many topics found", "" );
    }
  }
  printf( "Building help index...\n" );
  fseek( fi, 0, 0 );
  bufinp = bufinl = 1;
  hif = tp = 0;
  e = 2;
  putlen = tokenslen*6 + sizeof( TITLE ) - 1;
  fwrite( TITLE, 1, sizeof( TITLE ) - 1, fo );
  fwrite( index, sizeof( struct item ), tokenslen, fo );
  do
  {
    ch = gch();
  proceed_char:
    if( ch == -1 ) break;
    switch( ch )
    {
      case '@':
        if( new_line )
        {
          index[tp].offset = putlen;
          while( gch()!='\r' );
          while( gch()!='\r' );
          e = 2;
          if( !strcmp( tokens[tp].ident, HELPIDX ) ) hif++;
        }
        break;
      case '`':
        pch( '`' );
        pch( '`' );
        e = 2;
        dont_wrap = 1;
        break;
      case '\r':
        dont_wrap = 0;
        e++;
        if( e==2 )
        {
          pch( '\r' );
          pch( '\r' );
        }
        else
          if( e>2 )
            pch( '\r' );
          else
          {
            e = 1;
            ch = gch();
            if( ch != '\r' ) pch( ' ' );
            goto proceed_char;
          }
        break;
      case '~':
        pch( '|' ); pch( 'b' );
        for( i = 0; ( ( ch = gch() ) != '~' ) || ( i == MAXREF ); i++ )
        {
          if( ch == '\r' ) ch = ' ';
          pch( ch );
        }
        error( i==MAXREF, "Reference too long", "" );
        pch( '|' ); pch( 't' );
        i = 0;
        while( ( ( ch=gch() )!=' ' ) &&
               ( ch != '\r' )        &&
               ( ch != '.' )         &&
               ( ch != ',' ) )
          stmp[i++] = ch;
        stmp[i] = 0;
        for( i = 0; i < tokenslen; i++ )
          if( !strcmp( tokens[i].ident, stmp ) )
            break;
        error( i==tokenslen, "Reference to undefined topic ", stmp );
        i++;
        _pch( i & 0xff );
        _pch( i>>8 );
        if( !dont_wrap ) e = 0;
        goto proceed_char;
      case '^':
        if( new_line )
        {
          while( gch()!='\r' );
          if( hif == 1 )
          {
            char letter = 0;
            for( i = 0; i < tokenslen; i++ )
              fprintf( fh, "#define ht%s %u\n", tokens[i].ident ,i+1 );
            printf( "Sorting topics...\n" );
            qsort( tokens, tokenslen, sizeof( struct token ), tokencmp );
            hif++;
            for( i = 0; i < tokenslen; i++ )
            {
              if( strcmp( tokens[i].ident, HELPIDX ) == 0 ) continue;
              if( tokens[i].title[0] != letter )
              {
                letter = tokens[i].title[0];
                pch( '\r' );
                pch( letter );
                pch( '\r' );
              }
              pch( '|' );
              pch( 'b' );
              for( j = 0; j < strlen( tokens[i].title ); j++ )
                pch( tokens[i].title[j] );
              pch( '|' );
              pch( 't' );
              _pch( ( tokens[i].num+1 ) & 0xff );
              _pch( ( tokens[i].num+1 ) >> 8 );
              pch( '\r' );
            }
          }
          index[tp++].size = ( int ) ( putlen - index[tp].offset );
        }
        break;
      default:
        if( !dont_wrap ) e = 0;
        pch( ch );
    }
  }
  while( 1 );
  flushout();
  fseek( fo, sizeof( TITLE ) - 1, 0 );
  fwrite( index, sizeof( struct item ), tokenslen, fo );
}



int main( int argc, char* argv[] )
{
  char input_fn[_MAX_PATH], output_fn[_MAX_PATH], header_fn[_MAX_PATH];

  bufin = (unsigned char *) malloc( BUFSIZE );
  bufout = (unsigned char *) malloc( BUFSIZE );
  error( bufout == NULL, "Not enought memory","" );

  __init_comlin( argc, argv );

  printf( "\
Power View Help Compiler. Written by George Chalakov.\n\n"
  );
  if( param_opt( "/?" ) || ( argc == 1 ) )
  {
    printf( "\
Syntax:\n\
  PVHC <input_file[.TXT]> [<output_file>[.HLP]] [PVHT.H]\n\n\
Description:\n\
  This tool reads specified text file, produces a Power View Help file\n\
  and exports help defines in a C-header file. The structure of input file is:\n\
\n\
  <topic_id>\n\
  <index title>\n\
  <text>\n\
  <text>\n\
  ...\n\
  <end_of_topic>\n\
  ...\n\
\n\
  <topic_id> ::= @<CPP_id>\n\
  <index_title> - Cross-reference that appears in the Help Index\n\
  <text> - single CRs are ignored, a ` marks line not to be wrapped.\n\
           ~Cross reference~<CPP_id> means a hyper link.\n\
  <end_of_topic> ::= ^\n"
    );
    exit( 0 );
  }

  error( !param_filename( input_fn, ".TXT" ), "Missing input filename", "" );
  if( !param_filename( output_fn, ".HLP" ) )
  {
    char _drive[_MAX_DRIVE];
    char _dir[_MAX_DIR];
    char _file[_MAX_FNAME];
    char _ext[_MAX_EXT];

    _splitpath( input_fn, _drive, _dir, _file, _ext );
    strcpy( _ext, ".HLP" );
    _makepath( output_fn, _drive, _dir, _file, _ext );
  }

  if( !param_filename( header_fn, ".H" ) )
    strcpy( header_fn, "PVHT.H" );

  __tini_comlin();

  fi = fopen( input_fn, "rb" );
    error( fi == NULL, "Can't open input file", input_fn );
  fo = fopen( output_fn, "wb" );
    error( fo == NULL, "Can't open output file", output_fn );
  fh = fopen( header_fn, "wt" );
    error( fh == NULL, "Can't open header file", header_fn );

  transfer();
  fclose( fi );
  fclose( fo );
  fclose( fh );
  printf( "Done.\n\nOutput file: %s\nHeader file: %s\n", fexpand( output_fn ), fexpand( header_fn ) );
  return 0;
}
