//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVBASICS.CPP                         |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Basic and common-use stuff           |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_string
#define uses_basics

#include "PVuses.h"

//SET PROCESSING

void Tset::operator ~ ( void )
{
  for( int i = 0; i < 32; i++ )
    members[i] = 0;
}

void Tset::operator ! ( void )
{
  for( int i = 0; i < 32; i++ )
    members[i] = 0xFF;
}

int Tset::is_empty( void )
{
  for( int i = 0; i < 32; i++ )
    if( members[i] ) return 0;
  return 1;
}

Tset& operator << ( Tset &set, Tset &set1 )
{
  for( int i = 0; i < 32; i++ )
    set.members[i] |= set1.members[i];
  return set;
}

Tset& operator >> ( Tset &set, Tset &set1 )
{
  for( int i = 0; i < 32; i++ )
    set.members[i] &= ~set1.members[i];
  return set;
}

int operator == ( Tset &set1, Tset &set2 )
{
  for( int i = 0; i < 32; i++ )
    if( set1.members[i] != set2.members[i] ) return 0;
  return 1;
}

//TEXT PROCESSING

void cyr_strupr( char *str )
{
  for( char *c=str; *c; *c=cyr_toupper(*c),c++ );
}

void cyr_strlwr( char *str )
{
  for( char *c=str; *c; *c=cyr_tolower(*c),c++ );
}
