//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVCALEND.CPP                         |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Automatic calendar implementation    |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_calend
#define uses_dc
#define uses_desk
#define uses_dialog
#define uses_icons
#define uses_input
#define uses_stddlg
#define uses_system

#include "PVuses.h"

class Tcalendar: public Titem
{
  public:
    uint year;
    uint month;
    uint days;
    uint cur_year;
    uint cur_month;
    uint cur_day;
    Tcalendar( void );
    virtual void draw( void );
    virtual void event_handler( Tevent &ev );
};

class Tcalendar_window: public Twindow
{
  public:
    Tcalendar_window( void );
    virtual ~Tcalendar_window( void );
};

static Tcalendar_window *calendar_window = NULL;

//TCALENDAR

Tcalendar::Tcalendar( void ):
  Titem( 20, 7 )
{
  Ticon *i;
  dosdate_t date;

  _dos_getdate( &date );
  cur_year = date.year;
  cur_month = date.month;
  cur_day = date.day;
  year = cur_year;
  month = cur_month;
  i = NEW( Ticon( i_sb_up, cmUP_ARROW, kUP ) );
    i->set_flags( bfREPEAT, 1);
    put_in( i, 16, 0 );
  i = NEW( Ticon( i_sb_down, cmDOWN_ARROW, kDOWN ) );
    i->set_flags( bfREPEAT, 1);
    put_in( i,18,0 );
}

static int day_of_week( int day, int month, int year )
{
  int century, yr, dw;

  if( month >= 3 )
    month -= 2;
  else
  {
    month += 10;
    year--;
  }
  century = year / 100;
  yr = year % 100;
  dw = ( ( ( 26 * month - 2 ) / 10 ) + day + yr + ( yr >> 2 ) +
    ( century >> 2 ) - ( 2 * century ) ) % 7;
  if( dw < 0 ) return dw + 7;
  return dw;
}

static char days_in_month( char month, uint year )
{
  static char d_in_m[12] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
  return d_in_m[month-1] + (char) ( !( year & 3 ) && ( month == 2 ) );
}

void Tcalendar::draw( void )
{
  int i, j, cur_days, overflow, xx;
  char c;

  days = days_in_month( month, year );
#ifdef CYR
  txtf( "|b%-9s|t %d|n          |d   ", months[month-1], year );
#else
  txtf( "|b%-9s|t %d|n|dSu|t Mo Tu We Th Fr |dSa", months[month-1], year );
#endif
#ifdef CYR
  cur_days = 1 - ( ( day_of_week( 1, month, year ) + 6 ) % 7 );
#else
  cur_days = 1 - day_of_week( 1, month, year );
#endif
  overflow = cur_days + 35;
  for( i = 0; i < 5; i++ )
  {
    txt( "|n" );
    for( j = 0; j < 7; j++, cur_days++, overflow++ )
    {
      if( overflow > days ) xx = cur_days; else xx = overflow;
      if( ( xx < 1 ) || ( xx > days ) )
        direct_txt( "   " );
      else
      {
        c = 't';
#ifdef CYR
        if( j >= 5 ) c = 'd';
#else
        if( ( j == 0 ) || ( j == 6 ) ) c = 'd';
#endif
        if( ( year == cur_year ) && ( month == cur_month ) && ( xx == cur_day ) ) c = 'b';
        txtf( "|%c%2d|t ", c, xx );
      }
    }
  }
}

void Tcalendar::event_handler( Tevent &ev )
{
  Titem::event_handler( ev );
  if( !state( isFOCUSED ) ) return;
  switch( ev.code )
  {
    case evCOMMAND:
      switch( ev.CMD_CODE )
      {
        case cmUP_ARROW:
          month--;
          if( month < 1 )
          {
            year--;
            month = 12;
          }
          break;
        case cmDOWN_ARROW:
          month++;
          if( month > 12 )
          {
            year++;
            month = 1;
          }
          break;
        default:
          return;
      }
      break;
    case evKEY_PRESS:
      switch( ev.ASCII )
      {
        case kESC:
          put_command( owner, cmDONE );
          break;
        case kENTER:
          year = cur_year;
          month = cur_month;
          break;
        default:
          return;
      }
      break;
    default:
      return;
  }
  handled( ev );
  redraw();
}

//TCALENDAR_WINDOW

Tcalendar_window::Tcalendar_window( void ):
#ifdef CYR
  Twindow( "", 24, 10 )
#else
  Twindow( "Calendar", 24, 10 )
#endif
{
  set_flags( ifRESIZEABLE+ifTILEABLE, 0 );
  set_state( isON_TOP, 1 );
  palette = wpTOOL;
  grow_mode = gmDONT_GROW;
  commands<<cmUP_ARROW<<cmDOWN_ARROW;
  put_in( (Titem *)NEW( Tcalendar ), 2, 2 );
}

Tcalendar_window::~Tcalendar_window( void )
{
  calendar_window = NULL;
}


void calendar( void )
{
  if( calendar_window != NULL )
  {
    calendar_window->focus();
    message( calendar_window, cmWIN_RESTORE );
  }
  else
  {
    _context( cxCALENDAR );
    calendar_window = NEW( Tcalendar_window );
    desktop->put_in( calendar_window, xCENTER, yCENTER );
  }
}
