//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVSCROLL.CPP                         |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Scroll bar implementation            |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_cmd
#define uses_dc
#define uses_icons
#define uses_scroll

#include "PVuses.h"

#ifndef NOMOUSE
static int delta_x = 0;
static int delta_y = 0;
#endif

//Tscroll_bar publics:

Tscroll_bar::Tscroll_bar( int _xl, int _yl, uint &_count, uint &_beg_print ):
  Titem( _xl, _yl )
{
  set_flags( ifSELECTABLE, 0 ); set_flags( sfHIDEABLE, 1 );
  set_state( isON_TOP, 1 );
#ifndef NOMOUSE
  set_events_mask( evMOUSE_REP, 1 );
#endif
  count = &_count;
  beg_print = &_beg_print;
  max_print = NULL;
  delta = 0;
}

void Tscroll_bar::set_flags( uint _flags_word, boolean enable )
{
  Titem::set_flags( _flags_word, enable );
  if( !( _flags_word & sfHANDLE_KEYBOARD ) ) return;
  icon_up->set_events_mask( evKEY_PRESS, flags( sfHANDLE_KEYBOARD ) );
  icon_down->set_events_mask( evKEY_PRESS, flags( sfHANDLE_KEYBOARD ) );
}

void Tscroll_bar::update( void )
{
  do_update();
  if( flags(sfHIDEABLE) )
    set_state( isHIDDEN, *count <= ( *max_print + delta ) );
  else
    if( state(isHIDDEN) ) set_state( isHIDDEN, 0 );
}

//Tscroll_bar protected:

void Tscroll_bar::do_update( void )
{
  char sb_len;

  sb_len = get_bar_length();
  if( *count <= ( *max_print + delta ) )
  {
    sb_length = sb_len;
    sb_begin = 0;
  }
  else
    if( *count && sb_len )
    {
      sb_length = (char) (( ( *max_print + delta ) * sb_len ) / *count);
      if( ( sb_length == sb_len ) && ( *count > sb_len ) && ( sb_len > 1 ) ) sb_length--;
      if( !sb_length ) sb_length++;
      sb_begin = (char)( ( *beg_print * sb_len + ( *count>>1 ) ) / *count );
      if( ( ( sb_begin + sb_length ) > sb_len ) ||
          ( ( *beg_print + ( *max_print + delta ) ) == *count ) )
        sb_begin = (char) ( sb_len - sb_length );
    }
    else
    {
      sb_begin = 0;
      sb_length = 0;
    }
}

void Tscroll_bar::event_handler( Tevent &ev )
{
  Titem::event_handler( ev );
  if( state( isHIDDEN ) || owner->state( isICONIZED ) ) goto ret;
  switch( ev.code )
  {
    case evCOMMAND:
      switch( ev.CMD_CODE )
      {
        case cmUP_ARROW:
        case cmDOWN_ARROW:
          if( owner->state(isACCESSABLE) || !owner->event_mask )
          {
            if( owner->flags( ifSELECTABLE ) && owner->state( isALIVE ) && !owner->state( isFOCUSED ) ) owner->focus();
            if( ev.CMD_CODE==cmUP_ARROW ) up(); else down();
            handled( ev );
            owner->redraw();
            if( flags(sfNOTICE) ) message(owner,cmSCROLL_BAR);
          }
      }
      break;
#ifndef NOMOUSE
    case evMOUSE_DOWN:
      if( ev.INSIDE )
      {
        owner->focus();
        if( mouse_on_bar( ev ) && ( ( *max_print + delta ) < *count ) )
        {
          delta_x = ev.LOCAL_X - sb_begin;
          delta_y = ev.LOCAL_Y - sb_begin;
          while( get_mouse( ev, evMOUSE_DRAG ) )
          {
            goto_bar( ev );
            owner->redraw();
            if( flags(sfNOTICE) ) message(owner,cmSCROLL_BAR);
          }
        }
        else
        {
          boolean f = mouse_on_pgup( ev );
          do
          {
            if( f ) page_up(); else page_down();
            update();
            owner->redraw();
            if( flags(sfNOTICE) ) message(owner,cmSCROLL_BAR);
          }
          while( ev.INSIDE && get_mouse( ev, evMOUSE_REP ) );
        }
        handled( ev );
      }
      break;
#endif
  }
  ret: update();
}

void Tscroll_bar::up( void )
{
  if( *beg_print ) ( *beg_print )--;
}

void Tscroll_bar::down( void )
{
  if( *count > ( *max_print + delta ) )
    if( *beg_print < *count - ( *max_print + delta ) ) ( *beg_print )++;
}

void Tscroll_bar::page_up( void )
{
  if( *beg_print > ( *max_print + delta ) )
    ( *beg_print ) -= ( *max_print + delta ) - 1;
  else
    *beg_print = 0;
}

void Tscroll_bar::page_down( void )
{
  uint xx;

  if( *count > ( *max_print + delta ) )
  {
    xx = *count - ( *max_print + delta );
    *beg_print += ( *max_print + delta ) - 1;
    if( *beg_print >= xx ) *beg_print = xx;
  }
}

void Tscroll_bar::home( void )
{
  *beg_print = 0;
}

void Tscroll_bar::end( void )
{
  if( ( *max_print + delta ) < *count )
    *beg_print = *count - ( *max_print + delta );
  else
    *beg_print = 0;
}

//Tvscroll_bar publics:

Tvscroll_bar::Tvscroll_bar( int _len, uint &_count, uint &_beg_print ):
  Tscroll_bar( i_sb_up_len, _len -= 2, _count, _beg_print )
{
  icon_up = NEW( Ticon( i_sb_up,  cmUP_ARROW,  kUP ) );
    icon_up->set_flags( bfREPEAT, 1 );
    put_in( icon_up, 0, -1 );
  icon_down = NEW( Ticon( i_sb_down,cmDOWN_ARROW,kDOWN ) );
    icon_down->set_flags( bfREPEAT, 1 );
    icon_down->drag_mode = dmDRAG_VER;
    put_in( icon_down, 0, _len );
  grow_mode = gmGROW_VER; drag_mode = dmDRAG_HOR;
}

//Tvscroll_bar protected:

void Tvscroll_bar::calc_bounds( int delta_xl, int delta_yl )
{
  update();
  if( i_sb_up_len != xl )
  {
    drag( x + ( xl - i_sb_up_len ), y );
    resize( i_sb_up_len, yl );
  }
  Tscroll_bar::calc_bounds( delta_xl, delta_yl );
}

void Tvscroll_bar::draw( void )
{
  char c, s;

  do_update();
  if( window_state( isACTIVE ) ) s = '1'; else s = '0';
  c = (char) ( yl - sb_begin - sb_length );
  txtf( "|%c%s|l%c%s|l%c%s|l%c", s, i_vsb_blank, sb_begin, i_vsb_bar, sb_length, i_vsb_blank, c );
}

void Tvscroll_bar::initialize( void )
{
  Tscroll_bar::initialize();
  if( max_print == NULL ) max_print = &owner->yl;
  drag( x, y + 1 );
  update();
}

void Tvscroll_bar::event_handler( Tevent &ev )
{
  Tscroll_bar::event_handler( ev );
  if( ( ev.code == evKEY_PRESS ) && flags( sfHANDLE_KEYBOARD ) )
  {
    switch( ev.ASCII )
    {
      case kHOME:
        home(); break;
      case kEND:
        end(); break;
      case kPG_UP:
        page_up(); break;
      case kPG_DN:
        page_down(); break;
      default:
        return;
    }
    handled( ev );
  }
}

//Tvscroll_bar private:

#ifndef NOMOUSE
boolean Tvscroll_bar::mouse_on_pgup( Tevent &ev )
{
  return ( ev.LOCAL_Y >= 0 ) && ( ev.LOCAL_Y < sb_begin );
}

boolean Tvscroll_bar::mouse_on_pgdn( Tevent &ev )
{
  return ( ev.LOCAL_Y >= ( sb_begin + sb_length ) ) && ( ev.LOCAL_Y <= yl );
}

boolean Tvscroll_bar::mouse_on_bar( Tevent &ev )
{
  return ( ev.LOCAL_Y >= sb_begin ) && ( ev.LOCAL_Y < ( sb_begin + sb_length ) );
}

void Tvscroll_bar::goto_bar( Tevent &ev )
{
  int xx;
  char old;

  old = sb_begin;
  xx = ev.LOCAL_Y - delta_y;
  if( xx<0 )
    sb_begin = 0;
  else
    sb_begin = (char) xx;
  xx = yl - sb_length;
  if( sb_begin > xx ) sb_begin = (char) xx;
  if( sb_begin == old ) return;
  if( sb_begin < xx )
    *beg_print = ( sb_begin * *count ) / yl;
  else
    *beg_print = *count - ( *max_print + delta );
}
#endif

char Tvscroll_bar::get_bar_length( void )
{
  return (char) yl;
}

//Thscroll_bar publics:

Thscroll_bar::Thscroll_bar( int _len, uint &_count, uint &_beg_print ):
  Tscroll_bar( _len -= (i_sb_left_len + i_sb_right_len), 1, _count, _beg_print )
{
  icon_up = NEW( Ticon( i_sb_left, cmUP_ARROW,  kLEFT ) );
    icon_up->set_flags( bfREPEAT, 1 );
    put_in( icon_up, -i_sb_left_len, 0 );
  icon_down = NEW( Ticon( i_sb_right, cmDOWN_ARROW, kRIGHT ) );
    icon_down->set_flags( bfREPEAT, 1 );
    icon_down->drag_mode = dmDRAG_HOR;
    put_in( icon_down, _len, 0 );
  grow_mode = gmGROW_HOR; drag_mode = dmDRAG_VER;
}

//Thscroll_bar potected:

void Thscroll_bar::calc_bounds( int delta_xl, int delta_yl )
{
  int xx;

  update();
  if( i_sb_left_len != -icon_up->x )
  {
    xx = icon_up->x + i_sb_left_len;
    drag( x + xx, y );
    resize( xl - xx - xx - xx, 1 );
    icon_up->drag( -i_sb_left_len, 0 );
    icon_down->drag( xl, 0 );
  }
  Tscroll_bar::calc_bounds( delta_xl, delta_yl );
}

void Thscroll_bar::draw( void )
{
  char c, s;

  do_update();
  if( window_state( isACTIVE ) ) s = '1'; else s = '0';
  c = (char) ( xl - sb_begin - sb_length );
  txtf( "|%c|r%c%s|r%c%s|r%c%s", s, sb_begin, i_hsb_blank, sb_length, i_hsb_bar, c, i_hsb_blank );
}

void Thscroll_bar::initialize( void )
{
  Tscroll_bar::initialize();
  if( max_print == NULL ) max_print = &owner->xl;
  drag( x + i_sb_left_len, y );
  update();
}

//Thscroll_bar private:

#ifndef NOMOUSE
boolean Thscroll_bar::mouse_on_pgup( Tevent &ev )
{
  return ( ev.LOCAL_X >= 0 ) && ( ev.LOCAL_X < sb_begin );
}

boolean Thscroll_bar::mouse_on_pgdn( Tevent &ev )
{
  return ( ev.LOCAL_X >= ( sb_begin + sb_length ) ) && ( ev.LOCAL_X <= xl );
}

boolean Thscroll_bar::mouse_on_bar( Tevent &ev )
{
  return ( ev.LOCAL_X >= sb_begin ) && ( ev.LOCAL_X < ( sb_begin + sb_length ) );
}

void Thscroll_bar::goto_bar( Tevent &ev )
{
  int xx;
  char old;

  old = sb_begin;
  xx = ev.LOCAL_X - delta_x;
  if( xx < 0 )
    sb_begin = 0;
  else
    sb_begin = (char) xx;
  if( sb_begin == old ) return;
  xx = xl - sb_length;
  if( sb_begin < xx )
    *beg_print = ( sb_begin * *count ) / xl;
  else
  {
    sb_begin = (char) xx;
    *beg_print = *count - ( *max_print + delta );
  }
}
#endif

char Thscroll_bar::get_bar_length( void )
{
  return (char) xl;
}
