//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVTXT.CPP                            |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Static & dynamic text support        |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_stdio
#define uses_string
#define uses_dc
#define uses_dialog
#define uses_system
#define uses_txt

#include "PVuses.h"

//Tdtext publics:

Tdtext::Tdtext( int _xl, int _yl ):
  Titem( _xl, _yl )
{
  set_flags( ifSELECTABLE, 0 );
  set_events_mask( ~evCOMMAND, 0 );
  align = _TALIGN_LEFT; color = _TATTR_NORMAL;
  tx = NULL;
}

Tdtext::~Tdtext( void )
{
  if( tx != NULL ) FREE( tx );
}

void Tdtext::set_txt( char *t )
{
  if( tx != NULL ) FREE( tx );
  tx = STRDUP( t );
  redraw();
}

//Tdtext protected:

void Tdtext::set_palette( void )
{
  Titem::set_palette();
  switch( color )
  {
    case _TATTR_BOLD:
      text_attr = bold_attr; return;
    case _TATTR_SELECTED:
      text_attr = selected_attr; return;
    case _TATTR_DISABLED:
      text_attr = disabled_attr;
  }
}

void Tdtext::draw( void )
{
  print( 1 );
}

int Tdtext::print( boolean f )
{
  static char before[] = "|r. ";
  static char after[] = "|r. |n";
  char *s, *i, *j, *k, sk;
  int l, lk, len, lines;

  if( tx == NULL )
    s = "";
  else
    s = tx;
  len = xl - 2;
  k = s; lines = 0;
  do
  {
    i = k; j = k - 1;
    l = -1; lk = 0;
    if( *k && ( *k != '\n' ) )
    {
      do
      {
        do
        {
          j++;
          l++;
        }
        while( *j && ( *j != '\n' ) && ( *j != ' ' ) );
        if( l <= len )
        {
          k = j;
          lk = l;
        }
      }
      while( *j && ( *j != '\n' ) && ( l <= len ) );
      if( !lk )
      {
        k = i + len;
        lk = len;
      }
    }
    sk = *k; *k = 0;
    before[2] = 1; after[2] = 1;
    switch( align )
    {
      case _TALIGN_LEFT:
        after[2] = (char) ( xl - lk - 1 ); break;
      case _TALIGN_RIGHT:
        before[2] = (char) ( xl - lk - 1 ); break;
      case _TALIGN_CENTER:
        before[2] = (char) ( ( ( len - lk + 1 ) >> 1 ) + 1 );
        after[2] = (char) ( xl - lk - 1 );
    }
    if( f ) txt( before ), direct_txt( i ), txt( after );
    *k = sk;
    if( sk && ( ( sk == '\n' ) || ( sk == ' ' ) ) ) k++;
    lines++;
  }
  while( sk || ( lines < yl ) );
  return lines;
}

//Tstext publics:

Tstext::Tstext( char *t, int _xl ):
  Tdtext( _xl, 1 )
{
  set_txt( t );
  resize( xl, print( 0 ) );
}

//PREFIXES

static char talign_ = 0;
static char tcolor_ = 0;

/*
  Description:
    Specify left alignement for text ( static or dynamic ) items. Call just
    before constructing such items.
*/
void _taleft( void )
{
  if( !talign_ ) talign_ = _TALIGN_LEFT;
}

/*
  Description:
    Specify right alignement for text ( static or dynamic ) items. Call just
    before constructing such items.
*/
void _taright( void )
{
  if( !talign_ ) talign_ = _TALIGN_RIGHT;
}

/*
  Description:
    Specify center alignement for text ( static or dynamic ) items. Call just
    before constructing such items.
*/
void _tacenter( void )
{
  if( !talign_ ) talign_ = _TALIGN_CENTER;
}

char __talign( void )
{
  char result = _TALIGN_LEFT;

  if( talign_ ) result = talign_;
  talign_ = 0;
  return result;
}

/*
  Description:
    Specify normal attribute for text ( static or dynamic ) item. Call just
    before constructing such items.
*/
void _tnormal( void )
{
  if( !tcolor_ ) tcolor_ = _TATTR_NORMAL;
}

/*
  Description:
    Specify bold attribute for text ( static or dynamic ) item. Call just
    before constructing such items.
*/
void _tbold( void )
{
  if( !tcolor_ ) tcolor_ = _TATTR_BOLD;
}

/*
  Description:
    Specify selected attribute for text ( static or dynamic ) item. Call just
    before constructing such items.
*/
void _tselected( void )
{
  if( !tcolor_ ) tcolor_ = _TATTR_SELECTED;
}

/*
  Description:
    Specify disabled attribute for text ( static or dynamic ) item. Call just
    before constructing such items.
*/
void _tdisabled( void )
{
  if( !tcolor_ ) tcolor_ = _TATTR_DISABLED;
}

char __tcolor( void )
{
  char result = _TATTR_NORMAL;

  if( tcolor_ ) result = tcolor_;
  tcolor_ = 0;
  return result;
}

//CONSTRUCTORS FOR USE WITH DIALOG BOXES

/*
  Description:
    Construct dynamic text item and insert it in the dialog box.
  Entry:
    _xl, _yl: bounds of the text item.
  Exit:
    Return pointer to the text item.
*/
Tdtext *dtext( int _xl, int _yl )
{
  Tdtext *t;

  t = NEW( Tdtext( _xl, _yl ) );
  t->color = __tcolor();
  t->align = __talign();
  put_item( t, _xl + 1, _yl );
  return t;
}

/*
  Description:
    Construct static text item and insert it in the dialog box.
  Entry:
    txt - text to be displayed;
    _xl - width of the text item.
  Exit:
    Return pointer to the text item.
*/
Tstext *stext( char *txt, int _xl, ... )
{
  Tstext *t;
  va_list argptr;

  va_start( argptr, _xl );
  t = vstext( txt, _xl, argptr );
  va_end( argptr );
  return t;
}

/*
  Description:
    Construct static text item and insert it in the dialog box.
  Entry:
    txt - text to be displayed;
    _xl - width of the text item.
  Exit:
    Return pointer to the text item.
*/
Tstext *vstext( char *txt, int _xl, va_list argptr )
{
  Tstext *t;
  char buffer[512];

  vsprintf( buffer, txt, argptr );
  t = NEW( Tstext( buffer, _xl ) );
  t->color = __tcolor();
  t->align = __talign();
  put_item( t, _xl + 1, t->yl );
  return t;
}
