//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVDESK.H                             |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Desktop support interface            |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

void __init_desktop( void );

#ifndef _PVDESK_H
#define _PVDESK_H
class Tdesktop : public Titem
{
//<R> means read-only
//<R/W> means read/write
  public:
    uint max_tileable; //<R/W> max number of subitems that can be tiled
    boolean tile_columns; //<R/W> tile columns first, or not
    int iconize_x; //<R> initial x of the subitem just iconized
    int iconize_y; //<R> initial y of the subitem just iconized
    int tile_rect_x; //<R/W> define the rectangle for tile/cascade
    int tile_rect_y; //<R/W> the subitems. The subitems are tiled or
    int tile_rect_xl; //<R/W> cascaded inside this rectangular area
    int tile_rect_yl; //<R/W> only.
    Tdesktop( void );
    virtual void resize( int _xl, int _yl );
    virtual void put_in( Titem *v, int _x, int _y );
    virtual boolean remove( Titem *v );
    virtual void tab_next( int direction );
    void update_commands( void );
    void close_all( void );
    void tile( void ); //tile tileable subitems
    void cascade( void ); //cascade tileable subitems
    boolean arrange_icons( void ); //arrange icoized subitems
    void arrange_one_icon( Titem *p ); //arrange one iconized subitem

  protected:
    virtual void calc_bounds( int delta_xl, int delta_yl );
    virtual void event_handler( Tevent &ev );

  private:
    void do_tile( Titem *p ); //use recursion to go back trough the items
    void do_cascade( Titem *p, int _x, int _y ); //use recursion to go back trough the items
    void list_all( void );
};
#endif

void insert_window( Titem *item, int x, int y );

#ifdef DECLARE_PVDESK
Tdesktop *desktop = NULL;
#else
extern Tdesktop *desktop;
#endif
