//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVDRV.H                              |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Drivers interface                    |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

void __init_drivers( void );
void hook_drivers( void );
void unhook_drivers( void );

#ifndef PVDRV_H
#define PVDRV_H

//EVENTS DEFINES

#define MAX_EVENTS 64                  //events queue max length

//hardware events codes
#define evNOTHING     0x0000           //no event pending
#ifndef NOMOUSE
#define evMOUSE_DOWN  0x0001           //mouse button pressed
#define evMOUSE_UP    0x0002           //mouse button depressed
#define evMOUSE_REP   0x0004           //mouse button auto repeat
#define evMOUSE_MOVE  0x0008           //mouse moved
#define evMOUSE_DRAG  0x0010           //mouse moved w/ button down
#define evMOUSE       evMOUSE_DOWN+evMOUSE_UP+evMOUSE_REP+evMOUSE_MOVE+evMOUSE_DRAG

#ifdef HGR
#define evMOUSE_HGR_MOVE 0x1000        //mouse moved one pixel
#define evMOUSE_HGR_DRAG 0x2000        //mouse draged one pixel
#define evHGR_MOUSE   evMOUSE_DOWN+evMOUSE_UP+evMOUSE_REP+evMOUSE_HGR_MOVE+evMOUSE_HGR_DRAG
#endif

#endif
#define evKEY_PRESS   0x0020           //ascii char
#define evKEY_DOWN    0x0040           //key down (short 9)
#define evKEY_UP      0x0080           //key up (short 9)
#define evKEYBOARD    evKEY_PRESS+evKEY_DOWN+evKEY_UP
#define evCOMMAND     0x0100           //internal command

//events priorities
#ifndef NOMOUSE
#define epMOUSE_DOWN  0x1000           //mouse button pressed
#define epMOUSE_UP    0x1000           //mouse button depressed
#define epMOUSE_REP   0x1000           //mouse button auto repeat
#define epMOUSE_MOVE  0x1000           //mouse moved
#define epMOUSE_DRAG  0x1000           //mouse moved w/ button down
#endif
#define epKEY_DOWN    0x2000           //key down (short 9)
#define epKEY_PRESS   0x2000           //ascii char
#define epKEY_UP      0x2000           //key up (short 9)

struct Tevent
{
  uint priority;
  void *destination;
  uint code;
  union
  {
    struct
    {
      unsigned long time_passed;
    } idle;
#ifndef NOMOUSE
    struct
    {
      int local_x;       //owner-based local x
      int local_y;       //owner-based local y
      int local_hgr_x;   //owner-based local x
      int local_hgr_y;   //owner-based local y
      boolean inside;      //mouse in the object
      int global_x;      //screen-based x
      int global_y;      //screen-based y
      int global_hgr_x;  //screen-based x
      int global_hgr_y;  //screen-based y
      char button;         //btn number (0,1,2)
      char buttons;        //buttons status
      char clicks;         //fast-clicks number
    } mouse;
#endif
    struct
    {
      char scan_code;  //k'board scan code
      boolean ext_key; //101-k'board key
      uint ascii;      //extended ASCII code
    } keyboard;
    struct
    {
      uint cmd_code;   //internal cmd code
      void *cmd_info;  //pointer to the info
      uint cmd_size;   //info size
    } command;
  } what;
};

#define TIME_PASSED what.idle.time_passed
#ifndef NOMOUSE
#define LOCAL_X what.mouse.local_x
#define LOCAL_Y what.mouse.local_y
#define LOCAL_HGR_X what.mouse.local_hgr_x
#define LOCAL_HGR_Y what.mouse.local_hgr_y
#define INSIDE what.mouse.inside
#define GLOBAL_X what.mouse.global_x
#define GLOBAL_Y what.mouse.global_y
#define GLOBAL_HGR_X what.mouse.global_hgr_x
#define GLOBAL_HGR_Y what.mouse.global_hgr_y
#define BUTTON what.mouse.button
#define BUTTONS what.mouse.buttons
#define CLICKS what.mouse.clicks
#endif
#define SCAN_CODE what.keyboard.scan_code
#define EXT_KEY what.keyboard.ext_key
#define ASCII what.keyboard.ascii
#define CMD_CODE what.command.cmd_code
#define CMD_INFO what.command.cmd_info
#define CMD_SIZE what.command.cmd_size

//TIMER DEFINES

typedef void ( * Tcallback ) ( void );

//KEYBOARD DEFINES

//scan codes
#define scESC         0x0001
#define sc1           0x0002
#define sc2           0x0003
#define sc3           0x0004
#define sc4           0x0005
#define sc5           0x0006
#define sc6           0x0007
#define sc7           0x0008
#define sc8           0x0009
#define sc9           0x000A
#define sc0           0x000B
#define scMINUS       0x000C //keyboard '-'
#define scEQUAL       0x000D //keyboard '='
#define scBS          0x000E //backspace
#define scTAB         0x000F
#define scQ           0x0010
#define scW           0x0011
#define scE           0x0012
#define scR           0x0013
#define scT           0x0014
#define scY           0x0015
#define scU           0x0016
#define scI           0x0017
#define scO           0x0018
#define scP           0x0019
#define scLBRACKET    0x001A //"["
#define scRBRACKET    0x001B //"]"
#define scENTER       0x001C
#define scCTRL        0x001D
#define scA           0x001E
#define scS           0x001F
#define scD           0x0020
#define scF           0x0021
#define scG           0x0022
#define scH           0x0023
#define scJ           0x0024
#define scK           0x0025
#define scL           0x0026
#define scSEMICOLON   0x0027 //";"
#define scBACK_APOST  0x0028 //"`"
#define scAPOSTROFE   0x0029 //"'"
#define scLSHIFT      0x002A //left shift
#define scBACK_SLASH  0x002B //"\"
#define scZ           0x002C
#define scX           0x002D
#define scC           0x002E
#define scV           0x002F
#define scB           0x0030
#define scN           0x0031
#define scM           0x0032
#define scCOMMA       0x0033 //","
#define scPOINT       0x0034 //"."
#define scSLASH       0x0035 //"/"
#define scRSHIFT      0x0036 //right shift
#define scPRTSC       0x0037 //print screen
#define scALT         0x0038
#define scSPACE       0x0039
#define scCAPS        0x003A
#define scF1          0x003B
#define scF2          0x003C
#define scF3          0x003D
#define scF4          0x003E
#define scF5          0x003F
#define scF6          0x0040
#define scF7          0x0041
#define scF8          0x0042
#define scF9          0x0043
#define scF10         0x0044
#define scNUM         0x0045
#define scSCROLL      0x0046
#define scHOME        0x0047
#define scUP          0x0048
#define scPGUP        0x0049
#define scGRAY_MINUS  0x004A //keypad "-"
#define scLEFT        0x004B //keypad "<-"
#define scCENTER      0x004C //keypad "5"
#define scRIGHT       0x004D //keypad "->"
#define scGRAY_PLUS   0x004E //keypad "+"
#define scEND         0x004F
#define scDOWN        0x0050
#define scPGDN        0x0051
#define scINS         0x0052
#define scDEL         0x0053

//ascii codes
#define kF1           0x3B00
#define kF2           0x3C00
#define kF3           0x3D00
#define kF4           0x3E00
#define kF5           0x3F00
#define kF6           0x4000
#define kF7           0x4100
#define kF8           0x4200
#define kF9           0x4300
#define kF10          0x4400
#define kF11          0x8500
#define kF12          0x8600
#define kTAB          0x0009
#define kCTRL_ENTER   0x1C0A
#define kSPACE        0x0020
#define kBS           0x0008
#define kESC          0x001B
#define kENTER        0x000D
#define kUP           0x4800
#define kDOWN         0x5000
#define kLEFT         0x4B00
#define kRIGHT        0x4D00
#define kPG_UP        0x4900
#define kPG_DN        0x5100
#define kHOME         0x4700
#define kEND          0x4F00
#define kINS          0x5200
#define kDEL          0x5300

//ctrl ascii codes
#define kCTRL_A       0x0001
#define kCTRL_B       0x0002
#define kCTRL_C       0x0003
#define kCTRL_D       0x0004
#define kCTRL_E       0x0005
#define kCTRL_F       0x0006
#define kCTRL_G       0x0007
#define kCTRL_H       0x0008
#define kCTRL_I       0x0009
#define kCTRL_J       0x000A
#define kCTRL_K       0x000B
#define kCTRL_L       0x000C
#define kCTRL_M       0x000D
#define kCTRL_N       0x000E
#define kCTRL_O       0x000F
#define kCTRL_P       0x0010
#define kCTRL_Q       0x0011
#define kCTRL_R       0x0012
#define kCTRL_S       0x0013
#define kCTRL_T       0x0014
#define kCTRL_U       0x0015
#define kCTRL_V       0x0016
#define kCTRL_W       0x0017
#define kCTRL_X       0x0018
#define kCTRL_Y       0x0019
#define kCTRL_Z       0x001A
#define kCTRL_UP      0x8D00
#define kCTRL_DOWN    0x9100
#define kCTRL_LEFT    0x7300
#define kCTRL_RIGHT   0x7400
#define kCTRL_PG_UP   0x8400
#define kCTRL_PG_DN   0x7600
#define kCTRL_HOME    0x7700
#define kCTRL_END     0x7500
#define kCTRL_INS     0x9200
#define kCTRL_DEL     0x9300
#define kCTRL_TAB     0x9400
#define kCTRL_F1      0x5E00
#define kCTRL_F2      0x5F00
#define kCTRL_F3      0x6000
#define kCTRL_F4      0x6100
#define kCTRL_F5      0x6200
#define kCTRL_F6      0x6300
#define kCTRL_F7      0x6400
#define kCTRL_F8      0x6500
#define kCTRL_F9      0x6600
#define kCTRL_F10     0x6700
#define kCTRL_F11     0x8900
#define kCTRL_F12     0x8A00
#define kCTRL_DIV     0x9500
#define kCTRL_MUL     0x9600
#define kCTRL_MINUS   0x8E00
#define kCTRL_PLUS    0x9000
#define kSYS_RQ       0x7200
#define kCTRL_ESC     0xF100
#define kCTRL_SHIFT_TAB 0xF200

//shift ascii codes
#define kSHIFT_F1     0x5400
#define kSHIFT_F2     0x5500
#define kSHIFT_F3     0x5600
#define kSHIFT_F4     0x5700
#define kSHIFT_F5     0x5800
#define kSHIFT_F6     0x5900
#define kSHIFT_F7     0x5A00
#define kSHIFT_F8     0x5B00
#define kSHIFT_F9     0x5C00
#define kSHIFT_F10    0x5D00
#define kSHIFT_F11    0x8700
#define kSHIFT_F12    0x8800
#define kSHIFT_HOME   0x0100
#define kSHIFT_UP     0x0200
#define kSHIFT_PG_UP  0x0300
#define kSHIFT_MINUS  0x0400
#define kSHIFT_LEFT   0x0500
#define kSHIFT_CENTER 0x0600
#define kSHIFT_RIGHT  0x0700
#define kSHIFT_PLUS   0x0800
#define kSHIFT_END    0x0900
#define kSHIFT_DOWN   0x0A00
#define kSHIFT_PG_DN  0x0B00
#define kSHIFT_INS    0x0C00
#define kSHIFT_DEL    0x0D00
#define kSHIFT_TAB    0x0F00

//alt ascii codes
#define kALT_0        0x8100
#define kALT_1        0x7800
#define kALT_2        0x7900
#define kALT_3        0x7A00
#define kALT_4        0x7B00
#define kALT_5        0x7C00
#define kALT_6        0x7D00
#define kALT_7        0x7E00
#define kALT_8        0x7F00
#define kALT_9        0x8000
#define kALT_A        0x1E00
#define kALT_B        0x3000
#define kALT_C        0x2E00
#define kALT_D        0x2000
#define kALT_E        0x1200
#define kALT_F        0x2100
#define kALT_G        0x2200
#define kALT_H        0x2300
#define kALT_I        0x1700
#define kALT_J        0x2400
#define kALT_K        0x2500
#define kALT_L        0x2600
#define kALT_M        0x3200
#define kALT_N        0x3100
#define kALT_O        0x1800
#define kALT_P        0x1900
#define kALT_Q        0x1000
#define kALT_R        0x1300
#define kALT_S        0x1F00
#define kALT_T        0x1400
#define kALT_U        0x1600
#define kALT_V        0x2F00
#define kALT_W        0x1100
#define kALT_X        0x2D00
#define kALT_Y        0x1500
#define kALT_Z        0x2C00
#define kALT_UP       0x9800
#define kALT_DOWN     0xA000
#define kALT_LEFT     0x9B00
#define kALT_RIGHT    0x9D00
#define kALT_PG_UP    0x9900
#define kALT_PG_DN    0xA100
#define kALT_HOME     0x9700
#define kALT_END      0x9F00
#define kALT_INS      0xA200
#define kALT_DEL      0xA300
#define kALT_TAB      0xA500
#define kALT_LBRACKET 0x1A00
#define kALT_RBRACKET 0x1B00
#define kALT_BACKAPOST 0x2800
#define kALT_BACKSLASH 0x2B00
#define kALT_BS       0x0EF0

#define kALT_F1       0x6800
#define kALT_F2       0x6600
#define kALT_F3       0x6A00
#define kALT_F4       0x6B00
#define kALT_F5       0x6C00
#define kALT_F6       0x6D00
#define kALT_F7       0x6E00
#define kALT_F8       0x6F00
#define kALT_F9       0x7000
#define kALT_F10      0x7100
#define kALT_F11      0x8B00
#define kALT_F12      0x8C00
#define kALT_SPACE    0xF000

//shifts management
#define smRSHIFT      0x0001
#define smLSHIFT      0x0002
#define smCTRL        0x0004
#define smALT         0x0008
#define smSCROLL      0x0010
#define smSHIFT       smLSHIFT + smRSHIFT
#define smNUM         0x0020
#define smCAPS        0x0040
#define smINS         0x0080
#define smLCTRL       0x0100
#define smLALT        0x0200

//MOUSE DEFINES

#ifndef NOMOUSE
struct Tmouse_data
{
//public:
  boolean mouse_enabled;
#ifndef HGR
  boolean graph_cursor;
#endif
  boolean reverse_buttons;
  long multi_click_time;
  long repeat_wait_time;
  long repeat_time;
  char buttons_count;
  int mouse_x;
  int mouse_y;
  int mouse_hgr_x;
  int mouse_hgr_y;
  char mouse_buttons;

//private:
  uint old_x;
  uint old_y;
  uint old_hgr_x;
  uint old_hgr_y;
  uint old_buttons;
  uint codes[7];
  uint priorities[7];
  uint reverse[8];
  int multi_click_handle;
  int repeat_handle;
  char click_counter;
#ifndef HGR
  char graph_chars[4];
  int mouse_org_x;
  int mouse_org_y;
  int old_pos_x;
  int old_pos_y;
  int delta_x;
  int delta_y;
  char shape[14];
  char mask[14];
  char cbuf[4];
  char dbuf[64];
#endif
};

#define MOUSE_ENABLED mouse_data.mouse_enabled
#ifndef HGR
#define GRAPH_CURSOR mouse_data.graph_cursor
#endif
#define REVERSE_BUTTONS mouse_data.reverse_buttons
#define MULTI_CLICK_TIME mouse_data.multi_click_time
#define REPEAT_WAIT_TIME mouse_data.repeat_wait_time
#define REPEAT_TIME mouse_data.repeat_time
#define BUTTONS_COUNT mouse_data.buttons_count
#define MOUSE_X mouse_data.mouse_x
#define MOUSE_Y mouse_data.mouse_y
#define MOUSE_HGR_X mouse_data.mouse_hgr_x
#define MOUSE_HGR_Y mouse_data.mouse_hgr_y
#define MOUSE_BUTTONS mouse_data.mouse_buttons

#endif //NOMOUSE

#endif //PVDRV_H

//EVENTS HANDLING INTERFACE

uint get_system_events_mask( void );
void set_system_events_mask( uint em );
void clear_events( void ); //flush (reset) events queue
boolean event_present( void ); //TRUE if there is event(s) pending
boolean put_event( Tevent &ev ); //put an event in the queue
void get_event( Tevent &ev ); //get event from the queue, if no event pending - evNOTHING
boolean events_overflow( void ); //TRUE if events queue overflow detected

//TIMER DRIVER INTERFACE

int alloc_timer( void ); //allocate timer for use, return timer handle (or -1)
void event_request( int handle, Tevent &ev, uint ticks ); //put event "ev" after "ticks" timer ticks
void call_request( int handle, Tcallback callback, uint ticks ); //call function "callback" after "ticks" timer ticks
void cancel_request( int handle ); //cancel previously requested timer service
void free_timer( int handle ); //free previously allocated timer

//KEYBOARD DRIVER INTERFACE

uint get_shifts( void ); //get BIOS shifts state
void put_shifts( uint shift_mask ); //put BIOS shifts state
uint get_key( void ); //get (wait for) key pressed
boolean pressed( uint key ); //TRUE if there is event "key" in the queue
uint lat2alt( uint ascii ); //xlate "key" to "alt+key"
uint alt2lat( uint ascii ); //xlate "alt+key" to "key"
#ifdef CYR
uint alt2cyr( uint ascii ); //xlate "alt+key" to "key"
#endif
uint upcased( uint ascii ); //return upcased key code
uint get_shortcut( char *s ); //scan string "s" for a shortcut and return shortcut key code, or 0

//MOUSE DRIVER INTERFACE

#ifndef NOMOUSE
#ifndef HGR
void graph_mouse( boolean flag ); //enable/disable graphical mouse pointer
void set_graph_cursor( word *def ); //redefine graphical mouse pointer
#endif
void hide_mouse( void );
void show_mouse( void );
void mouse_goto_xy( int x, int y); //move mouse pointer
void get_mouse_speed( uint &sx, uint &sy ); //get mouse tracking sensitivity
void set_mouse_speed( uint sx, uint sy); //set mouse tracking sensitivity
#ifndef HGR
void set_mouse_mask( uint and_mask, uint or_mask); //set and/or mask for non-graph mouse pointer
void set_mouse_chars( char *gc ); //set 4 chars to be used by graphical mouse pointer
void save_chars_def( void ); //save graphical pointer chars definitions (automatically called on startup)
void restore_chars_def( void ); //restore graphical pointer chars definitions (automatically called on exit)
#endif
#endif

#ifndef NOMOUSE
#ifdef DECLARE_PVDRV
Tmouse_data mouse_data =
{
//public:
/* mouse_enabled      */ 1,
#ifndef HGR
/* graph_cursor       */ 1,
#endif
/* reverse_buttons    */ 0,
/* multi_click_time   */ 9,
/* repeat_wait_time   */ 6,
/* repeat_time        */ 1,
/* buttons_count      */ 0,
/* mouse_x            */ 0,
/* mouse_y            */ 0,
/* mouse_hgr_x        */ 0,
/* mouse_hgr_y        */ 0,
/* mouse_buttons      */ 0,

//private:
/* old_x              */ 0,
/* old_y              */ 0,
/* old_hgr_x          */ 0,
/* old_hgr_y          */ 0,
/* old_buttons        */ 0,
/* codes[7]           */ { evMOUSE_MOVE, evMOUSE_DOWN, evMOUSE_UP, evMOUSE_DOWN, evMOUSE_UP, evMOUSE_DOWN, evMOUSE_UP },
/* priorities[7]      */ { epMOUSE_MOVE, epMOUSE_DOWN, epMOUSE_UP, epMOUSE_DOWN, epMOUSE_UP, epMOUSE_DOWN, epMOUSE_UP },
/* reverse[8]         */ { 0, 2, 1, 3, 4, 6, 5, 7 },
/* multi_click_handle */ 0,
/* repeat_handle      */ 0,
/* click_counter      */ 0,
#ifndef HGR
/* graph_chars[4]     */ { '','','','' },
/* mouse_org_x        */ 0,
/* mouse_org_y        */ 0,
/* old_pos_x          */ 0,
/* old_pos_y          */ 0,
/* delta_x            */ 0,
/* delta_y            */ 0,
/* shape[14]          */
/* mask[14]           */
/* cbuf[4]            */
/* dbuf[64]           */
#endif
};
#else
extern Tmouse_data mouse_data;
#endif
#endif //NOMOUSE
