//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVITEMS.H                            |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Base class for PV items interface    |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#ifndef _PVITEMS_H
#define _PVITEMS_H

#define xCENTER -32767
#define yCENTER -32767
#define xlMAX   -32767
#define ylMAX   -32767

//ITEM FLAGS

//ALL ITEMS
#define ifVISIBLE            0x0001 //<Y> item can draw itself
#define ifBUFFERED           0x0002 //<N> item supports draw buffer
#define ifSELECTABLE         0x0004 //<Y> item can be selected
#define ifCLOSEABLE          0x0008 //<Y> item supports cmDONE command
#define ifMOVABLE            0x0010 //<Y> item can be dragged
#define ifRESIZEABLE         0x0020 //<Y> item can be resized
#define ifTAB_STOP           0x0040 //<Y> item is selected when user tabs
#define ifTILEABLE           0x0080 //<N> item can be tiled in a group
#define ifICONIZEABLE        0x0100 //<N> item can be iconized in a group
#define ifSTAY               0x0200 //<N> do not dispose the item
#define ifPRE_PROCESS        0x0400 //<N> get focused msg before current
//MENU
#define mfSUSPEND_SELECTION  0x1000 //<Y> delay on submenu open
//BUTTON
#define bfGRAB_FOCUS         0x0800 //<N> gets selected when pressed
#define bfREPEAT             0x1000 //<N> repeat message if held down
#define bfBROADCAST          0x2000 //<N> if not receiver is the owner
#define bfSTOP_MODAL         0x4000 //<N> to stop owner exec or not
#define bfDEFAULT            0x8000 //<N> is this the default button
//LIST BOX
#define lfMULTIPLY_SELECTION 0x1000 //<N>
#define lfSTOP_MODAL         0x2000 //<Y>
//SCROLL BAR
#define sfHANDLE_KEYBOARD    0x1000 //<N> if not bar ignores kbd messages
#define sfHIDEABLE           0x2000 //<Y> hide bar when it is full,or not
#define sfNOTICE             0x4000 //<N> as acted send cmSCROLL_BAR to owner
//TABLE
#define tfDOUBLE_CLICK_OK    0x1000 //<Y> table send cmOK when double clicked
#define tfDIALOG             0x2000 //<N>
#define tfWHOLE_LINES        0x4000 //<Y> table selection moves whole lines

//ITEM STATES

//ITEM
#define isVALID              0x0001 //item can be used
#define isMODAL              0x0002 //item is currently modal
#define isSELECTED           0x0004 //item is selected
#define isFOCUSED            0x0008 //item is focused
#define isDISABLED           0x0010 //item is disabled
#define isON_TOP             0x0020 //item is on top of the owner
#define isHIDDEN             0x0040 //item is hidden
#define isICONIZED           0x0080 //item is currently iconized
#define isALIVE              0x0100 //(indirectly) owned by the app
#define isACCESSABLE         0x0200 //(ind) owned by the modal item
#define isACTIVE             0x0400 //isSELECTED or not ifSELECTABLE
//WINDOW
#define wsMAXIMIZED          0x1000 //window is currently maximized
//BUTTON
#define bsDEFAULT            0x1000 //button is the default button

//ITEM DRAG MODES

#define dmDONT_DRAG          0x0000
#define dmDRAG_HOR           0x0001 //drag when owner width changes
#define dmDRAG_VER           0x0002 //drag when owner heigh changes
#define dmDRAG_BOTH          dmDRAG_HOR+dmDRAG_VER
#define dmDRAG_REL           0x0004 //drag rel. to the owner bounds

//ITEM GROW MODES

#define gmDONT_GROW          0x0000
#define gmGROW_HOR           0x0001 //grow when owner width changes
#define gmGROW_VER           0x0002 //grow when owner heigh changes
#define gmGROW_BOTH          gmGROW_HOR+gmGROW_VER
#define gmGROW_REL           0x0004 //grow rel. to the owner bounds

typedef void ( * Ttile_error ) ( void );
typedef void ( * Tdraw_proc ) ( void );

class Tdrag_drop;

class Titem
{
//<R> means read-only
//<R/W> means read/write
  public:
    uint flags_word; //<R> holds item options
    uint state_word; //<R> holds current state of the item
    uint event_mask; //<R> events bit mask
    Titem *next; //<R> next item in the owner's list ( cirular )
    Titem *owner; //<R> the owner of the item
    Titem *last; //<R> the last subitem
    Titem *current; //<R> currently selected subitem
    int x; //<R> upper-left corner x in owner's coordinate
    int y; //<R> upper-left corner y in owner's coordinate
    int xl; //<R> width in text chars
    int yl; //<R> heigh in text lines
    int bound_x; //<R> local x for item's bounding rectangle
    int bound_y; //<R> local y for item's bounding rectangle
    int bound_xl; //<R> item's bounding rectangle width
    int bound_yl; //<R> item's bounding rectangle heigh
    char grow_mode; //<R/W> how the item resize when owner resized
    char drag_mode; //<R/W> how the item move when owner resized
    long drop_id; //<R/W> drop identificator - used for drag&drop
    uint stop_state; //<R> terminate code for the local exec loop
#ifndef NOHELP
    uint help_ctx; //<R/W> 0 - use owner's help ctx
#endif
    Titem( int _xl, int _yl );
    virtual ~Titem( void );
    Titem *first( void ); //return first subitem
    Titem *prev( void ); //return previous item (circular)
    Titem *nextl( void ); //return next item (linear)
    Titem *prevl( void ); //return previous item (linear)
    virtual void set_flags( uint _flags_word, boolean enable ); //set item's flags bits
    inline boolean flags( uint _flags_word ) { return ( flags_word & _flags_word ) != 0; }
    virtual void set_state( uint _state_word, boolean enable ); //set item's state bits
    inline boolean state( uint _state_word ) { return ( state_word & _state_word ) != 0; }
    boolean window_state( uint _state_word ); //check state bits of the item's owner just before the application or desktop ( usually this is the window that holds the item )
    boolean focus( void ); //focus the item, returns 0 if not successfull
    virtual void pop_up( void ); //called on mouse_click
    virtual void tab_next( int direction ); //select next/previous tab stop item
    virtual void local_next( int direction ); //select next/previous item between two tab stop items
    void set_events_mask( uint mask, boolean enable ); //set item's event mask
    virtual void drag( int _x, int _y ); //move the item to the _x,_y location
    virtual void resize( int _xl, int _yl ); //resize the item to _xl/_yl width/heigh
    void make_local( int x1, int y1, int &x2, int &y2 ); //convert global x1,y1 coordinates to local x2,y2
    void make_global( int x1, int y1, int &x2, int &y2 ); //convert local x1,yl coordinates to global x2,y2
    void get_origin( int &_x, int &_y ); //make_global( 0,0,_x,_y )
    virtual boolean check_inside( int _x, int _y ); //return non-zero if point _x,_y is inside the item
    virtual void redraw( void ); //invalidate the item, cousing it to be redrawn during next screen update session
    virtual void handle_event( Tevent &ev ); //calls event_handler for every subitem ( if any ), and then, if the event still not serviced, calls self event_handler
    Titem *handle_command( Titem *receiver, uint cmd_code ); //constructs a command event and calls receiver's handle event
    virtual boolean valid( uint command ); //returns 0 if action command not allowed
    virtual uint exec( void ); //start item modal loop
    uint exec_item( Titem *p, int _x, int _y ); //insert p in the subitems list and executes p
    virtual void put_in( Titem *v, int _x, int _y ); //insert item v in the subitems list
    virtual boolean remove( Titem *v ); //remove item v from the subitems list. returns 0 if item not found
    void update_bounds( Titem *p ); //update actual item bounds as subitem was moved/resized
    void optimize_bounds( void ); //minimize actual item bounds
    void pop_item( Titem *w ); //brings item w to the front of the subitems list
    virtual boolean cenabled( uint cmd );
    virtual boolean cdisabled( uint cmd );
    virtual void cenable( uint cmd );
    virtual void cdisable( uint cmd );
    virtual void cstate( uint cmd, boolean enable );
    virtual void drop( void *data ); //called in drag-and-drop session when user drops something over the item

  protected:
    boolean items_changed; //items list has been changed
    int curs_x; //<R/W> cursor x position in local coordinates
    int curs_y; //<R/W> cursor y position in local coordinates
    int curs_type; //<R/W> 0 - no cursor; 1 - insert; 2 - overstrike
    char backgrnd_attr; //<R/W> attribute for item's background
    char backgrnd_char; //<R/W> character for item's background
    virtual void get_focused( void ); //called when item gets focused
    virtual boolean release_focus( void ); //called when item is about to loose the focus
    virtual void calc_bounds( int delta_xl, int delta_yl ); //called when item's owner has been resized by delta
    void get_clip_rect( int &_x, int &_y, int &_xl, int &_yl ); //return bounds of the invalid rectangle
    virtual int exposed( void ); //return non-zero if item is exposed on the screen DC region
    void reverse_paint( Titem *p ); //call paint for every subitem
    virtual void paint( void ); //draw self, then draw all subitems as well
    virtual void set_palette( void ); //set item's palette ( called just before a call to draw )
    virtual void draw( void ); //draw item on the screen
    virtual void initialize( void ); //called when item just has been inserted in another item
    virtual boolean isit_4u( Tevent &ev ); //return non-zero if event ev can be handled by the item ( also used for setting up event's local data )
    virtual void event_handler( Tevent &ev ); //handle event ev
    virtual void get_event( Tevent &ev ); //if owner!=NULL calls owner's get_event else returns first available event in the events queue
#ifndef NOMOUSE
    boolean get_mouse( Tevent &ev, uint mask ); //calls get_event until a mouse event occurs and it is not masked by mask. return 0 if event is evMOUSE_UP
#endif
    void get_key( Tevent &ev, uint mask ); //calls get_event until a keyboard event occurs
    virtual void put_event( Tevent &ev ); //inserts event ev in the events queue
    void put_command( Titem *receiver, uint cmd_code ); //constructs a command event and calls put_event
    void handled( Tevent &ev ); //called from an event_handler to indicate that event has been successfully handled
    void stop( uint stop_code ); //terminate exec loop
    virtual void ok_item( void ); //item accepted
    virtual void cancel_item( void ); //item cancelled
    void pop_top_items( void ); //brings all the 'always on top' items to the front

  private:
#ifndef NOHELP
    uint get_help_ctx( void ); //get item's help context. if item has no help context, calls owner's get_help_ctx
#endif
    void do_pop_top_items( Titem *p ); //use recursion to go back trough the items

  friend class Tapplication;
  friend class Tdrag_drop;
  friend Titem *message( Titem *receiver, uint command );
  friend Titem *broadcast( uint command );
  friend Titem *modal_broadcast( uint command );
};

struct Tdrop_info
{
  long drop_id;
  int drop_x;
  int drop_y;
  void *drop_data;
};

#endif//_PVITEMS_H

boolean is_valid( Titem *item ); //check validity of an item and delete it if not valid

#ifndef NOHELP
void _help( uint hlp_ctx ); uint __help( void ); //prefix: specify item's help context ( call before item construction )
#endif

void _command_info( void *cmd_info, uint cmd_size ); //prefix: specify command's info&size ( call before a call to message, broadcast or modal_broadcast
Titem *message( Titem *receiver, uint command ); //send a message to the receiver
Titem *broadcast( uint command ); //broadcast a message to all the subitems of the application
Titem *modal_broadcast( uint command ); //broadcast a message to all the subitems of the currently modal item
#ifndef NOMOUSE
void _drag_draw( int xl, int yl, Tdraw_proc draw_proc ); //prefix: specify draw proc for drag&drop
void pick_up( int x, int y, long id, void *data ); //pick up data for drag&drop
#endif

#ifdef DECLARE_PVITEMS
Ttile_error tile_error = NULL;
Titem *modal_item = NULL;
Titem *item_acted = NULL;
#else
extern Ttile_error tile_error;
extern Titem *modal_item;
extern Titem *item_acted;
#endif
