//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW IDE                       |
// |  File:        THIDE.CPP                            |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Thide_on_close class implementation  |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_cmdgen
#define uses_table
#include "PVUSES.H"

#define _DECLARE_THIDE_H
  #include "THIDE.H"
#undef  _DECLARE_THIDE_H


/*
public
*/
  Thide_on_close::Thide_on_close( int _xl, int _yl ):
    Tlist_iterator( _xl, _yl )
  {
    set_flags( tfDOUBLE_CLICK_OK, 1 );
  }

  void Thide_on_close::set_state( uint _state_word, char enable )
  {
    Titem *window;

    Tlist_iterator::set_state( _state_word, enable );
    if( owner==NULL || ((window=owner->owner)==NULL) ) return;
    if( _state_word&isHIDDEN )
    {
      window->set_state( isHIDDEN, enable );
      if( enable )
      {
        if( window->state( isSELECTED ) ) window->owner->tab_next( -1 );
        if( window->state( isSELECTED ) ) window->set_state( isSELECTED, 0 );
      }
      else
      {
        window->set_state( isSELECTED, 0 );
        focus();
      }
    }
  }

  boolean Thide_on_close::valid( uint command )
  {
    if( command == cmDONE )
    {
      set_state( isHIDDEN, 1 );
      return 0;
    }
    return Tlist_iterator::valid( command );
  }


/*
protected
*/
  void Thide_on_close::event_handler( Tevent &ev )
  {
    Tlist_iterator::event_handler( ev );
    if( ev.code==evKEY_PRESS && ev.ASCII==kESC && state(isFOCUSED) )
    {
      put_command( this, cmDONE );
      handled( ev );
    }
  }
