//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW IDE                       |
// |  File:        TLOG.H                               |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Tlog class interface                 |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#include "THIDE.H"

#ifndef _TLOG_H_INCLUDED
#define _TLOG_H_INCLUDED

  #define cxLOG                 101
  #define cmLOG_GOTO            cmOK
  #define cmLOG_CLEAR           cmCLEAR
  #define cmLOG_CLIP_COPY       cmCOPY

  class Tlog: public Thide_on_close
  {
    public:
      Tlog( int _xl, int _yl );
      virtual void fetch( char *buffer, uint row, uint column, uint width );
      void editors_supervisor( char *file_name, uint where, int bytes, int lines );
      void clip_copy( void );
      void logout( char *text, ... );
      void show_first_error( void );
      void load( char *filename );
      void show_error( boolean focused );
      void nexterr( boolean focused );
      void preverr( boolean focused );

    protected:
      virtual void event_handler( Tevent &ev );
      virtual void update_commands( void );
  };

#endif //_TLOG_H_INCLUDED


#ifdef _DECLARE_TLOG_H
  #define GLOBAL
#else
  #define GLOBAL extern
#endif
  GLOBAL Tlog *log;
#undef GLOBAL

void construct_log( void );
void win_log( void );
void log_nexterr( void );
void log_preverr( void );
