//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW IDE                       |
// |  File:        W.CPP                                |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Main module and PV interface         |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_ctype
#define uses_stdio
#define uses_string

#define uses_app
#define uses_calc
#define uses_comlin
#define uses_desk
#define uses_icons
#define uses_init
#define uses_editor
#define uses_help
#define uses_ht
#define uses_stddlg
#define uses_system
#define uses_table
#define uses_tetris
#define uses_txt

#include "PVUSES.H"
#include "COMPILE.H"
#include "TLOG.H"
#include "TPROJECT.H"
#include "OPTIONS.H"

#define _DECLARE_W_H
  #include "W.H"
#undef  _DECLARE_W_H


/*
DEFINES
*/
  #define MAX_CLOSED_FILES              64
  #define MAX_MENU_CLOSED_FILES         9
  #define MAX_CLOSED_FILE_LENGTH        25

  #define cmFILE_OPEN_CURS              0x1010
  #define cmCLIPBOARD                   0x1011
  #define cmCONDENSE                    0x1012
  #define cmCOM_COMPILE                 0x1013
  #define cmCOM_MAKE                    0x1014
  #define cmCOM_BUILD                   0x1015
  #define cmCOM_LINK                    0x1016
  #define cmCOM_TIMECHECK               0x1017
  #define cmCOM_NEXTERR                 0x1018
  #define cmCOM_PREVERR                 0x1019
  #define cmCOM_RUN                     0x101A
  #define cmCOM_PARAMS                  0x101B
  #define cmPRJ_OPEN                    0x1020
  #define cmPRJ_CLOSE                   0x1021
  #define cmPRJ_EXPORT                  0x1022
  #define cmOPT_FAST                    0x1030
  #define cmOPT_COM_CODE                0x1031
  #define cmOPT_COM_ADVCODE             0x1032
  #define cmOPT_COM_TARGET              0x1033
  #define cmOPT_COM_SEGS                0x1034
  #define cmOPT_COM_FP                  0x1035
  #define cmOPT_COM_DEBUG               0x1036
  #define cmOPT_COM_EXC                 0x1037
  #define cmOPT_COM_OPT                 0x1038
  #define cmOPT_COM_MSG                 0x1039
  #define cmOPT_COM_PRE                 0x103A
  #define cmOPT_COM_NAMES               0x103B
  #define cmOPT_LINKER                  0x103C
  #define cmOPT_EDITOR                  0x103D
  #define cmOPT_DIRS                    0x103E
  #define cmOPT_TOOLS                   0x103F
  #define cmOPT_OPEN                    0x1040
  #define cmOPT_SAVE                    0x1041
  #define cmOPT_SAVE_AS                 0x1042
  #define cmWIN_CALCULATOR              0x1050
  #define cmWIN_TETRIS                  0x1051
  #define cmWIN_PROJECT                 0x1052
  #define cmWIN_LOG                     0x1053
  #define cmWIN_DOS_SCREEN              0x1054
  #define cmWINDOW_CLOSED_WINDOWS       0x1060
  #define cmCLOSED_FILES                0x1061
  #define cmTOOLS                       0x1070


/*
STRUCTS
*/
  struct Tcmd_file
  {
    char *filename;
    Tcmd_file *next;
  };


/*
STATIC DATA
*/
  static Tcmd_file *cmd_files=NULL;
  static Tlb_list closed_files;
  static char menu_titles[MAX_MENU_CLOSED_FILES][MAX_CLOSED_FILE_LENGTH+5];
  static Tmenu_item *file_exit_ptr;
  static Tmenu *file_menu_ptr;
  static boolean disable_closed_files = 0;
  static char wst_signature[] = "\r\nPower View IDE status file.\r\n\032";


/*
CONSTRUCT FILENAMES
*/
  char *tmp_fname( char *result, char *fname )
  {
    char drive[_MAX_DRIVE];
    char dir[_MAX_DIR];

    _splitpath( fname, drive, dir, NULL, NULL );
    if( *drive || *dir )
      strcpy( result, fname );
    else
    {
      strcpy( result, default_directories.tmp_files );
      strcat( result, fname );
    }
    return result;
  }

  char *exe_fname( char *result, char *path )
  {
    char fname[_MAX_FNAME];
    strcpy( result, default_directories.objects );
    _splitpath( path, NULL, NULL, fname, NULL );
    strcat( result, fname );
    return result;
  }

  char *exe_file( char *result, char *path )
  {
    return strcat( exe_fname(result,path), ".EXE" );
  }

  char *obj_file( char *result, char *path )
  {
    char fname[_MAX_FNAME];
    strcpy( result, default_directories.objects );
    _splitpath( path, NULL, NULL, fname, NULL );
    strcat( result, fname );
    strcat( result, ".OBJ" );
    return result;
  }

  char *target_file( char *result, char *path )
  {
    char drive[_MAX_DRIVE];
    char dir[_MAX_DIR];
    _splitpath( path, drive, dir, NULL, NULL );
    *result = 0;
    if( *drive==0 && *dir==0 )
      strcpy( result, default_directories.objects );
    strcat( result, path );
    return result;
  }


/*
FILE I/O
*/
  static void update_closed_files( void )
  {
    char buffer[_MAX_PATH];
    if( disable_closed_files ) return;
    update_menu( file_menu_ptr, file_exit_ptr );
    if( closed_files.vcount ) mitem();
    for( int i=0; i<closed_files.vcount && i<MAX_MENU_CLOSED_FILES; i++ )
    {
      Tedit_window_status *ew = (Tedit_window_status *)closed_files.getptr(i);
      short_path( min_path(strcpy(buffer,ew->file_name)), MAX_CLOSED_FILE_LENGTH-1 );
      sprintf( menu_titles[i], "|~%d %s", i+1, buffer );
      _help( htFILE_CLOSED_FILES );
      mitem( menu_titles[i], cmCLOSED_FILES+i );
    }
    if( closed_files.vcount )
    {
      _help(htWINDOW_CLOSED_WINDOWS);
      mitem( "|~0 Closed windows list", cmWINDOW_CLOSED_WINDOWS );
    }
    update_menu( NULL, NULL );
  }

  static void file_opened( Tedit_window *w )
  {
    if( disable_closed_files ) return;
    char *fn = w->editor->text_editor->file_name;
    if( *fn )
      for( int i=0; i<closed_files.vcount; i++ )
      {
        Tedit_window_status *ew = (Tedit_window_status *)closed_files.getptr(i);
        if( !strcmp(fn,ew->file_name) )
        {
          w->restore_status( *ew );
          w->set_state( isICONIZED, 0 );
          closed_files.del(i);
          update_closed_files();
          return;
        }
      }
    w->resize( desktop_xl, desktop_yl - ( desktop_yl / 3 ) );
  }

  static void file_closed( Tedit_window *w )
  {
    char *fn = w->editor->text_editor->file_name;
    uint  bl = w->editor->text_editor->buf_len;
    if( disable_closed_files || *fn==0 || bl==0 ) return;
    Tedit_window_status ew;
    w->save_status( ew );
    closed_files.ins( 0, &ew );
    while( closed_files.vcount>MAX_CLOSED_FILES )
      closed_files.del( closed_files.vcount-1 );
    update_closed_files();
  }

  static boolean __editor_path = 0;
  static char *search_file( char *buffer )
  {
    if( *buffer )
    {
      char filespec[_MAX_PATH], *b, *s;
      char drive[_MAX_DRIVE];
      char dir[_MAX_DIR];
      char fname[_MAX_FNAME];
      char ext[_MAX_EXT];
      FILE *f = NULL;
      fexpand( buffer );
      add_ext( buffer, editor_options.extension );
      strcpy( filespec, buffer );
      f = fopen( buffer, "rb" );
      if( __editor_path && f==NULL && current_editor!=NULL )
      {
        _splitpath( ((Tfile_editor *)current_editor->editor)->text_editor->file_name, drive, dir, NULL, NULL );
        _splitpath( buffer, NULL, NULL, fname, ext );
        _makepath( buffer, drive, dir, fname, ext );
        f = fopen( buffer, "rb" );
      }
      __editor_path = 0;
      for( s=b=default_directories.include; f==NULL; s++ )
        if( *s==';' || *s==0 )
        {
          char saved = *s;
          *s = 0;
          _splitpath( filespec, NULL, NULL, fname, ext );
          _splitpath( b, drive, dir, NULL, NULL );
          _makepath( buffer, drive, dir, fname, ext );
          f = fopen( buffer, "rb" );
          *s = saved;
          if( saved==0 ) break;
          b = s+1;
        }
      if( f==NULL )
        strcpy( buffer, filespec );
      else
        fclose( f );
    }
    return buffer;
  }

  static Tedit_window *w_open_file( char *filespec )
  {
    if( editor_options.flags&efOPEN_INCLUDE ) search_file( filespec );
    _help( htW_EDITOR );
    return open_file( filespec );
  }

  static Tedit_window *w_edit_file( char *filespec )
  {
    if( editor_options.flags&efOPEN_INCLUDE ) search_file( filespec );
    _help( htW_EDITOR );
    return edit_file( filespec );
  }


/*
STATUS SAVE/RESTORE
*/
  #define stEDITOR    0
  #define stLOGOUT    1
  #define stPROJECT   2
  boolean save_status( void )
  {
    FILE *f;
    Tedit_window_status st;
    Tfile_editor *e;
    Titem *p;
    Twindow *w;
    int n, old;
    char kind;
    uint sh;
    boolean result;

    disable_closed_files = 1;
    close_calculator();
    f = fopen( "STATUS.W", "wb" );
    p = desktop->first();
    n = 0;
    result = ( fwrite( wst_signature, sizeof( wst_signature ), 1, f ) == 1 ) &&
             ( fwrite( &n, sizeof( n ), 1, f ) == 1 ) &&
#ifndef NOMOUSE
             ( fwrite( &toolbar_enabled, sizeof( toolbar_enabled ), 1, f ) == 1 ) &&
#endif
             ( fwrite( &time_check, sizeof(time_check), 1, f ) == 1 ) &&
             ( fwrite( &desktop->iconize_x, sizeof( desktop->iconize_x ), 1, f ) == 1 ) &&
             ( fwrite( &desktop->iconize_y, sizeof( desktop->iconize_y ), 1, f ) == 1 ) &&
             ( fwrite( options_filename, sizeof( options_filename ), 1, f ) == 1 ) &&
             ( fwrite( program_params, sizeof( program_params ), 1, f ) == 1 ) &&
             ( fwrite( &closed_files.vcount, sizeof( closed_files.vcount ), 1, f ) == 1 );
    for( uint i=0; result && i<closed_files.vcount; i++ )
    {
      Tedit_window_status *ew=(Tedit_window_status *)closed_files.getptr(i);
      result = ( fwrite( ew, sizeof(Tedit_window_status), 1, f )==1 );
    }
    while( result && ( p != NULL ) )
    {
      sh = 0;
      old = n;
      e = open_editors;
      while( !ferror( f ) && result && ( e != NULL ) )
      {
        if( ( e->text_editor != clipboard ) && ( e->owner == p ) )
        {
          kind = stEDITOR;
          ( (Tedit_window *) e->owner )->save_status( st );
          sh = ( (Twindow *)e->owner )->shortcut;
          n++;
          break;
        }
        e = e->next_editor;
      }
      if( ( project != NULL ) &&
          ( ( w = (Twindow *) project->owner->owner ) == p ) )
      {
        kind = stPROJECT;
        strcpy( st.file_name, project->filename );
        n++;
      }
      else
        if( ( w = (Twindow *) log->owner->owner ) == p )
        {
          kind = stLOGOUT;
          n++;
        }
      if( w == p )
      {
        if( w->state( isICONIZED ) )
        {
          st.icon_x = w->x;
          st.icon_y = w->y;
        }
        else
        {
          st.icon_x = w->icon_x;
          st.icon_y = w->icon_y;
        }
        if( w->state( isICONIZED|wsMAXIMIZED ) )
        {
          st.x      = w->x_saved;
          st.y      = w->y_saved;
          st.xl     = w->xl_saved;
          st.yl     = w->yl_saved;
        }
        else
        {
          st.x      = w->x;
          st.y      = w->y;
          st.xl     = w->xl;
          st.yl     = w->yl;
        }
        st.state    = w->state_word;
        sh          = w->shortcut;
      }
      if( n != old )
        result = result &&
          ( fwrite( &kind, sizeof( kind ), 1, f ) == 1 ) &&
          ( fwrite( &st,   sizeof( st ),   1, f ) == 1 ) &&
          ( fwrite( &sh,   sizeof( sh ),   1, f ) == 1 );
      p = p->nextl();
    }
    if( result )
    {
      fseek( f, sizeof( wst_signature ), SEEK_SET );
      result = ( fwrite( &n, sizeof( n ), 1, f ) == 1 );
    }
    fclose( f );
    disable_closed_files = 0;
    return result && !ferror( f );
  }

  static boolean restore_status( void )
  {
    char tmp_signature[ sizeof( wst_signature ) ];
    FILE *f;
    Titem *focused;
    Twindow *w;
    Tedit_window_status st;
    int i, n;
    char kind;
    uint sh;
    uint _time_check;
    uint closed_files_num;
#ifndef NOMOUSE
    uint _toolbar_enabled;
#endif
    Tset wn;
    char options_fn[_MAX_PATH];
    boolean result;

    f = fopen( "STATUS.W", "rb" );
    if( f == NULL ) return 0;
    memset( tmp_signature, 0, sizeof( tmp_signature ) );
    fread( tmp_signature, sizeof( tmp_signature ), 1, f );
    if( memcmp( tmp_signature, wst_signature, sizeof( tmp_signature ) ) )
    {
      _terror();
      ok( "\"STATUS.W\" is not a Power View IDE status file." );
      fclose( f );
      return 0;
    }
    disable_closed_files = 1;
    if( log != NULL ) DELETE( log->owner->owner );
    log = NULL;
    project_close();
    *options_fn = 0;
    result = ( fread( &n, sizeof( n ), 1, f ) == 1 ) &&
#ifndef NOMOUSE
             ( fread( &_toolbar_enabled, sizeof( _toolbar_enabled ), 1, f ) == 1 ) &&
#endif
             ( fread( &_time_check, sizeof(_time_check), 1, f ) == 1 ) &&
             ( fread( &desktop->iconize_x, sizeof( desktop->iconize_x ), 1, f ) == 1 ) &&
             ( fread( &desktop->iconize_y, sizeof( desktop->iconize_y ), 1, f ) == 1 ) &&
             ( fread( options_fn, sizeof( options_fn ), 1, f ) == 1 ) &&
             ( fread( program_params, sizeof( program_params ), 1, f ) == 1 ) &&
             ( fread( &closed_files_num, sizeof( closed_files_num ), 1, f ) == 1 );
    result = (result && closed_files_num<=MAX_CLOSED_FILES);
    closed_files.clear();
    for( i=0; result && i<closed_files_num; i++ )
    {
      Tedit_window_status ew;
      if( result=(fread(&ew,sizeof(ew),1,f)==1) )
        closed_files.add( &ew );
    }
    update_closed_files();
#ifndef NOMOUSE
    if( result && _toolbar_enabled!=toolbar_enabled ) broadcast( cmWINDOW_TOOLBAR );
#endif
    if( result && _time_check!=time_check ) broadcast( cmCOM_TIMECHECK );
    focused = NULL;
    ~wn;
    for( i = 0; result && i < n; i++ )
    {
      result = ( fread( &kind, sizeof( kind ), 1, f ) == 1 ) &&
               ( fread( &st,   sizeof( st ),   1, f ) == 1 ) &&
               ( fread( &sh,   sizeof( sh ),   1, f ) == 1 );
      if( !result ) break;
      w = NULL;
      switch( kind )
      {
        case stEDITOR:
          _help( htW_EDITOR );
          w = open_file( st );
          break;
        case stPROJECT:
          open_project( st.file_name, 1 );
          if( project != NULL )
          {
            w = (Twindow *) project->owner->owner;
          w_setup:
            w->set_state( st.state, 0 );
            w->resize( st.xl, st.yl );
            w->drag( st.x, st.y );
            w->icon_x = st.icon_x;
            w->icon_y = st.icon_y;
            w->set_state( st.state, 1 );
          }
          break;
        case stLOGOUT:
          construct_log();
          w = (Twindow *) log->owner->owner;
          goto w_setup;
        default:
          result = 0;
      }
      if( w != NULL )
      {
        if( st.state & isSELECTED ) focused = w;
        desktop->tab_next( -1 );
        w->shortcut = sh;
        if( sh ) wn<<sh;
      }
    }
    win_nums = wn;
    fclose( f );
    if( result = result && !ferror( f ) )
    {
      if( focused != NULL ) focused->focus();
      load_options( options_fn, 1 );
    }
    else
      closed_files.clear();
    if( log == NULL ) construct_log();
    disable_closed_files = 0;
    update_closed_files();
    return result;
  }
  #undef stEDITOR
  #undef stLOGOUT
  #undef stPROJECT


/*
MENU FILE
*/
  static void file_new( void )
  {
    _help( htW_EDITOR );
    open_file( "" );
  }

  static void file_open( void )
  {
    char f[_MAX_PATH];
    static char dir_svd[_MAX_PATH] = "";
    static uint filt_svd=0;
    uint gf;
    _multi_files();
    _get_file_svd( dir_svd, filt_svd );
    _filters( filter_str );
    while( gf=get_file("Open a file",f) )
      if( gf==cmOK )
      {
        w_open_file(f);
        break;
      }
      else
        open_file(f);
  }

  static void file_open_at_cursor( void )
  {
    char buffer[_MAX_PATH];
    if( current_editor == NULL ) return;
    current_editor->get_word_str( buffer, _MAX_PATH - 1 );
    if( *buffer )
    {
      __editor_path++;
      w_edit_file( buffer );
    }
  }

  static void file_dos_shell( void )
  {
    exec( 0, getenv( "COMSPEC" ), "", "" );
  }


/*
MENU SEARCH
*/
  static boolean main_line( uint line_start, uint level )
  {
    uint n;
    char c;

    if( ( current_editor->line_end( line_start ) - line_start ) < editor_options.condense_length ) return 0;
    c = 0;
    n = 0;
    while( n <= level )
    {
      c = current_editor->buf_char( line_start );
      if( c == ' ' )
        n++;
      else
        if( c == '\t' )
          n += tab_size - ( n % tab_size );
        else
          break;
      line_start++;
    }
    c = toupper( c );
    return ( n <= level ) && ( c >= 'A' ) && ( c <= 'Z' );
  }

  static Tlist_box *condensed_list;
  struct Tcondensed_list_data
  {
    uint offset; //offset of the text in the current edit buffer
    uint level;  //condense level for that entry
  };

  static void ins_condensed_line( uint line_start, uint level, uint index )
  {
    char buf1[51], buf2[51], *s, *d;
    uint l, i;
    Tcondensed_list_data cld;

    l = current_editor->line_end( line_start ) - line_start;
    if( l > 50 ) l = 50;
    current_editor->get_text( buf1, line_start, l );
    while( buf1[--l] < ' ' );
    buf1[++l] = 0;
    memset( buf2, ' ', sizeof( buf2 ) ); buf2[50] = 0;
    for( i = 0, s = buf1, d = buf2; *s && ( i < 50 ); s++ )
    {
      l = 1;
      *d = *s;
      if( *s == '\t' )
      {
        *d = ' ';
        l = tab_size - ( i % tab_size );
      }
      i += l;
      d += l;
    }
    cld.offset = line_start; cld.level = level;
    _ldata( &cld );
    condensed_list->ins( index, buf2 );
  }

  #define cmCONDENSE_LEFT  cmUSER00
  #define cmCONDENSE_RIGHT cmUSER01
  static boolean condense_validator( uint command )
  {
    uint beg, end, o, i, this_level;
    Tcondensed_list_data cld;

    if( command == cmCONDENSE_LEFT )
    {
      beg = end = condensed_list->vcurrent;
      condensed_list->getdata( beg, &cld );
      this_level = cld.level;
      while( beg && ( cld.level >= this_level ) )
        condensed_list->getdata( --beg, &cld );
      if( ( beg == 0 ) && ( cld.level == this_level ) ) return 0;
      condensed_list->getdata( end, &cld );
      while( ( end < condensed_list->vcount ) && ( cld.level >= this_level ) )
        condensed_list->getdata( ++end, &cld );
      for( o = end-1; o > beg; o-- )
        condensed_list->del( o );
      condensed_list->at( beg );
      return 0;
    }
    if( command == cmCONDENSE_RIGHT )
    {
      end = current_editor->buf_len;
      beg = i = condensed_list->vcurrent + 1;
      if( i < condensed_list->vcount )
      {
        condensed_list->getdata( i, &cld );
        end = cld.offset;
      }
      condensed_list->getdata( condensed_list->vcurrent, &cld );
      this_level = cld.level + 2;
      if( this_level > 254 ) return 0;
      o = current_editor->next_line( cld.offset );
      for( ; o < end; o = current_editor->next_line( o ) )
        if( main_line( o, this_level ) ) ins_condensed_line( o, this_level, i++ );
      condensed_list->at( beg );
      return 0;
    }
    return 1;
  }

  static void condense( void )
  {
    uint n, o, p;
    Tcondensed_list_data cld;

    if( current_editor == NULL ) return;
    _help( htD_CONDENSED );
    dialog( "Condensed display" );
    validator( condense_validator );
    _lsize( sizeof( Tcondensed_list_data ) );
    condensed_list = list_box( "|~Main lines", n, 50, 13 );
    condensed_list->scroll_ahead = 2;
    condensed_list->set_flags( ifSTAY, 1 );
    condensed_list->h_bar->set_flags( sfHANDLE_KEYBOARD, 0 );
    p = current_editor->line_start( current_editor->cur_ptr );
    while( p && !main_line( p, editor_options.condense_column ) )
      p = current_editor->prev_line( p );
    n = 0;
    for( o = 0; o < current_editor->buf_len; o = current_editor->next_line( o ) )
      if( main_line( o, editor_options.condense_column ) )
      {
        ins_condensed_line( o, editor_options.condense_column, condensed_list->vcount );
        if( o == p ) n = condensed_list->vcount - 1;
      }
    condensed_list->at( n );
    hor(); hspacing( 1 ); nl(); vspace(); _acenter();
    kbutton( " Edit " );
    button ( "  <<  ", cmCONDENSE_LEFT  )->shortcut = kLEFT;
    button ( "  >>  ", cmCONDENSE_RIGHT )->shortcut = kRIGHT;
    cbutton( "Cancel" );
    hbutton( " Help " );
    if( ( run() == cmOK ) && condensed_list->vcount )
    {
      current_editor->editor->owner->set_state( isICONIZED, 0 );
      condensed_list->getdata( n, &cld );
      current_editor->set_cur_ptr( cld.offset, 0 );
      for( Tfile_editor *e=open_editors; e!=NULL; e=e->next_editor )
        if( e->state( isFOCUSED ) )
        {
          e->track_cursor( 1 );
          break;
        }
    }
    DELETE( condensed_list );
    condensed_list = NULL;
  }
  #undef cmCONDENSE_LEFT
  #undef cmCONDENSE_RIGHT


/*
MENU WINDOWS
*/
  static Tlist_box *closed_windows_lbox;
  static boolean closed_windows_list_validator( uint command )
  {
    boolean result = 0;
    if( command!=cmDELETE )
      result = 1;
    else
      closed_windows_lbox->del( closed_windows_lbox->vcurrent );
    closed_windows_lbox->cstate( cmDELETE, closed_windows_lbox->vcount );
    closed_windows_lbox->cstate( cmOK, closed_windows_lbox->vcount );
    return result;
  }

  static void closed_windows_list( void )
  {
    uint cur_cf;
    _help( htD_CLOSED_WINDOWS ); dialog( "Closed windows list" );
    validator( closed_windows_list_validator );
    closed_windows_lbox = list_box( "|~Closed windows", cur_cf, 35, 11, &closed_files );
    nc();
    kbutton( " Open " );
    cbutton( " Done " );
    button( "|~Delete", cmDELETE )->shortcut = kDEL;
    hbutton( " Help " );
    closed_windows_list_validator(0);
    if( run()==cmOK && closed_files.vcount )
    {
      _help( htW_EDITOR );
      open_file( ((Tedit_window_status *)closed_files.getptr(cur_cf))->file_name );
    }
    update_closed_files();
  }


  static void win_dos_screen( void )
  {
    Tevent ev;
    char pv_mode, pv_char_size;

    pv_mode = scr_mode;
    pv_char_size = scr_char_size;
#ifndef NOMOUSE
    hide_mouse();
#endif
    restore_dos_screen();
#if !defined( NOICONS ) && !defined( HGR )
    restore_graph_chars();
#endif
#if !defined( NOMOUSE ) && !defined( HGR )
    restore_chars_def();
#endif
    clear_events();
    do
    {
      get_event( ev );
    }
    while( ev.code!=evKEY_DOWN
#ifndef NOMOUSE
      && ev.code!=evMOUSE_DOWN
#endif
    );
#if !defined( NOMOUSE ) && !defined( HGR )
    save_chars_def();
#endif
#if !defined( NOICONS ) && !defined( HGR )
    set_graph_chars();
#endif
    save_dos_screen();
    set_video_mode( pv_mode, pv_char_size );
#ifndef HGR
    set_blink( 0 );
#endif
#ifndef NOMOUSE
    show_mouse();
#endif
    idle( 0 );
    application->redraw();
    application->refresh_screen();

    if( ev.code == evKEY_DOWN )
      while( ev.code != evKEY_UP   ) get_event( ev );
#ifndef NOMOUSE
    if( ev.code == evMOUSE_DOWN )
      while( ev.code != evMOUSE_UP ) get_event( ev );
#endif
    clear_events();
  }


/*
MENU HELP
*/
#pragma off( unreferenced )
  static void help_about( void )
  {
    static char program_id[] = "Program ID: PVIDE";
    _title( "About" );
    _inothing();
    _tacenter();
    _help( htABOUT );
    ok( "POWER VIEW IDE\n\nVersion 5.00\n\nWritten by Emil Dotchevski\n\nUnregistered Shareware Version " );
  }
#pragma on( unreferenced )


/*
POWER VIEW INTERFACE
*/
  static void cmdhandler( uint cmd_code, void *cmd_info )
  {
    switch( cmd_code )
    {
      case cmeEDITOR_OPEN:
        file_opened( (Tedit_window *)cmd_info );
        break;
      case cmeEDITOR_CLOSE:
        file_closed( (Tedit_window *)cmd_info );
        break;
      case cmFILE_NEW:
        file_new();
        break;
      case cmFILE_OPEN:
        file_open();
        break;
      case cmFILE_OPEN_CURS:
        file_open_at_cursor();
        break;
      case cmFILE_DOS_SHELL:
        file_dos_shell();
        break;
      case cmCLIPBOARD:
        show_clipboard();
        break;
      case cmCONDENSE:
        condense();
        break;
      case cmCOM_COMPILE:
        project_compile();
        break;
      case cmCOM_MAKE:
        project_make();
        break;
      case cmCOM_BUILD:
        project_build();
        break;
      case cmCOM_LINK:
        project_link();
        break;
      case cmCOM_TIMECHECK:
        time_check = cmCOM_TIMECHECK-time_check;
        break;
      case cmCOM_NEXTERR:
        log_nexterr();
        break;
      case cmCOM_PREVERR:
        log_preverr();
        break;
      case cmCOM_RUN:
        project_run();
        break;
      case cmCOM_PARAMS:
        project_params();
        break;
      case cmPRJ_OPEN:
        project_open();
        break;
      case cmPRJ_CLOSE:
        project_close();
        break;
      case cmPRJ_EXPORT:
        project_export();
        break;
      case cmOPT_FAST:
        options_fast();
        break;
      case cmOPT_COM_CODE:
        options_compiler_code_generation();
        break;
      case cmOPT_COM_ADVCODE:
        options_compiler_advanced_code_generation();
        break;
      case cmOPT_COM_TARGET:
        options_compiler_target();
        break;
      case cmOPT_COM_SEGS:
        options_compiler_segment_registers();
        break;
      case cmOPT_COM_FP:
        options_compiler_floating_point();
        break;
      case cmOPT_COM_DEBUG:
        options_compiler_debugging();
        break;
      case cmOPT_COM_EXC:
        options_compiler_exceptions_handling();
        break;
      case cmOPT_COM_OPT:
        options_compiler_optimizations();
        break;
      case cmOPT_COM_MSG:
        options_compiler_messages();
        break;
      case cmOPT_COM_PRE:
        options_compiler_preprocess_files();
        break;
      case cmOPT_COM_NAMES:
        options_compiler_names();
        break;
      case cmOPT_LINKER:
        options_linker();
        break;
      case cmOPT_EDITOR:
        options_editor();
        break;
      case cmOPT_DIRS:
        options_directories();
        break;
      case cmOPT_TOOLS:
        options_tools();
        break;
      case cmOPT_OPEN:
        options_open();
        break;
      case cmOPT_SAVE:
        options_save();
        break;
      case cmOPT_SAVE_AS:
        options_save_as();
        break;
      case cmWINDOW_CLOSED_WINDOWS:
        closed_windows_list();
        break;
      case cmWIN_CALCULATOR:
        _help( htW_CALCULATOR ); calculator();
        break;
      case cmWIN_TETRIS:
        _help( htW_TETRIS ); tetris();
        break;
      case cmWIN_PROJECT:
        win_project();
        break;
      case cmWIN_LOG:
        win_log();
        break;
      case cmWIN_DOS_SCREEN:
        win_dos_screen();
        break;
      case cmHELP_ABOUT:
        help_about();
        break;
      default:
        if( cmd_code>=cmTOOLS && cmd_code<cmTOOLS+ot_tools->vcount )
          exec_tool( cmd_code - cmTOOLS, "" );
        if( cmd_code>=cmCLOSED_FILES && cmd_code<cmCLOSED_FILES+MAX_MENU_CLOSED_FILES )
        {
          int i = cmd_code-cmCLOSED_FILES;
          if( i<closed_files.vcount )
          {
            _help( htW_EDITOR );
            open_file( ((Tedit_window_status *)closed_files.getptr(i))->file_name );
          }
        }
    }
    boolean has_project = project != NULL;
    boolean project_focused = has_project && project->state( isFOCUSED );
    boolean has_editor = current_editor != NULL;
    boolean not_empty = has_project && project->vcount;
    boolean has_program = has_project || has_editor;
    cstate( cmSAVE_ALL, open_editors!=NULL && open_editors->text_editor!=clipboard );
    cstate( cmWIN_PROJECT, has_project );
    cstate( cmCONDENSE, has_editor );
    cenable( cmPRJ_OPEN );
    cstate( cmPRJ_CLOSE, has_project );
    cstate( cmPRJ_EXPORT, has_project );
    cstate( cmCOM_COMPILE, has_editor );
    cstate( cmCOM_MAKE, has_program );
    cstate( cmCOM_BUILD, has_program );
    cstate( cmCOM_LINK, has_program );
    cstate( cmWINDOW_CLOSED_WINDOWS, closed_files.vcount );
    if( log != NULL )
    {
      cstate( cmCOM_NEXTERR, log->vcurrent + 1 < log->vcount );
      cstate( cmCOM_PREVERR, log->vcurrent > 0 );
    }
    cstate( cmCOM_RUN, has_program );
    cenable( cmCOM_PARAMS );
  }

  static void context_handler( int context )
  {
#ifndef NOMOUSE
    construct_toolbar();
    add_tool( "?", cmHELP, kF1 );
    add_tool( "Open", cmFILE_OPEN, kF3 );
    add_tool( "Save", cmFILE_SAVE, kF2 );
    add_tool( "Run", cmCOM_RUN, kF5 );
    add_tool( "Make", cmCOM_MAKE, kF9 );
    add_tool( "Compile", cmCOM_COMPILE, kALT_F9 );
    add_tool( "<<", cmCOM_PREVERR, kF7 );
    add_tool( ">>", cmCOM_NEXTERR, kF8 );
    local_key( toolbar, cmWIN_CALCULATOR, kCTRL_C );
    for( uint i = 0; i < ot_tools->vcount; i++ )
    {
      Ttools_entry *te = (Ttools_entry *) ot_tools->getptr( i );
      if( te->shortcut ) local_key( toolbar, cmTOOLS + i, te->shortcut );
    }
#endif
    menu();
    switch( context )
    {
      case cxCALCULATOR:
        _help( htEDIT_CUT );        mitem( "Cu|~t", "Shift+Del", cmCUT );
        _help( htEDIT_COPY );       mitem( "|~Copy", "Ctrl+Ins", cmCOPY );
        _help( htEDIT_PASTE );      mitem( "|~Paste", "Shift+Ins", cmPASTE );
        _help( htEDIT_CLEAR );      mitem( "C|~lear", "Del", cmCLEAR );
                                    mitem();
#ifndef NOMOUSE
                                    add_tool( "Cut", cmCUT, kSHIFT_DEL );
                                    add_tool( "Copy", cmCOPY, kCTRL_INS  );
                                    add_tool( "Paste", cmPASTE, kSHIFT_INS );
                                    add_tool( "Clear", cmCLEAR, kCTRL_DEL );
#endif
        break;
      case cxEDITOR:
        _help( htEDIT_UNDO );       mitem( "|~Undo", "Alt+BkSp", cmUNDO );
        _help( htSEARCH_FIND );     mitem( "|~Find...", "Ctrl+Q F", cmeFIND );
        _help( htSEARCH_REPLACE );  mitem( "R|~eplace...", "Ctrl+Q A", cmeREPLACE );
        _help( htSEARCH_LINE );     mitem( "|~Go to line...", "Ctrl+J", cmeGOTO_LINE );
        _help( htSEARCH_CONDENSE ); mitem( "Co|~ndense...", "Esc", cmCONDENSE );
        _help( htSEARCH_FILE );     mitem( "File at |~cursor", "Ctrl+Enter", cmFILE_OPEN_CURS );
                                    mitem();
        _help( htEDIT_CUT );        mitem( "Cu|~t", "Shift+Del", cmCUT );
        _help( htEDIT_COPY );       mitem( "|~Copy", "Ctrl+Ins", cmCOPY );
        _help( htEDIT_PASTE );      mitem( "|~Paste", "Shift+Ins", cmPASTE );
        _help( htEDIT_CLEAR );      mitem( "C|~lear", "Del", cmCLEAR );
                                    mitem();
#ifndef NOMOUSE
                                    add_tool( "Cut", cmCUT, kSHIFT_DEL );
                                    add_tool( "Copy", cmCOPY, kCTRL_INS  );
                                    add_tool( "Paste", cmPASTE, kSHIFT_INS );
                                    add_tool( "Clear", cmCLEAR, kCTRL_DEL );
#endif
        break;
      case cxLOG:
        _help( htEDIT_COPY );       mitem( "|~Copy", "Ctrl+Ins", cmLOG_CLIP_COPY );
        _help( htEDIT_CLEAR );      mitem( "C|~lear", "Ctrl+Del", cmLOG_CLEAR );
                                    mitem();
#ifndef NOMOUSE
                                    add_tool( "Copy", cmLOG_CLIP_COPY, kCTRL_INS );
                                    add_tool( "Clear", cmLOG_CLEAR, kCTRL_DEL );
#endif
        break;
      case cxPROJECT:
        _help( htPROJECT_ADD );     mitem( "|~Add entry...", "Ctrl+A", cmPRJ_ADD );
        _help( htPROJECT_INS );     mitem( "|~Insert entry...", "Ins", cmPRJ_INS );
        _help( htPROJECT_DEL );     mitem( "|~Delete entry...", "Del", cmPRJ_DEL );
        _help( htPROJECT_EDIT );    mitem( "|~Edit file", "Enter", cmPRJ_EDIT_FILE );
                                    mitem();
        _help( htPROJECT_LOCAL );   mitem( "|~Local options...", "Ctrl+O", cmPRJ_OPTIONS );
        _help( htPROJECT_DEPENDS ); mitem( "De|~pends...", "Ctrl+D", cmPRJ_DEPENDS );
                                    mitem();
        _help( htPROJECT_EXPORT );  mitem( "E|~xport make file...", cmPRJ_EXPORT );
                                    mitem();
#ifndef NOMOUSE
                                    add_tool( "Add", cmPRJ_ADD, kCTRL_A );
                                    add_tool( "Ins", cmPRJ_INS, kINS );
                                    add_tool( "Del", cmPRJ_DEL, kDEL );
                                    add_tool( "Options", cmPRJ_OPTIONS, kCTRL_O );
                                    local_key( toolbar, cmPRJ_DEPENDS, kCTRL_D );
#endif
    }
    if( context!=cxTETRIS )
    {
      _help( htWINDOW_LIST );       mitem( "|~Windows list...", "Ctrl+Esc", cmWINDOW_LIST );
      if( closed_files.vcount )
      _help(htWINDOW_CLOSED_WINDOWS);mitem( "Clo|~sed windows list", cmWINDOW_CLOSED_WINDOWS );
    }
#ifndef NOMOUSE
                                    add_tool( "Exit", cmFILE_EXIT, kALT_X );
#endif
    construct_local_menu( endm() );
  }

  static void w_editors_supervisor( char *file_name, uint where, int bytes, int lines )
  {
    if( log != NULL )
      log->editors_supervisor( file_name, where, bytes, lines );
  }


/*
STARTUP
*/
  static void show_syntax( void )
  {
    restore_dos_screen();
#if !defined( NOICONS ) && !defined( HGR )
    restore_graph_chars();
#endif
    printf("\
Power View IDE written by Emil Dotchevski\n\
\n\
Command line syntax:\n\
  W [switches] [parameters] [<filename>[%s]] ...\n\
\n\
Switches:\n\
  /?     This help message\n\
  /BW    Use black-and-white palette in color text modes\n\
  /COLOR Use color palette in black-and-white text modes\n\
  /M+    Use arrow mouse pointer\n\
  /M-    Use bar mouse pointer\n\
  /G+    Use graphical screen controls\n\
  /G-    Don't use graphical screen controls\n\
\n\
Parameters:\n\
  /INI:<filename>[.INI] Specify init file to use\n\
  /OPT:<filename>[.PVO] Specify options file to use\n\
\n\
Note: Filename wilcards are allowed\n", editor_options.extension );
    exit( 1 );
  }

  static void proceed_command_line( void )
  {
    char s[_MAX_PATH];
    FILE *f;

    if( param_spec( "/OPT:", s ) )
    {
      add_ext( s, ".PVO" );
      fexpand( s );
      f = fopen( s, "rb" );
      if( f == NULL )
      {
        _terror();
        ok( "Can't read options file %s", s );
        exit( 1 );
      }
      fclose( f );
      load_options( s, 1 );
    }
    if( param_opt("/?") ) show_syntax();
    while( param_filenames(s,editor_options.extension) )
    {
      Tcmd_file *x=NEW(Tcmd_file);
      x->filename=STRDUP(s);
      x->next=cmd_files;
      cmd_files=x;
    }
  }

  static void init_options( void )
  {
    char *p;

    if( *options_filename == 0 )
    {
      p = strchr( startup_path, 0 );
      if( !load_options( "SAVED.PVO", 0 ) )
      {
        strcpy( p, "SAVED.PVO" );
        load_options( startup_path, 0 );
      }
      if( *options_filename == 0 )
      {
        strcpy( p, "SAVED.PVO" );
        options_file_changed( startup_path );
        *options_filename=0;
      }
      *p = 0;
    }
  }

  void init_main_menu( void )
  {
    uint i;
    static char buf[15][10];
    Ttools_entry *te;
                               menu();
    _help( htMENU_FILE );        submenu( " |~File " );
    _help( htFILE_NEW );           mitem( "|~New", cmFILE_NEW );
    _help( htFILE_OPEN );          mitem( "|~Open...", "F3", cmFILE_OPEN );
    _help( htFILE_SAVE );          mitem( "|~Save", "F2", cmFILE_SAVE );
    _help( htFILE_SAVE_AS );       mitem( "Save |~as...", cmFILE_SAVE_AS );
    _help( htFILE_SAVE_ALL );      mitem( "Save a|~ll", "Ctrl+F2", cmSAVE_ALL );
                                   mitem();
    _help( htFILE_DOS_SHELL );     mitem( "|~DOS shell", cmFILE_DOS_SHELL );
    _help( htFILE_EXIT );
                 file_exit_ptr =   mitem( "E|~xit", "Alt+X", cmFILE_EXIT );
                 file_menu_ptr = endm();
    _help( htMENU_EDIT );        submenu( " |~Edit " );
    _help( htEDIT_UNDO );          mitem( "|~Undo", "Alt+BkSp", cmUNDO );
                                   mitem();
    _help( htEDIT_CUT );           mitem( "Cu|~t", "Shift+Del", cmCUT );
    _help( htEDIT_COPY );          mitem( "|~Copy", "Ctrl+Ins", cmCOPY );
    _help( htEDIT_PASTE );         mitem( "|~Paste", "Shift+Ins", cmPASTE );
    _help( htEDIT_CLEAR );         mitem( "C|~lear", "Del", cmCLEAR );
                                   mitem();
    _help( htEDIT_CLIPBOARD );     mitem( "|~Show clipboard", cmCLIPBOARD );
                                 endm();                           
    _help( htMENU_SEARCH );      submenu( " |~Search " );
    _help( htSEARCH_FIND );        mitem( "|~Find...", "Ctrl+Q F", cmeFIND );
    _help( htSEARCH_REPLACE );     mitem( "|~Replace...", "Ctrl+Q A", cmeREPLACE );
    _help( htSEARCH_AGAIN );       mitem( "|~Search again", "Ctrl+L", cmeSEARCH_AGAIN );
    _help( htSEARCH_LINE );        mitem( "|~Go to line...", "Ctrl+J", cmeGOTO_LINE );
                                   mitem();
    _help( htSEARCH_CONDENSE );    mitem( "|~Condense...", "Esc", cmCONDENSE );
                                 endm();                           
    _help( htMENU_COMPILE );     submenu( " |~Compile " );
    _help( htCOMPILE_COMPILE );    mitem( "|~Compile", "Alt+F9", cmCOM_COMPILE );
    _help( htCOMPILE_MAKE );       mitem( "|~Make", "F9", cmCOM_MAKE );
    _help( htCOMPILE_BUILD );      mitem( "|~Build all", cmCOM_BUILD );
    _help( htCOMPILE_LINK );       mitem( "|~Link", cmCOM_LINK );
    _help( htCOMPILE_TIMECHECK );  mitem( "|~Time validity check", time_check, cmCOM_TIMECHECK );
                                   mitem();
    _help( htCOMPILE_NEXT );       mitem( "|~Next message", "F8", cmCOM_NEXTERR );
    _help( htCOMPILE_PREVIOUS );   mitem( "|~Previous message", "F7", cmCOM_PREVERR );
                                   mitem();
    _help( htCOMPILE_RUN );        mitem( "|~Run", "F5", cmCOM_RUN );
    _help( htCOMPILE_PARAMS );     mitem( "P|~arameters...", cmCOM_PARAMS );
                                 endm();                           
    _help( htMENU_PROJECT );     submenu( " |~Project " );
    _help( htPROJECT_OPEN );       mitem( "|~Open...", cmPRJ_OPEN );
    _help( htPROJECT_CLOSE );      mitem( "|~Close", cmPRJ_CLOSE );
                                   mitem();
    _help( htPROJECT_ADD );        mitem( "|~Add entry...", "Ctrl+A", cmPRJ_ADD );
    _help( htPROJECT_INS );        mitem( "|~Insert entry...", "Ins", cmPRJ_INS );
    _help( htPROJECT_EDIT );       mitem( "|~Edit file", "Enter", cmPRJ_EDIT_FILE );
    _help( htPROJECT_DEL );        mitem( "|~Delete entry...", "Del", cmPRJ_DEL );
                                   mitem();
    _help( htPROJECT_LOCAL );      mitem( "|~Local options...", "Ctrl+O", cmPRJ_OPTIONS );
    _help( htPROJECT_DEPENDS );    mitem( "De|~pends...", "Ctrl+D", cmPRJ_DEPENDS );
                                   mitem();
    _help( htPROJECT_EXPORT );     mitem( "E|~xport make file...", cmPRJ_EXPORT );
                                 endm();                           
    _help( htMENU_OPTIONS );     submenu( " |~Options " );
    _help( htOPTIONS_FAST );       mitem( "|~Fast...", cmOPT_FAST );
    _help( htOPTIONS_COMPILER );   submenu( "|~Compiler" );
    _help( htCOMPILER_CODE );        mitem( "|~Code...", cmOPT_COM_CODE );
    _help( htCOMPILER_ADV_CODE );    mitem( "|~Advanced code...", cmOPT_COM_ADVCODE );
    _help( htCOMPILER_TARGET );      mitem( "|~Build target...", cmOPT_COM_TARGET );
    _help( htCOMPILER_OPTIMIZATIONS);mitem( "|~Optimizations...", cmOPT_COM_OPT );
    _help( htCOMPILER_DEBUGGING );   mitem( "|~Debugging...", cmOPT_COM_DEBUG );
    _help( htCOMPILER_FLOATING );    mitem( "|~Floating-point...", cmOPT_COM_FP );
    _help( htCOMPILER_EXCEPTIONS );  mitem( "C++ e|~xceptions...", cmOPT_COM_EXC );
    _help( htCOMPILER_SEGMENTS );    mitem( "|~Segment regs...", cmOPT_COM_SEGS );
    _help( htCOMPILER_PREPROCESSOR); mitem( "|~Preprocessor...", cmOPT_COM_PRE );
    _help( htCOMPILER_NAMES );       mitem( "|~Names...", cmOPT_COM_NAMES );
    _help( htCOMPILER_MESSAGES );    mitem( "|~Messages...", cmOPT_COM_MSG );
                                   endm();
    _help( htOPTIONS_LINKER );     mitem( "|~Linker...", cmOPT_LINKER );
    _help( htOPTIONS_EDITOR );     mitem( "|~Editor...", cmOPT_EDITOR );
    _help( htOPTIONS_DIRS );       mitem( "|~Directories...", cmOPT_DIRS );
    _help( htOPTIONS_TOOLS );      mitem( "|~Tools...", cmOPT_TOOLS );
                                   mitem();
    _help( htOPTIONS_OPEN );       mitem( "|~Open...", cmOPT_OPEN );
    _help( htOPTIONS_SAVE );       mitem( "|~Save", short_options_filename, cmOPT_SAVE );
    _help( htOPTIONS_SAVE_AS );    mitem( "Save |~as...", cmOPT_SAVE_AS );
                                 endm();                           
    _help( htMENU_TOOLS );       submenu( " |~Tools " );
                                   if( ot_tools->vcount > 0 )
                                   {
                                     for( i = 0; i < ot_tools->vcount; i++ )
                                     {
                                       te = (Ttools_entry *) ot_tools->getptr( i );
                                       if( te->shortcut )
                                       {
                                         sprintf( buf[i], "Shift+F%-2d", ( te->shortcut - 0x5300 ) >> 8 );
    _help( htTOOLS_TOOL );               mitem( te->title, buf[i], cmTOOLS+i );
                                       }
                                       else
                                       {
    _help( htTOOLS_TOOL );               mitem( te->title, cmTOOLS+i );
                                       }
                                     }
#ifndef NOMOUSE
                                     mitem();
#endif
                                   }
#ifndef NOMOUSE
    _help( htTOOLS_TOOLBAR );      mitem( "Tool|~bar", toolbar_enabled, cmWINDOW_TOOLBAR );
#endif
                                 endm();                           
    _help( htMENU_WINDOWS );     submenu( " |~Windows " );
    _help( htWINDOW_TILE );        mitem( "|~Tile", cmWINDOW_TILE );
    _help( htWINDOW_CASCADE );     mitem( "C|~ascade", cmWINDOW_CASCADE );
    _help( htWINDOW_CLOSE_ALL );   mitem( "Cl|~ose all", cmWINDOW_CLOSE_ALL );
    _help( htWINDOW_ARRANGE );     mitem( "Arrange |~icons", cmWINDOW_ARRANGE_ICONS );
    _help( htWINDOW_REFRESH );     mitem( "|~Refresh display", cmWINDOW_REFRESH );
                                   mitem();
    _help( htWINDOW_NEXT );        mitem( "|~Next", "F6", cmWINDOW_NEXT );
    _help( htWINDOW_PREVIOUS );    mitem( "Pre|~vious", "Ctrl+F6", cmWINDOW_PREVIOUS );
    _help( htWINDOW_LIST );        mitem( "|~List...", "Ctrl+Esc", cmWINDOW_LIST );
    _help(htWINDOW_CLOSED_WINDOWS);mitem( "Clo|~sed windows list", cmWINDOW_CLOSED_WINDOWS );
                                   mitem();
    _help( htWINDOW_PROJECT );     mitem( "|~Project", "Ctrl+P", cmWIN_PROJECT );
    _help( htWINDOW_LOGOUT );      mitem( "Lo|~g", "Ctrl+G", cmWIN_LOG );
    _help( htWINDOW_CALCULATOR );  mitem( "|~Calculator", "Ctrl+C", cmWIN_CALCULATOR );
    _help( htWINDOW_TETRIS );      mitem( "T|~etris...", cmWIN_TETRIS );
    _help( htWINDOW_DOS_SCREEN );  mitem( "|~DOS screen", "F4", cmWIN_DOS_SCREEN );
                                 endm();                           
    _help( htMENU_HELP );        submenu( " |~Help " );
    _help( htMHELP_USING_HELP );   mitem( "|~Help using help...", cmHELP_USING );
    _help( htMHELP_CONTENTS );     mitem( "|~Contents...", cmHELP_CONTENTS );
                                   mitem();
    _help( htMHELP_ABOUT );        mitem( "|~About...", cmHELP_ABOUT );
                                 endm();                      
          construct_main_menu( endm() );
    update_closed_files();
  }

  void init_w( void )
  {
    char *p;
    closed_files.data_size = TEDIT_WINDOW_STATUS_SIZE;
    cpp_hilight_extensions = editor_options.cpp_extensions;
    asm_hilight_extensions = editor_options.asm_extensions;
    p = strchr( startup_path, 0 );
    strcpy( p, "W.HLP" );
    set_help_filename( startup_path );
    *p = 0;
    install_context_handler( context_handler );
    cmd_handler( cmdhandler );
    _lsize( TTOOLS_ENTRY_SIZE ); ot_tools = NEW( Tlb_list );
    construct_log();
    log->set_state( isHIDDEN, 1 );
#ifndef NOPARAM
    proceed_command_line();
#endif
    init_main_menu();
    global_key( cmCONDENSE,        kESC        );
    global_key( cmFILE_OPEN_CURS,  kCTRL_ENTER );
    global_key( cmWINDOW_LIST,     kCTRL_ESC   );
    global_key( cmWINDOW_LIST,     kALT_0      );
    global_key( cmHELP_PREVIOUS,   kALT_F1     );
    global_key( cmWIN_DOS_SCREEN,  kF4         );
    global_key( cmWINDOW_NEXT,     kF6         );
    global_key( cmWINDOW_PREVIOUS, kCTRL_F6    );
    global_key( cmWINDOW_NEXT,     kCTRL_TAB   );
    global_key( cmWIN_PROJECT,     kCTRL_P     );
    global_key( cmWIN_LOG,         kCTRL_G     );
    global_key( cmeGOTO_LINE,      kCTRL_J     );
    global_key( cmSAVE_ALL,        kCTRL_F2    );
    filter_str = "C++ files (*.cpp)|C files (*.c)|Header files (*.h)|Assembler files (*.asm)";
  }


void main( int argc, char *argv[] )
{
  char drive[_MAX_DRIVE];
  char dir[_MAX_DIR];
  printf( "\n" );
  _splitpath( argv[0], drive, dir, NULL, NULL );
  strcpy( startup_path, drive );
  strcat( startup_path, dir );
  init_startup( argc, argv ); //prepare command line & read ini file
  init_system(); //init system & dos interface
  init_drivers(); //hook keyboard & mouse ISRs
  init_dc(); //init screen dc support
  init_application(); //create application object
  init_editors(); //create clipboard, init editors
  __init_tetris();
  init_w(); //init POWER VIEW IDE
  tini_startup(); //free ini file & command line, show startup errors
  save_dos_screen(); atexit( restore_dos_screen );
  init_screen(); //set startup video mode
  __init_tables(); //init tables manager
#ifndef NOMOUSE
  show_mouse(); //show mouse pointer
#endif
  editors_supervisor = w_editors_supervisor;
  if( editor_options.flags&efSAVE_STATUS ) restore_status();
  init_options();
  for( Tcmd_file *n,*f=cmd_files; f!=NULL; n=f->next,DELETE(f),f=n )
  {
    char buf[_MAX_PATH];
    if( w_edit_file(strcpy(buf,f->filename))==NULL ) exit(1);
  }
  application->exec(); //start POWER VIEW IDE
  if( options_changed )
  {
    _iwarning();
    if( yn( "Options has been changed but not saved.\n\nDo you wish to save options?" ) )
      options_save();
  }
  if( editor_options.flags&efSAVE_STATUS ) save_status();
}
