/*
 *  BOX.CPP - the function is a part of User library.
 *  Copyleft (l) Stanislav Sokolov, June 1998 and onwards
 *
 *  This library is subject to GNU General Library Public License ver. 2 of
 *  June 1991 and any later version. See COPYING.LIB for details.
 *
 *  You may freely use this function, provided due credits are given.
 *
 *  Contact the author by e-mail: stanislavs@hotmail.com
 *
 *  Internet:  http://members.tripod.com/~stanislavs/prog/prog.htm
 */

#include <conio.h>
#include <dos.h>
#include <string.h>

#include "d:\tc\utils\user\user.h"

Box::Box(void){
	IsDrawn = 0;
	SetColor(LIGHTGRAY, BLACK);
	SetParams();
}

Box::~Box(void){
	if(IsDrawn) Erase();
}


int Box::Erase(void){
	if(!IsDrawn) return 0; //A not-drawn box can't be erased!

	if(SaveBackGr){
		puttext(Left, Top, Left + absWidth, Top + absHeight, Buffer);
		delete [] Buffer;
	}

	IsDrawn = 0;

	return 1;
}

void Box::SetColor(int BFColor, int BBColor, int SFColor, int SBColor){
	if(IsDrawn) return; //Parameters can't be changed for a drawn box - erase it first!

	Box::BFColor = BFColor;
	Box::BBColor = BBColor;
	Box::SFColor = SFColor;
	Box::SBColor = SBColor;
}

void Box::SetParams(const char* Title, int Style, int Zoom, int Shadow){
	if(IsDrawn) return; //Parameters can't be changed for a drawn box - erase it first!

	Box::Style = Style;
	Box::Zoom = Zoom;
	Box::Shadow = Shadow;
	Box::Title = Title;
}

int Box::Draw(int Top, int Left, int Height, int Width, int SaveBackGr = 1, char AltBorder = ' '){
	char HT, HB, V, DR, DL, UR, UL;
	int Z, i, TTop, TLeft, THeight, TWidth;
	register unsigned char Row = 0, Col;
	char Page, Cols, Rows, ColorAttr;

	if(IsDrawn) return 0; //Only one box per object can be drawn

	Box::Top = Top;
	Box::Left = Left;

	HT = HB = V = DR = DL = UR = UL = AltBorder;

	asm{
		mov AH, 0x0F
		int 0x10
		mov Cols, AH
		mov Page, BH
	}

	do{
		Row++;
		gotoxy(1, Row);
	}while ((wherey() == Row) && (Row <= 200));
	Rows = Row - 1;

	//Can a box be drawn inside screen boundaries?
	if(Width + Left > Cols) return 0;
	if(Height + Top > Rows) return 0;

	//Save the Screen
	Box::SaveBackGr = SaveBackGr;
	if(SaveBackGr){
		//Get absolute height and absulote width (include shadow) of the box - used in saving and restoring background.
		if(Width + Left <= Cols - 2)
			absWidth = Width + 2;
		else if(Width + Left <= Cols - 1)
			absWidth = Width + 1;
		else
		absWidth = Width;

		if(Height + Top <= Rows - 1)
			absHeight = Height + 1;
		else
			absHeight = Height;

		Buffer = new char[absWidth * absHeight * 2];
		gettext(Left, Top, Left + absWidth, Top + absHeight, Buffer);
	}

	_setcursortype(_NOCURSOR);

	if(Style == B_SINGLE){
		HT = '';
		HB = '';
		V = '';
		DR = '';
		DL = '';
		UR = '';
		UL = '';
	}if(Style == B_DOUBLE){
		HT = '';
		HB = '';
		V = '';
		DR = '';
		DL = '';
		UR = '';
		UL = '';
	}else if(Style == B_THICK){
		HT = '';
		HB = '';
		V = '';
		DR = '';
		DL = '';
		UR = '';
		UL = '';
	}else if(Style == B_ALT){
		HT = '-';
		HB = '_';
		V = '|';
		DR = '\\';
		DL = '/';
		UR = '/';
		UL = '\\';
	}

	textcolor(BFColor);
	textbackground(BBColor);

	//Perform zoom
	if(Zoom != B_NONE){
		if(Zoom == B_INVERSE)
			Z = Height;
		else //B_NORMAL or any other
			Z = Height / 2 - 1;

		for(i = Z; i >= 2; i--){
			TTop = Top + i;
			TLeft = Left + i;
			TWidth = Width - i * 2;
			THeight = Height - i * 2;

			gotoxy(TLeft, TTop);
			putch(UR);
			for(Col = 0; Col <= TWidth; Col++) putch(HT);
			putch(UL);

			for(Row = (TTop + 1); Row <= (TTop + THeight - 1); Row++){
				gotoxy(TLeft, Row);
				putch(V);
				for(Col = 0; Col <= TWidth; Col++) putch(' ');
				putch(V);
			}

			gotoxy(TLeft, TTop + THeight);
			putch(DR);
			for(Col = 0; Col <= TWidth; Col++) putch(HB);
			putch(DL);

			delay(40);
		}
	}

	//Write left and write border
	for(Row = (Top + 1); Row <= (Top + Height - 1); Row++){
		gotoxy(Left, Row);
		putch(V);
		for(Col = 0; Col <= (Width - 2); Col++) putch(' ');
		putch(V);
	}

	//Write top line
	gotoxy(Left, Top);
	putch(UR);
	for(Col = 0; Col <= (Width - 2); Col++) putch(HT);
	putch(UL);

	//Write bottom line
	gotoxy(Left, Top + Height);
	putch(DR);
	for(Col = 0; Col <= (Width - 2); Col++) putch(HB);
	//putch(DL);

	Row = Top + Height - 1;
	Col = Left + Width - 1;
	ColorAttr = (BBColor << 4) | BFColor;
	asm{
		mov AH, 0x02
		mov BH, Page
		mov DH, Row
		mov DL, Col
		int 0x10
		mov AH, 0x09
	}
	_AL = DL;
	asm{
		mov CX, 1
		mov BL, ColorAttr
		mov BH, Page
		int 0x10
	}

	//Write title
	if((Title != NULL) && (strlen(Title) < (Width - 3))){
		gotoxy((Left + ((Width - strlen(Title)) / 2) - 1), Top);
		cprintf(" %s ", Title);
	}

	//Set shadow
	if(Shadow != B_NONE){
		textcolor(SFColor);
		textbackground(SBColor);

		//Right shadow
		ColorAttr = (SBColor << 4) | SFColor;
		for(Row = Top; Row <= (Top + Height); Row++){
			Col = Left + Width;
			if(Shadow == B_TRANSP){
				for(i = 0; i <= 1; i++){
					Col += (char)i;
					if(Col >= Cols) break;
					asm{
						mov AH, 0x02
						mov BH, Page
						mov DH, Row
						mov DL, Col
						int 0x10       //Set cursor
						mov AH, 0x08
						mov BH, Page
						int 0x10       //Read char
						mov AH, 0x09
						mov BH, Page
						mov CX, 1
						mov BL, ColorAttr
						int 0x10       //Set attr for the char
					}
				}
			}else if(Shadow == B_NORMAL){
				for(i = 0; i <= 1; i++){
					Col += (char)i;
					gotoxy(Col + 1, Row + 1);
					if((Col >= Cols) || (wherey() != Row + 1)) break;
					putch('');
				}
			}
		}

		//Bottom shadow
		if(Shadow == B_TRANSP){
			Row = Top + Height;
			for(Col = Left + 1; Col <= Left + Width + 1; Col++){
				if(Col >= Cols) break;
				asm{
					mov AH, 0x02
					mov BH, Page
					mov DH, Row
					mov DL, Col
					int 0x10       //Set cursor
					mov AH, 0x08
					mov BH, Page
					int 0x10       //Read char
					mov AH, 0x09
					mov BH, Page
					mov CX, 1
					mov BL, ColorAttr
					int 0x10       //Set attr for the char
				}
			}
		}else if(Shadow == B_NORMAL){
			gotoxy(Left + 2, Top + Height + 1);
			if(wherey() == Row + 1)
				for(Col = 0; (Col <= Width - 2) && (Col < Cols); Col++)
					putch('');
		}
	}

	textcolor(BFColor);
	textbackground(BBColor);

	IsDrawn = 1;
	return IsDrawn;
}


/*int main(void){

	textcolor(LIGHTGRAY);
	textbackground(BLACK);

	char far *video = (char far *)MK_FP(0xB800, 0x0000);
	for(int i=0; i<50; i++){            // draw the text screen background
		for(int j=0; j<80; j++){
			*video++ = 0xDB+2*(j/10);       // write the character to video memory
			*video++ = 16*(j/10)+j/10+1;    // write the color
		}
	}

	Box aBox;

	aBox.SetColor(RED, GREEN);
	aBox.SetParams("This is a test", B_DOUBLE, B_INVERSE, B_TRANSP);

	aBox.Draw(5, 10, 15, 60);

	gotoxy(12, 12);
	cprintf("aBox.Drawn() returned %i", aBox.Drawn());
	gotoxy(12, 14);
	cprintf("Press any key to continue...\r\n");

	while(!kbhit());
	getch();

	aBox.Erase();

	gotoxy(1, 1);
	cprintf("The box has been erased.\r\naBox.Drawn() now returned %i", aBox.Drawn());

	return 0;
}*/
