include ppp.asi

CGROUP group TSR,CONFIG
	assume cs:cgroup,ds:cgroup
	extrn lcp_init : proc, ipcp_init : PROC
	extrn	starttime : PROC, elapsedtime : PROC, printtext : PROC
	extrn dialer : PROC, authenticated : byte
	extrn sm_timed : PROC, pap_retry : PROC
	extrn LCP_struc : byte, IPCP_struc : byte, nocts : byte
	extrn curtime : word, starttime : PROC, elapsedtime : PROC
	extrn numservers : byte, baseservers : byte
	extrn ctrlbrk : byte 
	extrn authcount : byte
	public cantext, connect, interfaceup, chkkey, keypressed, condtext
TSR segment word public 'CODE'
cantext	db	0		; set to zero so we get opening messages
				; or one to suppress them
				; MUST be NZ after residency
				; since the messages are non-resident
;spinchar db	0
;spinlist db	'|','/','-','\'

interfaceup PROC
	cmp	[LCP_struc].sm_state,ST_OPENED
	jnz	notinstalled
	cmp	[IPCP_struc].sm_state,ST_OPENED
	jz	installed
notinstalled:
	stc
installed:
	ret
interfaceup ENDP
chkkey PROC
	test	[cantext],0ffh ; see if at beginning of program
	jnz	chkkeyx
	test	[ctrlbrk],1	; if is ctrl-break
	jnz	isescape
	mov	ah,1		; see if any key press
	int	16h
	clc			; assume not
	jz	chkkeyx		; get out if not
	sub	ah,ah		; get the key
	int	16h		;
	cmp	al,01bh		; is it ESC?
	clc			; assume not
	jnz	chkkeyx		; right, get out
isescape:
	mov	[ctrlbrk],0	; clear it
	stc			; else was escape, tell them

chkkeyx:
	ret
chkkey ENDP
connect PROC	
	mov	dx,offset cgroup:connecting
	call	condtext
restart:
lp:
	cmp	[LCP_struc].sm_state,ST_OPENED
	jz	connectok
	cmp	[LCP_struc].sm_state,ST_STOPPED
	jz	notup
	cmp	[LCP_struc].sm_state,ST_CLOSED
	jz	notup
	test	[authenticated],AU_UNKNOWN
	jnz	badauth
	call	chkkey
	jnc	lp
	jmp	keypressed
badauth:
	mov	dx,offset cgroup:authdenied
	call	condtext
	mov	[cantext],1
	stc
	ret
connectok:
	test	[authenticated],AU_AUTH
	jnz	ipu
	mov	dx,offset cgroup:authen
	call	condtext
alp:
	test	[authenticated],AU_AUTH
	jnz	ipu
	test	[authenticated],AU_BADPASS
	jnz	authbad
	test	[authcount],0ffh
	jz	notup
	cmp	[LCP_struc].sm_state,ST_OPENED
	jnz	restart
	call	chkkey
	jc	keypressed
	jnc	alp
notup:
	mov	dx,offset cgroup:cantopen
	call	condtext
	mov	[cantext],1
	stc
	ret
authbad:
	mov	dx,offset cgroup:sbadpass
	call	condtext
	mov	[cantext],1
	stc
	ret
keypressed:
	mov	dx,offset cgroup:skeypressed
	call	condtext
	mov	[cantext],1
	stc
	ret
ipu:
	mov	dx,offset cgroup:ipcpconnecting
	call	condtext
blp:

	call	interfaceup
	jnc	ready
	cmp	[LCP_struc].sm_state,ST_STOPPED
	jz	notup
	cmp	[LCP_struc].sm_state,ST_CLOSED
	jz	notup
	call	chkkey
	jnc	blp
	jmp	keypressed
ready:
;	call	starttime		; save start time
;	mov	dx,6*18
wln:
;	push	dx
;	call	elapsedtime	; check elapsed time
;	pop	dx
;	sub	dx,ax
;	jg	wln		; continue till done
	mov	dx,offset cgroup:sready
	call	condtext
	mov	[cantext],1
	clc
	ret
connect ENDP
condtext PROC
	test	[cantext],-1
	jnz	notext
	call	printtext
notext:
	ret
condtext ENDP
TSR	ENDS
CONFIG	segment word public 'CODE'
cantopen db	13,10,"LCP: Can't establish connection",13,10,'$'
connecting db	"Connecting to network...$"
authen	db	"Authenticating...$"
ipcpconnecting db	"Negotiating IP linkage...$"
sready	db	13,10,"Connection open",13,10,'$'
sbadpass db	"Invalid password",13,10,'$'
skeypressed db	13,10,"ESC pressed, aborting",10,13,'$'
authdenied db	13,10,"Unrecognized authentication protocol",10,13,'$'
CONFIG	ENDS
	end