CGROUP group TSR,CONFIG
	assume cs:cgroup,ds:cgroup

	public loginit, logsend, logrecv, tolog, logrundown, writeconfig
	public netmask, formbyte2
	extrn xmitbuf : byte, peermru : word
	extrn ipaddr : dword, hisipaddr: dword, dns1: dword, dns2: dword
	extrn gettime : PROC

TSR segment word public 'CODE'
theirpsp dw	0
netmask dw	0,0
tolog	db	0
handle	dw	0
starttime dw 	0
filename db	"lsppp.log",0
obuf	db	3,"   "
crlf	db	2,13,10
send	db	6,"send: "
rcv	db	6," rcv: "
timebuf db	6," 000  "

getpsp PROC
	mov	ah,51h
	int	21h
	mov	[theirpsp],bx
	mov	ah,50h
	mov	bx,cs
	sub	bx,10h
	int	21h
	ret
getpsp endp
setpsp PROC
	mov	ah,50h
	mov	bx,[theirpsp]
	int	21h
	ret
setpsp ENDP
;
; start logging
;
loginit	proc
	test	[tolog],1		; get out if no log file
	jz	li_none
	call	gettime
	mov	[starttime],ax
	mov	ax,3c00h		; open file
	sub	cx,cx
	mov	dx,offset cgroup:filename
	int	21h
	mov	[handle],ax		; save handle
	jnc	li_none			; get out if all ok
	mov	[tolog],0		; else cancel logging
	mov	[handle],0
li_none:	
	ret
loginit	endp
;
; end logging
;
logrundown PROC
	test	[tolog],1		; get out if no log file
	jz	lrd_ni
	call	getpsp
	mov	ax,3e00h		; close file
	mov	bx,[handle]
	int	21h
	mov	[handle],0		; kill handle
	mov	[tolog],0		; and logging
	call	setpsp
lrd_ni:
	ret
logrundown ENDP
;
; write something to log file
;
write PROC
	mov	bx,dx			; get length byte
	mov	cl,[bx]
	inc	dx			; point to data
	sub	ch,ch
	mov	bx,[handle]		; get handle
	mov	ax,4000h		; do write
	int	21h
	ret
write ENDP
;
; write a CR/LF pair out
;
writecrlf PROC
	mov	dx,offset cgroup:crlf
	jmp	write
writecrlf ENDP
;
; format a byte for writing , standard to-hex converter
;
formbyte PROC
	mov  di,offset cgroup:obuf+1	; get output buf
formbyte2:
	push ax				; save char
	shr  al,4			; get high nib
	call outnib			; out it
        pop ax				; get low nib
outnib:
	and al,0fh			; isolate nibble
	cmp al,10			; >= 10?
	jc  no7				; no, it is a number
 	add al,7			; else adjust for letter
no7:
	add al,30h			; make ascii
	stosb				; save it
	ret
formbyte	endp
;
; format and write a byte to disk
;
writebyte PROC
	call	formbyte		; format it
	mov	dx,offset cgroup:obuf	
	call	write
	ret
writebyte ENDP
;
; send a buffer out
;
ripout  PROC
	lodsb				; get char
	push	si
	push	cx
	call 	writebyte		; write it
	pop	cx
	pop	si
	loop	ripout			; loop till done
	ret
ripout  ENDP
;
; put a timestamp in the buffer
;
timestamp PROC
	call	gettime
	sub	ax,[starttime]
	mov	di,offset cgroup:timebuf + 4
	mov	bx,10
	mov	cx,3
tsl:
	sub	dx,dx
	div	bx
	add	dl,'0'
	mov	[di],dl
	dec	di
	loop	tsl
	mov	dx,offset cgroup:timebuf
	jmp	write
timestamp ENDP
;
; write the send buffer
;
logsend	proc
	test	[handle],0ffffh		; get out if no log file
	jz	lsni
	push	ax			; push all regs
	push	bx
	push	cx
	push	dx
	push	si
	push	di

	push	ax			; write banner
	call	getpsp
	mov	dx,offset cgroup:send
	call	write
	call	timestamp
	pop	ax

	mov	cx,ax			; get count
	sub	cx,2			; rid FCS
	mov	si,offset cgroup:xmitbuf ; go dump it
	cmp	word ptr [si],03ffh
	jnz	lsg
	add	si,2
	sub	cx,2
lsg:
	call	ripout
	call	writecrlf
	call	setpsp

	pop	di			; restore regs
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
lsni:
	ret
logsend	endp
;
; write the receive buffer;
;
logrecv proc
	test	[handle],0ffffh		; get out if no log file
	jz	lrni
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di

	push	cx			; write banner
	push	si
	push	ax
	call	getpsp
	mov	dx,offset cgroup:rcv
	call	write
	call	timestamp
	pop	ax

	push	ax			; put out protocol
	xchg	al,ah
	call	writebyte
	pop	ax
	or	al,al
	jz	nosecond
	call	writebyte
nosecond:
	pop	si
	pop	cx
	call	ripout			; rip out the rest of the buf
	call	writecrlf
	call	setpsp

	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
lrni:
	ret
logrecv endp
TSR	ENDS
CONFIG segment word public 'CODE'
ipfile	db	"ip-up.bat",0
sset	db	4,"set "
smyip	db	5,"myip="
sremip	db	6,"remip="
snetmask db	8,"netmask="
speermru db	8,"peermru="
sdns1	db	5,"dns1="
sdns2	db	5,"dns2="
sipaddr   db	15,"   .   .   .   "
sipcaddr db	16 dup (0)
speern	db	4,"    "


ihandle dw 0
;
; generic write
;
iwrite proc
	mov	bx,dx			; point to data
	mov	cl,[bx]			; get len
	inc	dx			; point past len
	sub	ch,ch			;
	mov	bx,[ihandle]		; get handle
	mov	ax,4000h		; write
	int	21h
	ret
iwrite endp
icrlf PROC
	mov	dx,offset cgroup:crlf
	jmp	iwrite
icrlf ENDP
wset	PROC
	mov	dx,offset cgroup:sset
	jmp	iwrite
wset	ENDP
;
; write a number out
;
writenum proc
	mov	di,dx
	add	di,cx
	dec	di
	push	dx
	std
wnl:
	push	cx
	sub	dx,dx
	mov	cx,10
	div	cx
	add	dl,'0'
	xchg	al,dl
	stosb
	xchg	al,dl
	pop	cx
	or	ax,ax
	jz	dnx
	loop	wnl
	cld
	pop	dx
	ret
dnl:
	mov	al,' '
	stosb
dnx:
	loop	dnl
	cld
	pop	dx
	ret
writenum endp
compressip proc
	mov	cx,15
	mov	si,offset cgroup:sipaddr+1
	mov	di,offset cgroup:sipcaddr+1
cil:
	lodsb
	cmp	al,' '
	jz	cilk
	stosb
cilk:
	loop	cil
	sub	di,offset cgroup:sipcaddr+1
	mov	cx,di
	mov	[sipcaddr],cl
	ret
compressip endp
;
; write an ip address
;
writeip proc
	push	bx
	push	ax
	mov	dx,offset cgroup:sipaddr+1
	mov	cx,3
	sub	ah,ah
	call	writenum
	pop	ax
	xchg	al,ah
	mov	dx,offset cgroup:sipaddr+5
	mov	cx,3
	sub	ah,ah
	call	writenum
	pop	ax
	push	ax
	mov	dx,offset cgroup:sipaddr+9
	mov	cx,3
	sub	ah,ah
	call	writenum
	pop	ax
	xchg	al,ah
	mov	dx,offset cgroup:sipaddr+13
	mov	cx,3
	sub	ah,ah
	call	writenum
	call	compressip
	mov	dx,offset cgroup:sipcaddr
	call	iwrite
	ret
writeip	endp
;
; get the net mask
;
getnetmask proc
	mov	ax,word ptr [ipaddr]
	mov	dx,word ptr [ipaddr+2]
	xor	ax,word ptr [hisipaddr]
	xor	dx,word ptr [hisipaddr+2]
	mov	[netmask],ax
	mov	[netmask+2],dx
	mov	ax,0080h
	mov	dx,0
nml:
	test	ax,[netmask]
	jnz	nmg
	test	dx,[netmask+2]
	jnz	nmg
	shr	al,1
	rcr	ah,1
	rcr	dl,1
	rcr	dh,1
	jnc	nml
	sub	ax,ax
	sub	bx,bx
	pop	bp
	ret
nmg:
	or	[netmask],ax
	or	[netmask+2],dx
	shr	al,1
	rcr	ah,1
	rcr	dl,1
	rcr	dh,1
	jnc	nmg
	not	[netmask]
	not	[netmask+2]
	mov	ax,[netmask]
	mov	bx,[netmask+2]
	ret
getnetmask endp
;                  
; write the configuration file
;
noconfig:
	ret
writeconfig proc
	mov	ax,3c00h		; open file
	sub	cx,cx
	mov	dx,offset cgroup:ipfile
	int	21h
	jc	noconfig		; err if can't open, just exit
	mov	[ihandle],ax		; save handle
	call	wset
	mov	dx,offset cgroup:smyip
	call	iwrite
	mov	ax,word ptr [ipaddr]
	mov	bx,word ptr [ipaddr + 2]
	call	writeip
	call	icrlf
	call	wset
	mov	dx,offset cgroup:sremip
	call	iwrite
	mov	ax,word ptr [hisipaddr]
	mov	bx,word ptr [hisipaddr + 2]
	call	writeip
	call	icrlf
	call	wset
	mov	dx,offset cgroup:snetmask
	call	iwrite
	call	getnetmask
	call	writeip
	call	icrlf
	call	wset
	mov	dx,offset cgroup:speermru
	call	iwrite
	mov	ax,[peermru]
	mov	cx,4
	mov	dx,offset cgroup:speern+1
	call	writenum
	dec	dx
	call	iwrite
	call	icrlf
	mov	ax,word ptr [dns1]
	or	ax,word ptr [dns1 + 2]
	jz	nodns
	call	wset
	mov	dx,offset cgroup:sdns1
	call	iwrite
	mov	ax,word ptr [dns1]
	mov	bx,word ptr [dns1 + 2]
	call	writeip
	call	icrlf
	mov	ax,word ptr [dns2]
	or	ax,word ptr [dns2 + 2]
	jz	nodns
	call	wset
	mov	dx,offset cgroup:sdns2
	call	iwrite
	mov	ax,word ptr [dns2]
	mov	bx,word ptr [dns2 + 2]
	call	writeip
	call	icrlf
nodns:
	mov	ax,3e00h		; close file
	mov	bx,[ihandle]
	int	21h
	ret
	
writeconfig endp
CONFIG	ENDS
	end