/*--------------------------------------------------------------------------
 * File : glob.h
 *
 * $Id: glob.h,v 1.11 2000/01/17 18:08:05 mike Exp $
 *------------------------------------------------------------------------*/

#ifndef _GLOB_H_DEFINED
#define _GLOB_H_DEFINED

/*
 *      Global Variables for FPLOT
 */

#ifndef FPLOT_MAIN_MODULE
extern                     /* declare as extern's for 'non-main' files */
#endif
char    (*g_fields)[CPF],          /* output of parse_line_into_fields */
	**g_label_array,           /* array of strings for each label  */
	*g_input_string,           /* input buffer for reading files   */
	*g_xlabel,                 /* X Label     (bottom of plot)     */
	*g_y1label,                /* Y1 Label    (left side of plot)  */
	*g_y2label,                /* Y2 Label    (right side of plot) */
	*g_title,                  /* Title Label (top of plot)        */
	*g_big_buffer,             /* larger read buffer for file I/O  */
	*g_plot_file,              /* plot file name                   */
	*g_output_file,            /* output file name                 */
	*g_tmp_file,               /* temp file name                   */
	*g_tmp_file2,              /* temp file name                   */
	*g_tmp_file3;              /* temp file name                   */

#ifndef FPLOT_MAIN_MODULE
extern                     /* declare as extern's for 'non-main' files */
#endif
int 	*g_label_coord,            /* bit-mapped coordinate for labels */
        g_raw_mode,                /* BOOL, F=command file, T=raw mode */
	g_usesamples,              /* BOOL                             */
	g_xrange_auto,             /* BOOL, autoscale the x-axis       */
	g_y1range_auto,            /* BOOL, autoscale the y1-axis      */
	g_y2range_auto,            /* BOOL, autoscale the y2-axis      */
	g_force_y2_y1,             /* BOOL, force Y2 range same as Y1  */
	g_gridlines,               /* on, off, or tick                 */
	g_xaxis_scale,             /* linear, log, ...                 */
	g_outputformat,
	g_x_divisions,             /* # divisions on x axis            */
	g_y1_divisions,            /* # divisions on y1 axis           */
	g_y2_divisions,            /* # divisions on y2 axis           */
	g_field_def_x,             /* which field is the X data in     */
	g_field_def_y1,            /* which field is the Y1 data in    */
	g_field_def_y2,            /* which field is the Y2 data in    */
	g_field_def_y3,            /* ...                              */
	g_field_def_y4,            /* ...                              */
	g_field_def_y5,            /* ...                              */
	g_field_def_y6,            /* ...                              */
	g_field_def_y7,            /* ...                              */
	g_field_def_y8,            /* ...                              */
	g_field_def_y9,            /* ...                              */
	g_field_def_y10,           /* ...                              */
	g_field_def_y11,           /* ...                              */
	g_field_def_y12,           /* ...                              */
	g_num_y_ranges,            /* how many Y ranges are we plotting*/
	g_graph_type;              /* which kind of graph to draw      */

#ifndef FPLOT_MAIN_MODULE
extern                     /* declare as extern's for 'non-main' files */
#endif
long    g_skip_factor,             /* skip N data points               */
	g_num_samples_to_plot,
	g_usesamples_low,
	g_usesamples_high;

#ifndef FPLOT_MAIN_MODULE
extern                     /* declare as extern's for 'non-main' files */
#endif
double  *g_label_x,                /* x coordinate of each label       */
	*g_label_y,                /* y coordinate of each label       */
	*g_label_rotate,           /* rotation angle of each label     */
	*g_label_fontsize,         /* fontsize of each label           */
	g_graph_x_min,             /* graph x min coord                */
	g_graph_x_max,             /* graph x max coord                */
	g_graph_y1_min,            /* graph y1 min coord               */
	g_graph_y1_max,            /* graph y1 max coord               */
	g_graph_y2_min,            /* graph y2 min coord               */
	g_graph_y2_max,            /* graph y2 max coord               */
	g_border_left,             /* graph borders, default to 1.0    */
	g_border_top,              /* ...                              */
	g_border_right,            /* ...                              */
	g_border_bottom,           /* ...                              */
	g_true_x_min,              /* need to keep the true min/max    */
	g_true_x_max,              /*   for autoranging in LOG mode    */
	g_point_size_scale,        /* scaling factor for 'points'      */
	g_papersize_length,        /* nominally 11.0 inches            */
	g_papersize_width,         /* nominally 8.5 inches             */

	g_fontsize_title,          /* font size for each label         */
	g_fontsize_xlabel,
	g_fontsize_y1label,
	g_fontsize_y2label,

	g_xrange_low,              /* X axis low limit                 */
	g_xrange_high,             /* X axis high limit                */
	g_y1range_low,             /* Y1 axis low limit                */
	g_y1range_high,            /* Y1 axis high limit               */
	g_y2range_low,             /* Y2 axis low limit                */
	g_y2range_high,            /* Y2 axis high limit               */

	g_xmultiplier,             /* X axis multiplier                */
	g_y1multiplier,            /* Y1 axis multiplier               */
	g_y2multiplier,            /* Y2 axis multiplier               */

	g_xoffset,                 /* X axis offset                    */
	g_y1offset,                /* Y1 axis offset                   */
	g_y2offset;                /* Y2 axis offset                   */

#ifndef FPLOT_MAIN_MODULE
extern                     /* declare as extern's for 'non-main' files */
#endif
FILE    *g_tmp_ptr,                /* temp file pointer                */
	*g_tmp_ptr2,               /* temp file pointer                */
	*g_tmp_ptr3;               /* temp file pointer                */

#endif  /* _GLOB_H_DEFINED */
/*------------------------------------------------------------------------*/
