Program Bin_test;
{$E+}  { Turn 80x87 emulation on }

{This program tests the ability of the plotting program to handle
 binary data files.}

Var
  Data_file:    File of single;
  I:            Integer;
  J:            Integer;
  No_of_lines:  single;
  No_of_points: single;
  Data:         single;
  Negative_one: single;
  Zero:         single;
  Header1:      String[50];
  Header2:      String[50];
  singleOrd:    single;

Begin
  Negative_one := -1.0;
  Zero := 0.0;
  Header1 := 'Binary data file: example data';
  Header2 := 'This label is included in the data file';
  No_of_lines := 2.0;
  No_of_points := 5.0;
  Assign(Data_file, 'Bin_test.dat');
  Rewrite(Data_file);

  {This section shows the method by which a label may be placed in a binary
   data file.  It could be omitted entirely and the program would still work.}
  Write(Data_file, negative_one);    {indicates a label is in the file}
  For I:=1 to Length(Header1) do     {Write header 1}
  Begin
    singleOrd := Ord(Header1[I]);      {Find a single number which is the}
    Write(Data_file, singleOrd);       {  ascii value for the character}
  End;
  Write(Data_file, Zero);            {Indicates the end of header1}
  For I:=1 to Length(Header2) do     {Write header 2}
  Begin
    singleOrd := Ord(Header2[I]);      {Find a single number which is the}
    Write(Data_file, singleOrd);       {  ascii value for the character}
  End;
  Write(Data_file, Zero);            {Indicates the end of header2}

  Write(Data_file, No_of_lines);
  Write(Data_file, No_of_points);
  For I:=1 to Round(No_of_lines) do
    For J:=1 to Round(No_of_points) do
    Begin
      Data := 1.0 * I / J;
      Write(Data_file, Data);
    End;
  Close(Data_file);
End.