10 REM  PROGRAM CURVEGEN GENERATES VALUES OF A 3D CURVE.
20 REM  THE PROGRAM WRITES THE VALUES ALONG WITH PLOT COMMANDS TO A FILE
30 REM  NAMED CURVDATA.PLT; THE VALUES ARE THEN PLOTTED BY USING THE SHELL
40 REM  COMMAND TO RUN THE SPLOT PROGRAM.
50 REM
60 REM  COPYRIGHT 1988, 1989 BY WILLIAM G. HOOD
70 REM
80 REM  WARNING: DO NOT RENUMBER!
90 REM
100 CLS: KEY OFF
110 PRINT"This program plots a curve in three dimensions.  The curve is"
120 PRINT"defined parametrically by a subroutine which must follow the"
130 PRINT"main program.  The subroutine must set variables X, Y and Z"
140 PRINT"equal to functions of the parameter T."
150 PRINT
160 INPUT"Do you want to see current equations (N/Y)"; A$: A$=LEFT$(A$,1)
170 IF A$="Y" OR A$="y" THEN CLS: LIST 1000-1999: END
180 REM
190 OPEN "CURVDATA.PLT" FOR OUTPUT AS #2
200 PRINT: LINE INPUT"Title? "; TITLE$: PRINT#2,"TITLE "+TITLE$
205 PRINT: LINE INPUT"Z-Axis Label? "; LZ$: PRINT#2,"ZLABEL "+LZ$
210 LINE INPUT"X-Axis Label? ";LX$: PRINT#2,"XLABEL "+LX$
220 LINE INPUT"Y-Axis Label? ";LY$: PRINT#2,"YLABEL "+LY$
222 PRINT: INPUT"Log Z-Axis (N/Y)"; A$: A$=LEFT$(A$,1)
224 IF A$="Y" OR A$="y" THEN PRINT#2,"LOGZ"
230 INPUT"Log X-Axis (N/Y)"; A$: A$=LEFT$(A$,1)
240 IF A$="Y" OR A$="y" THEN PRINT#2,"LOGX"
250 INPUT"Log Y-Axis (N/Y)"; A$: A$=LEFT$(A$,1)
260 IF A$="Y" OR A$="y" THEN PRINT#2,"LOGY"
290 REM
350  PRINT
360  PRINT"Enter initial value, final value & step size of parameter ";
372  PRINT"separated by spaces"
390  INPUT V$: IF V$="" GOTO 470
400   GOTO 420
410    INPUT"Initial Value, Final Value, Step Size"; V$: IF V$="" GOTO 470
420   P=1: GOSUB 680: TI. = V: GOSUB 680: TF. = V: GOSUB 680: TS. = V
430   IF TS. <= 0 THEN PRINT"ERROR: INVALID STEP SIZE": GOTO 410
440   ND. = INT( (TF.-TI.)/TS. + 1.5 )
450   IF ND. < 2 THEN PRINT"ERROR: INVALID RANGE": GOTO 410
460   IF ND. > 1024 THEN PRINT"ERROR: TOO MANY POINTS - MAX IS 1024": GOTO 410
470  PRINT:PRINT"Calculating..."
480  PRINT#2,"READXYZ ";ND.
490  FOR I.=1 TO ND.
500   T = TI. + (I.-1)*TS.
510   GOSUB 1100
520   PRINT#2, X;" ";Y;" ";Z
530  NEXT I.
540 PRINT#2,"PLOT3D CURVE": PRINT#2,"KEYBOARD"
550 CLOSE#2
560 REM
570 PRINT:PRINT"Press the ENTER key to display the plot";
580 PRINT" - press the ESC key to clear the plot."
590 A$=INKEY$: IF A$<>"" GOTO 590
600 A$=INKEY$: IF A$="" GOTO 600
610 IF ASC(A$)<>13 GOTO 600
620 SHELL( "SPLOT CURVDATA.PLT" )
630 END
670 REM EXTRACTS V FROM V$ STARTING AT POSITION P
680 P2=LEN(V$)
690 IF MID$(V$,P,1)=" " AND P<=P2 THEN P=P+1: GOTO 690
700 P0=P: IF P0>P2 THEN V=0: RETURN
710 IF MID$(V$,P,1)<>" " AND P<=P2 THEN P=P+1: GOTO 710
720 V = VAL( MID$( V$, P0, P-P0 ) )
730 RETURN
1000 REM
1010 REM NOTE: To avoid conflict with main program variables,
1020 REM       do not use variable names that contain a period.
1030 REM
1100 REM Subroutine must set X=f1(T), Y=f2(T), Z=f3(T) after this line #
1110 X = T * SIN(T): Z = T * COS(T): Y = T
1190 RETURN
