PROCEDURE gotorc; {(R,C : INTEGER);}
BEGIN
    GOTOXY(C,R)      {I prefer Row,Column over Column, Row}
END;


PROCEDURE sak; {'strike any key to continue ...'}
VAR tmp:CHAR;
BEGIN
    GOTORC(25,1); CLREOL; highvideo;
    TextAttr := TextAttr + blink;
    WRITE('Strike any key to continue ...');
    TextAttr := TextAttr - blink;
    REPEAT UNTIL KeyPressed;
    GOTORC(25,1); CLREOL;
    tmp:=READKEY
END;


PROCEDURE alt_inp; {  (VAR alt_str : S14);}
VAR str : S14;
    num,err : INTEGER;
BEGIN
    alt_str := '';
    GOTORC(19,52); lowvideo;
    WRITE('Enter Decimal number ->'); highvideo;
    READLN(str);
    WHILE (str <> '') AND (LENGTH(alt_str) < 14) DO BEGIN
        VAL(str,num,err);
        GOTORC(24,1);
        IF (err <> 0) OR (num < 1) OR (num > 255) THEN BEGIN
            WRITE('Invalid!'^G); CLREOL
        END ELSE BEGIN
            CLREOL; WRITE('adding char #',num);
            alt_str := alt_str + CHR(num);
            IF sign_type = sign THEN space_needed :=
                space_needed + (ndx_array[num].delta_x * mult_w);
            GOTORC(17,25); CLREOL; highvideo; WRITE(space_needed);
        END;
        GOTORC(19,52); CLREOL; lowvideo;
        WRITE('Enter Decimal number ->'); highvideo;
        READLN(str)
    END; {while something entered}
    GOTORC(24,1); CLREOL;
    GOTORC(19,52); CLREOL
END;


PROCEDURE putchr; {chrs:S14}
VAR i : INTEGER;
BEGIN
{    IF chrs[1] = CHR(26) THEN
        chrs[1] := CHR(ORD(chrs[1]) + 4);       {can't output an ^Z, so ^^}
                                                {uses printer2 fixes this}
    FOR i := 1 TO LENGTH(chrs) DO
        CASE output_device OF
             printr : WRITE(lst,chrs[i]);
          recd_file : WRITE(out_file,chrs[i]);
             screen : WRITE(chrs[i])
        END {case}
    {end for each char in passed string}
END; {subprocedure putchr}


PROCEDURE disp_fs;
BEGIN
    GOTORC(16,41); CLREOL; lowvideo;
    WRITE('Font width: '); highvideo; WRITE(font_width:3); lowvideo;
    WRITE('    Height: '); highvideo; WRITE(font_height:3)
END; {procedure disp_fs}


PROCEDURE init_ff; { (VAR ff,ffi : S14, VAR ok : BOOLEAN);}
LABEL err_exit;
VAR err : INTEGER;
      i : INTEGER;
BEGIN
    ok := TRUE;
    IF ff <> '' THEN BEGIN
        font_fn := ff;
        err := POS('.',font_fn);
        IF err = 0 THEN font_fn := font_fn + '.FNT'
    END;
    ASSIGN(font_file,font_fn);
    {$I-} RESET(font_file); {$I+}
    err := IORESULT;
    IF err <> 0 THEN BEGIN
       font_fn := '????';
       GOTORC(24,1); highvideo;
       WRITELN('ERR:',err,' opening HP Font file, check it!'^G);
       sak;
       ok := FALSE;
       goto err_exit
    END;

    IF ffi <> '' THEN BEGIN
        font_fni := ffi;
        err := POS('.',font_fni);
        IF err = 0 THEN font_fni := font_fni + '.FNX'
    END;
    ASSIGN(font_ndx_file,font_fni);
    {$I-} RESET(font_ndx_file); {$I+}
    err := IORESULT;
    IF err <> 0 THEN BEGIN
       font_fni := '????';
       GOTORC(24,1); highvideo;
       WRITELN('ERR:',err,' opening Font Index file, check it!'^G);
       sak;
       ok := FALSE;
       goto err_exit
    END;

    IF ok THEN BEGIN
        FOR i := 0 to 255 DO READ(font_ndx_file,ndx_array[i]);
        CLOSE(font_ndx_file);
        font_width := ndx_array[0].width;
        font_height := ndx_array[0].height;
        disp_fs;
        ff_open := TRUE
    END;
err_exit:
END; {procedure init_ff}


PROCEDURE set_up_maps (VAR inp_line : S255);
VAR i,j,k : INTEGER;
   ptr8 : PTR_CHAR_MAP_8;
   ptr12 : PTR_CHAR_MAP_12;
   ptr18 : PTR_CHAR_MAP_18;
   ptr24 : PTR_CHAR_MAP_24;
   ptr30 : PTR_CHAR_MAP_30;
     ptr,back : POINTER;
       c : CHAR;
BEGIN
    IF (font_width < 56) and (font_height < 56) THEN map_size := 8
    ELSE IF (font_width < 80) and (font_height < 80) THEN map_size := 12
    ELSE IF (font_width < 104) and (font_height < 104) THEN map_size := 18
    ELSE IF (font_width < 128) and (font_height < 128) THEN map_size := 24
    ELSE IF (font_width < 160) and (font_height < 160) THEN map_size := 30
    ELSE BEGIN
        GOTORC(24,1); WRITE('Font too large for program.');
        sak;
        CLOSE(font_file);
        ff_open := FALSE;
        ask_parm
    END;
    IF (output_device <> screen) OR (input_device = keyboard) THEN BEGIN
        GOTORC(20,8); WRITE('Building maps ->')
    END;
    GOTORC(20,25);
    back := NIL;
    FOR i := 1 TO Length(inp_line) DO BEGIN
        IF (output_device <> screen) OR (input_device = keyboard) THEN WRITE('^');
        CASE map_size OF
         8 : BEGIN
                new(ptr8);
                ptr8^.next := NIL;
                ptr8^.back := back;
                IF ptr8^.back <> NIL THEN ptr8^.back^.next := ptr8;
                ptr := ptr8
             END;
         12: BEGIN
                new(ptr12);
                ptr12^.next := NIL;
                ptr12^.back := back;
                IF ptr12^.back <> NIL THEN ptr12^.back^.next := ptr12;
                ptr := ptr12
             END;
         18: BEGIN
                new(ptr18);
                ptr18^.next := NIL;
                ptr18^.back := back;
                IF ptr18^.back <> NIL THEN ptr18^.back^.next := ptr18;
                ptr := ptr18
             END;
         24: BEGIN
                new(ptr24);
                ptr24^.next := NIL;
                ptr24^.back := back;
                IF ptr24^.back <> NIL THEN ptr24^.back^.next := ptr24;
                ptr := ptr24
             END;
         30: BEGIN
                new(ptr30);
                ptr30^.next := NIL;
                ptr30^.back := back;
                IF ptr30^.back <> NIL THEN ptr30^.back^.next := ptr30;
                ptr := ptr30
             END
        END; {case}
        back := ptr;
        IF i = 1 THEN ptr_maps := ptr;
        SEEK(font_file,ndx_array[ORD(inp_line[i])].position);
        FOR j := 1 TO ndx_array[ORD(inp_line[i])].height DO
             FOR k := 1 TO TRUNC(0.99+ndx_array[ORD(inp_line[i])].width/8) DO BEGIN
                  READ(font_file,c);
                  CASE map_size OF
                      8 :  ptr8^.map[j,k] := ORD(c);
                     12 : ptr12^.map[j,k] := ORD(c);
                     18 : ptr18^.map[j,k] := ORD(c);
                     24 : ptr24^.map[j,k] := ORD(c);
                     30 : ptr30^.map[j,k] := ORD(c)
                  END {case}
             END
        {end}
    END;
    IF (output_device <> screen) OR (input_device = keyboard) THEN BEGIN
        GOTORC(20,1); CLREOL
    END
END;


PROCEDURE reset_maps; { (VAR ptr : POINTER);}
VAR
   ptr8b,ptr8 : PTR_CHAR_MAP_8;
   ptr12b,ptr12 : PTR_CHAR_MAP_12;
   ptr18b,ptr18 : PTR_CHAR_MAP_18;
   ptr24b,ptr24 : PTR_CHAR_MAP_24;
   ptr30b,ptr30 : PTR_CHAR_MAP_30;
BEGIN
    CASE map_size OF
     8 : BEGIN
             ptr8 := ptr_maps;
             WHILE ptr8^.next <> NIL DO ptr8 := ptr8^.next;
             WHILE ptr8 <> NIL DO BEGIN
                 ptr8b := ptr8^.back;
                 dispose(ptr8);
                 ptr8 := ptr8b
             END
         END;
    12 : BEGIN
             ptr12 := ptr_maps;
             WHILE ptr12^.next <> NIL DO ptr12 := ptr12^.next;
             WHILE ptr12 <> NIL DO BEGIN
                 ptr12b := ptr12^.back;
                 dispose(ptr12);
                 ptr12 := ptr12b
             END
         END;
    18 : BEGIN
             ptr18 := ptr_maps;
             WHILE ptr18^.next <> NIL DO ptr18 := ptr18^.next;
             WHILE ptr18 <> NIL DO BEGIN
                 ptr18b := ptr18^.back;
                 dispose(ptr18);
                 ptr18 := ptr18b
             END
         END;
    24 : BEGIN
             ptr24 := ptr_maps;
             WHILE ptr24^.next <> NIL DO ptr24 := ptr24^.next;
             WHILE ptr24 <> NIL DO BEGIN
                 ptr24b := ptr24^.back;
                 dispose(ptr24);
                 ptr24 := ptr24b
             END
         END;
    30 : BEGIN
             ptr30 := ptr_maps;
             WHILE ptr30^.next <> NIL DO ptr30 := ptr30^.next;
             WHILE ptr30 <> NIL DO BEGIN
                 ptr30b := ptr30^.back;
                 dispose(ptr30);
                 ptr30 := ptr30b
             END
         END
    END {case}
END; {procedure reset_maps}
