/* 
   Resident segment for the Windows digital clock
*/

#include <windows.h>
#include <dos.h>
#include <string.h>

#define EXTERN		/* all global variables declared in this module */
#include "dc.h"

static struct dostime_t time;	/* holds the time parameters */
static RECT clrect;		/* formatting rectangle for time display */

/* local function declarations */
static void NEAR MainWndPaint(HWND, LPPAINTSTRUCT);

/* Entry point for program */
int PASCAL WinMain(hInstance, hPrevInstance, lpszCmdLine, cmdShow)
HANDLE hInstance, hPrevInstance;
LPSTR lpszCmdLine;
int cmdShow;
{

    MSG msg;

  /* If initialization is not successful then exit */
    if (!InitProgram(hInstance,hPrevInstance, lpszCmdLine, cmdShow))
	return FALSE;

  /* Retrieve messages from Windows */
    while (GetMessage((LPMSG)&msg,NULL,0,0)) {
	TranslateMessage((LPMSG)&msg);
	DispatchMessage((LPMSG)&msg);
    }
    return msg.wParam;		/* exit program */
}

/* All messages are processed here */
long FAR PASCAL MainWndProc(hWnd,message,wParam,lParam)
HWND hWnd;
unsigned message;
WORD wParam;
LONG lParam;
{

    PAINTSTRUCT ps;

    static BYTE prevminute = 0;		/* these values control updating */
    static BYTE prevhour = 0;

    switch(message) {
      /* initialize the time structure when window is created */
	case WM_CREATE:
	    _dos_gettime(&time);
	    break;

      /* we are exiting, so kill the timer and post a quit message */
	case WM_DESTROY:
	    KillTimer(hWnd, ClockTimerEventID);
	    PostQuitMessage(0);
	    break;

      /* keep a record of the window size for use by the paint function */
	case WM_SIZE:
	    clrect.right = LOWORD(lParam);
	    clrect.bottom = HIWORD(lParam);
	    break;

      /* Each timer event comes here for processing */
	case WM_TIMER:
	    _dos_gettime(&time);
	  /* if new hour, erase window and redisplay the time */
	    if (prevhour != time.hour)
		InvalidateRect(hWnd, (LPRECT)NULL, TRUE);
	  /* otherwise, just redisplay the time without erasing background */
	    else {
		if (IsIconic(hWnd)) {
		  /* but, when iconic, do this only on a minute change */
		    if (prevminute != time.minute)
		        InvalidateRect(hWnd, (LPRECT)NULL, FALSE); 
		}
		  /* and if not iconic, display every second */
		else
		    InvalidateRect(hWnd, (LPRECT)NULL, FALSE); 
	    }
	    prevminute = time.minute;	/* save the new values */
	    prevhour = time.hour;
	    break;
	    
      /* we have to update the window */
	case WM_PAINT:
	    BeginPaint(hWnd, (LPPAINTSTRUCT)&ps);
	    MainWndPaint(hWnd, (LPPAINTSTRUCT)&ps);
	    EndPaint(hWnd, (LPPAINTSTRUCT)&ps);
	    break;

      /* all other messages come here */
	default:
	    return ((long)DefWindowProc(hWnd,message,wParam,lParam));
	    break;
    }
    return(0L);
}

/* Create a text string with the time and display it */
static void NEAR MainWndPaint(hWnd, lpps)
HWND hWnd;
LPPAINTSTRUCT lpps;
{

    char szTimeText[40];
    int i;
    BOOL iconic = IsIconic(hWnd);
    BYTE hour = time.hour;
    BYTE minute = time.minute;
    BYTE second = time.second;

    if (hour > 12)     		/* 12-hour display, i. e. 12:30 not 00:30 */
	hour -= 12;
    if (hour < 1)
	hour = 12;

    if (iconic) {			
	strcpy(szTimeText, szTimestr);		/* Give icon display a title */
 	i = strlen(szTimeText);
	szTimeText[i++] = '\n';			/* Force a new line */
        SelectObject(lpps->hdc, hFont); 	/* Select in the small font */
    }
    else
	i = 0;

    if (hour > 9)				/* ...hour...*/
	szTimeText[i++] = '1';
    szTimeText[i++] = hour % 10 + '0';
    szTimeText[i++] = ':';			/* ...minute...	*/
    szTimeText[i++] = minute > 9 ? minute / 10 + '0' : '0';
    szTimeText[i++] = minute % 10 + '0';
    if (!iconic) {
	szTimeText[i++] = ':';			/* ...second...*/
	szTimeText[i++] = second > 9 ? second / 10 + '0': '0';
	szTimeText[i++] = second % 10 + '0';
    }
    if (iconic)
        szTimeText[i++] = '\n';		/* force another line if iconic */
    else
        szTimeText[i++] = ' ';		/* otherwise make a space */
    szTimeText[i] = '\0';

    if (time.hour > 11)			/* morning or afternoon */
	strcat(szTimeText, szPM);
    else
	strcat(szTimeText, szAM);

  /* display the text */
    DrawText(lpps->hdc, (LPSTR)szTimeText, -1, (LPRECT)&clrect,
	     		DT_NOCLIP | DT_EXTERNALLEADING | DT_CENTER);

}
