// share.cxx
//
// tests the Task and Semaphore classes
//
// author: vaughn vernon
// (c) Copyright 1988 Aspen Scientific
// All Rights Reserved.

#include <stream.hxx>
#include <os2class/task.hxx>
#include <os2class/semaphor.hxx>

// the routine executed as a Task
VOID FAR aRoutine( VOID );

// the resource to protect
CHAR aBuffer[ 36 ];

// global RAM semaphore objects
Semaphore bufSem;
Semaphore startingGun;

int
main()
{
	// get ready for the race;
	// self set signalling semaphore
	++startingGun;

	// create a global global ostream semaphore
	Semaphore streamSem( "\\sem\\ostream.cls", 1, 1 );

	// spawn a task; os/2 thread
	Task loop( aRoutine, 4096 );

	if ( loop.GetStatus() == FALSE ) {

		cerr << "\nError: the task was not run!\n";
		DosExit( EXIT_PROCESS, 2 );
	}

	// wait on the task to begin
	startingGun.Wait( -1L );

	for ( int i=0; i < sizeof (aBuffer); ++i) {

		bufSem.SetRequest( -1L );
		aBuffer[i] = 'A' + i;
		bufSem.Clear();
		DosSleep(0L);
	}

	bufSem.SetRequest( -1L );
	aBuffer[ sizeof( aBuffer ) - 1 ] = char(0);
	streamSem.SetRequest( -1L );
	cout << "\nMain thread finished, buffer is:\n" << aBuffer << "\n";
	cout.flush();
	streamSem.Clear();
	bufSem.Clear();

	// wait on thread to finish
	startingGun.Wait( -1L );

	DosExit( EXIT_THREAD, 0 );
}

// the task/thread routine
VOID FAR
aRoutine()
{
	// for sharing ostream
	Semaphore streamSem( "\\sem\\ostream.cls", 1, 0 );

	// fire the startingGun for this and main thread
	--startingGun;
	++startingGun;

	for ( int i=0; i < sizeof (aBuffer); ++i ) {

		bufSem.SetRequest( -1 );
		aBuffer[i] = 'a' + i;
		bufSem.Clear();
		DosSleep(0L);
	}

	bufSem.SetRequest( -1L );
	aBuffer[ sizeof( aBuffer ) - 1 ] = char(0);
	streamSem.SetRequest( -1L );
	cout << "\nSecondary thread finished, buffer is:\n" << aBuffer << "\n";
	cout.flush();
	streamSem.Clear();
	bufSem.Clear();

	// i'm finished!
	--startingGun;

	DosExit( EXIT_THREAD, 0 );
}
