/*
 * Header file for the PM debugging window
 *
 * Written by William S. Hall
 * 3665  Benton Street, #66
 * Santa Clara, CA 95051
 *
 */

/* This trick makes variables extern in modules EXTERN is not defined */
#if !defined(EXTERN)
#define EXTERN extern
#endif

/* function declarations */
/* from pmaux */
MRESULT FAR PASCAL MainWndProc( HWND, USHORT, MPARAM, MPARAM );

/* from pmauxfn.c */
BOOL SetOS2Ini(HWND hWnd);
void NEAR DispatchString(HWND hWnd, MPARAM mp1, MPARAM mp2);
void NEAR WndCommand(HWND hWnd, USHORT wParam);
void NEAR MainWndPaint(HWND hWnd, HPS hPS, short top, short bottom);
BOOL NEAR WindowIsIconic(HWND hWnd);
MRESULT EXPENTRY AboutBoxProc(HWND hDlg, USHORT msg, MPARAM mp1, MPARAM mp2);

/* from pmauxnt.c */
BOOL FAR InitProgram(int argc, char *argv[]);
void FAR WndCreate(HWND hWnd);

/* resource string constants */
#define IDS_APPNAME	100
#define IDS_ICON	101
#define IDS_TITLE	102

/* resource manifests */
#define DT_ABOUT	1
#define ID_RESOURCE	1

/* menu ids */
#define IDM_ABOUT	100
#define IDM_CRONLF	101

/* global variables */
EXTERN HAB hAB;				/* anchor block handle */
EXTERN HMQ hmqMsgQ;			/* handle to message queue */
EXTERN HWND hwndFrame;			/* handle to window frame */
EXTERN ULONG xIconsize, yIconsize;	/* size of icon */
EXTERN char szAppName[10];		/* application name string */
EXTERN char szIcon[5];			/* icon string */
EXTERN struct TTYWND MWnd;		/* structure describing tty window */
EXTERN HHEAP hHeap;			/* handle to local heap */
