// mouse.cpp	implements methods for the Mouse class. see "mouse.cls".
//
// (c) Aspen Scientific 1989. All Rights Reserved.
// Author: Vaughn Vernon

#include "mouse.cls"

// ************************************************************
// ** the Mouse methods in this file are implemented for MS-DOS
// ** in a text display (non-graphics) environment.  it uses
// ** 8086 interrupts and the Microsoft C int86() function.
// ************************************************************

#include <dos.h>

static union REGS mRegs;
static union REGS holdForEvent;

Mouse::Mouse()
{
	mRegs.x.ax = 0;
	int86(0x33, &mRegs, &mRegs);

	// AX == 0 means mouse not installed
	if (mRegs.x.ax == 0)
		installed = 0;
	else {
		installed = 1;
		numButtons   = mRegs.x.bx;

		// set the text software cursor
		// and make all characters pointed
		// to reverse-video.
		mRegs.x.ax = 10;
		mRegs.x.bx = 0;
		mRegs.x.cx = 0x00ff;
		mRegs.x.dx = 0x7000;
		int86(0x33, &mRegs, &mRegs);

		show();
		flush();
	}
}

Mouse::~Mouse()
{
	if (installed) {

		// under ms-mouse and dos, re-initializing
		// shuts things down
		mRegs.x.ax = 0;
		int86(0x33, &mRegs, &mRegs);
	}
}

void
Mouse::hide()
{
	if (installed) {
		mRegs.x.ax = 2;
		int86(0x33, &mRegs, &mRegs);
	}
}

void
Mouse::show()
{
	if (installed) {
		mRegs.x.ax = 1;
		int86(0x33, &mRegs, &mRegs);
	}
}

int
Mouse::getEvent(Point & p, unsigned & b1, unsigned & b2, unsigned & b3)
{
	if (!installed)
		return 0;

	mRegs.x.ax = 3;
	int86(0x33, &mRegs, &mRegs);

	if (mRegs.x.bx == holdForEvent.x.bx &&
	    mRegs.x.cx == holdForEvent.x.cx &&
	    mRegs.x.dx == holdForEvent.x.dx)
		return 0;

	holdForEvent = mRegs;

	// vertical and horizontal cursor poition
	p(mRegs.x.dx / 8, mRegs.x.cx / 8);

	// are the buttons down?
	b1 = (mRegs.x.bx & 0x01) ? 1:0;
	b2 = (mRegs.x.bx & 0x02) ? 1:0;
	b3 = 0;

	return 1;
}

void
Mouse::setPosition(Point & p)
{
	if (installed) {
		mRegs.x.ax = 4;
		mRegs.x.cx = p.y();
		mRegs.x.dx = p.x();
		int86(0x33, &mRegs, &mRegs);
	}
}

void
Mouse::flush()
{
	Point p;
	unsigned b1, b2, b3;

	while (getEvent(p, b1, b2, b3))
		;
}
