//
//    OOP.CLS - Methods for two way linked lists
//

Include "Root.cls"





// -----------------------------------------------------------------
// ------------Class TwllHead---------------------------------------
// -----------------------------------------------------------------

Class TwllHead : ObjRoot{
    Obj     top;
    int     cnt;
    }
Methods:

// -----------------------------------------------------------------
// Add a new twll item to a list
//

AddItem(Twll_s *twll)
    {
        struct Twll_s *cur;

        cur        =self->top;
        twll->prev =0;
        twll->next =cur;
        if (cur) {
            cur->prev  =twll;
            self->top  =twll;
            self->cnt++;
            }
        self->top=twll;
        return;
    }

// -----------------------------------------------------------------
// This method passes a message on to all the Objects in the list.
//

SendAll(int pass_msg)
    {
        Twll_s      *x;

        for(x=self->top; x ;x=x->next)
            Send(x,pass_msg);
        return;
    }





// -----------------------------------------------------------------
// ------------Class Twll-------------------------------------------
// -----------------------------------------------------------------
//
//  Abstract Root class for all object that can be added to a list

Class Twll : ObjRoot {
    Obj     prev;
    Obj     next;
    }





// -----------------------------------------------------------------
// ------------Class DataTwll---------------------------------------
// -----------------------------------------------------------------

Class DataTwll : Twll {
    int     x, y;
    }

Methods:

// -----------------------------------------------------------------
// Initialize a DataTwll object for x and y
//

int ObjInit()
    {       // init x and y
        self->x=5;
        self->y=6;
        SendSuper(SuperDataTwll,msg);           /* pass the init msg up */
        return;
    }


// -----------------------------------------------------------------
// Set the value of X
//

SetX(int x)
    {
        self->x=x;
    }


// -----------------------------------------------------------------
// Print the contents of a data TWLL
//

Print()
    {
        printf("x is %d, y is %d \t",self->x,self->y);
        Send(self,ObjPrintName);
    }






// -----------------------------------------------------------------
// ------------Class MyDataTwll-------------------------------------
// -----------------------------------------------------------------

Class MyDataTwll : DataTwll {
    char    a[10], b[10];
    }

Methods:

// -----------------------------------------------------------------
// Print the contents of a MyDataTwll
//

Print()
    {
        printf("a is %s \t",self->a);
        SendSuper(SuperMyDataTwll,msg);
    }

// -----------------------------------------------------------------
// Set the value of a
//

SetA(char *str) { strcpy(self->a,str); }






// -----------------------------------------------------------------
// ------------Class OtherDataTwll----------------------------------
// -----------------------------------------------------------------

Class OtherDataTwll : DataTwll {
    int     a;
    }

Methods:

// -----------------------------------------------------------------
// Print the contents of an OtherDataTwll
//

Print()
    {
        printf("a is %d \t",self->a);
        SendSuper(SuperMyDataTwll,msg);
    }

// -----------------------------------------------------------------
// Set the value of a
//

SetA(int a)
    {
        self->a=a;
    }




// -----------------------------------------------------------------
// -----------------------------------------------------------------
OtherCode {
abort_msg(char *msg)
{
    puts(msg);
    exit(1);
}

}

