Turbo Pascal high-resolution timer example. This timer reads the DOS time-of-
day data word and thus extends the range of the timer beyond 54 milliseconds.
Interrupts must be enabled during timing. The calibration routine, as well
as the routine to compute elapsed time between two high-resolution timestamps,
is left to the reader.

tphrt_type = record
                ticks : word;               { 838 ns 8253 timer ticks     }
                tocks : word;               { BIOS TOD 54.925 timer tocks }
             end;

procedure t_start;
{----------------------------------------------------------------------------
 |  This procedure initializes the PC 8253 timer chip to mode 2 and calls   |
 |  the timer-calibration routine.                                          |
 ----------------------------------------------------------------------------}
begin
    inline(
            $B0/$34/                        { mov  al,00110100b }
            $E6/$43/                        { out  43h,al       }
            $2B/$C0/                        { sub  ax,ax        }
            $E6/$40/                        { out  40h,al       }
            $E6/$40                         { out  40h,al       }
          );
    t_calib;                                { call the calibration routine }
end;  { t_start }

procedure t_get(var timestamp : tphrt_type);
{----------------------------------------------------------------------------
 |  This procedure grabs the current counts from the 8253 timer and the     |
 |  BIOS time-of-day clock. Interrupts are off during the timer reads,      |
 |  then back on.                                                           |
 ----------------------------------------------------------------------------}
var
    bios_tod : word absolute $0040:$006C;
begin
    inline($FA);                            { interrupts off }
    port[$43] := 0;
    timestamp.ticks := port[$40];
    timestamp.ticks := timestamp.ticks + (port[$40] shl 8);
    timestamp.tocks := bios_tod;
    inline($FB);                            { interrupts on }
end; { t_get }

procedure t_stop;
{----------------------------------------------------------------------------
 |  This procedure disables 8253 mode 2 and sets 8253 mode 3 counting,      |
 |  which is what the 8253 was doing before we meddled with it. . . .       |
 |  Invoke when all timings complete.                                       |
 ----------------------------------------------------------------------------}
begin
    inline(
            $B8/$36/                        { mov ax,00110110b }
            $E7/$43/                        { out 43h,ax       }
            $2B/$C0/                        { sub ax,ax        }
            $E6/$40/                        { out 40h,al       }
            $E6/$40                         { out 40h,al       }
          );
end; { t_stop }