/* 
 * tompeek.c 
 *
 * High memory peek utility
 *
 * This program returns a screen dump of ram (by byte) at the provided
 * linear (which is also physical) address for the provided number of bytes.
 *
 *		Compiled using Microsoft C 5.1
 * 
 */
#include <stdio.h>
#include <dos.h>

/* Main function.
 *
 * Check command line information, and perform the appropriate hex-dump
 * 
 */
main(argc, argv)
int	argc;
char	**argv;
{
	short	size;
	long	source;
	void	tomPeek(long,short);

	if(argc==3)
		{
		sscanf(argv[1],"%lx",&source);
		sscanf(argv[2],"%x",&size);
		tomPeek(source,size);
		}
	else
		{
		printf("usage: TomPeek <address> <size>\n");
		}

}

/*
 *	tomPeek -	Dump the memory at linear address "source" for "size" bytes
 *					of sixteen-byte lines
 */
void	tomPeek(source,size)
long	source;
short	size;
{
	char	peekBuf[16];
	short	i,j,k;
	extern short near	get_high_mem(char *,short,long);

	for(i=0;i<size;i+=16)
		{
		j = size-i;
		if(j>16)
			j = 16;
		get_high_mem(peekBuf,j,source);
		source += j;
		for(k=0;k<j;k++)
			{
			printf("%02X ",((short)(peekBuf[k]))&0xFF);
			}
		printf("\n");
		}
}

