	title	wvideo - video interface for window system
	include	window.inc
	include	asm.inc

; (c) 1990 Soft Advances, all rights reserved.
                                               
        public row_count,column_count

	.data?
video_pointer	label	dword
video_offset	dw	?
video_segment	dw	?

row_count	db	?
column_count	db	?


	.code
	public	write_video_memory,video_preset


;;	convert pixel value
;
;	entry	AX	pixel color value
;	exit	AL	attribute
;
convert_pixel_value proc
	cmp	ax,BLACK_PIXEL
	jne	cpv1
	mov	al,70h
	ret
cpv1:	cmp	ax,WHITE_PIXEL
;	jne
	mov	al,07h
	ret
convert_pixel_value endp


;;	get row count
;
;	exit	AL	number of display rows
;
get_row_count proc
	push	ds			; access row count (minus 1) from BIOS
	mov	ax,40h			;  data area (0040:0084).
	mov	ds,ax
	mov	al,ds:[84h]		;  (an old BIOS might have 0 here)
	inc	al
	cmp	al,25
	jne	grc1			;  if more than 25 rows
	mov	al,25			;  else assume 25 rows
grc1:	pop	ds
	ret
get_row_count endp


;;	video io
;
;	entry	AX,BX,CX,DX see INT10 documentation
;	exit	AX,BX,CX,DX see INT10 documentation
;		Cf	0
;
video_io proc
	push	bp
	int	10h
	pop	bp
	clc
	ret
video_io endp


;;	video preset
;
;	may use	AX,BX,CX,DX,DI,SI,DS,ES
;
video_preset proc
	call	get_row_count		; set row count
	mov	row_count[bp],al

	mov	ah,15			; set column count
	call	video_io
	mov	column_count[bp],ah

	and	al,7Fh
	cmp	al,7			; use video mode to find video buffer
	mov	cx,0B800h
	jb	vps1			;  if CGA mode
	mov	cx,0B000h
	je	vps1			;  if mono mode
	mov	cx,0A000h		;  else EGA/VGA
vps1:	mov	video_segment[bp],cx
	ret
video_preset endp


;;	write video memory
;
;	entry	AX	attribute
;		CX	byte count
;		DL	column
;		DH	row
;		DS:SI	text pointer
;	may use	AX,BX,CX,DX,SI,DS,ES	(not DI)
;
write_video_memory proc
	push	di
	call	convert_pixel_value
	mov	bx,ax

	jcxz	wvm3			;  if empty write
	cmp	dh,row_count[bp]
	jae	wvm3			;  if below display
	mov	al,column_count[bp]
	sub	al,dl
	jbe	wvm3			;  if right of display

	mov	ah,0			; verify that text fits on display
	cmp	cx,ax
	ja	wvm4			;  if too many bytes

wvm1:	mov	al,dh			; compute video memory address
	mul	column_count[bp]
	mov	dh,0
	add	ax,dx
	add	ax,ax
	les	di,video_pointer[bp]
	add	di,ax
	mov	ah,bl

	even
wvm2:	lodsb				; copy string to video memory
	stosw
	loop	wvm2
wvm3:	pop	di
	ret

wvm4:	mov	cx,ax			; reduce byte count to fit on screen
	jmp	wvm1
write_video_memory endp


	end
