; TORTURE.ASM -- Copyright 1991 by L. Brett Glass
; This "disassembler torture test" is designed to make
; life difficult for disassemblers and debuggers.

        .MODEL LARGE

CODE    SEGMENT PARA PUBLIC
        ASSUME CS:CODE,DS:NOTHING,ES:NOTHING,SS:NOTHING

; Execution starts here. The program executes a bunch of NOPs, followed by 
; a string of ADD [BX+SI],AL instructions. The stack is then moved over the 
; area, and execution is transferred to the REAL program via a push-ret 
; sequence. The intent is to throw the disassembler off the scent.

INIT:
        PUSHF                    ; Push flags for upcoming IRET
        XOR BX,BX                ; Clear BX and SI
        XOR SI,SI
        PUSH CS                  ; Move CS to DS.
        POP DS
        MOV AX,OFFSET STACKSTART ; Get new SP
        REPT 256                 ; 256 NOPs
        NOP
        ENDM
        REPT 255                 ; 255 copies of ADD [BX+SI],AL
        ADD [BX+SI],AL
        ENDM
        XOR  AX,SI               ; XORing with zero does nothing, of course!
        ADD  AX,BX               ; Same with adding zero
        PUSH AX                  ; Push new SP
        PUSH CS                  ; Push new SS
        CLI                      ; Turning off interrupts can cause some
                                 ; debuggers problems
        POP SS                   ; Set up new stack OVER this code!
        MOV AX,SEG REALCODE      ; DEBUG automatically executes a second
                                 ; instruction after SS is loaded, which
                                 ; will hide this load. The user will just
                                 ; see SP being popped.
        POP SP
        PUSH AX                  ; Get destination segment onto stack 
                                 ; below flags.
        PUSH BX                  ; By now, a disassembler may have "forgotten"
                                 ; that this is zero. We're jumping to offset
                                 ; zero in the segment REALCODE.
        IRET                     ; Pop initial flags into flag reg, then jump
                                 ; to start of "real" code. Interrupts are
                                 ; turned back on here when the code is run.
                                 ; But a debugger, which must turn interrupts
                                 ; on between every pair of instructions, will
                                 ; turn them on earlier and trash this opcode!
STACKSTART:

CODE ENDS

REALCODE SEGMENT PARA PUBLIC
     ASSUME CS:CODE,DS:NOTHING,ES:NOTHING,SS:NOTHING
     MOV AX,SEG DATA
     PUSH AX
     POP DS
     MOV DX,OFFSET Message  ; Prepare to print message
     MOV AH,9               ; Print message through DOS
     INT 21h             
     MOV AX,4C00h           ; and EXIT
     INT 21h
REALCODE ENDS

DATA SEGMENT
Message  db 'Disassembler test',0Dh,0Ah,'$'
DATA ENDS

