'***********************************************************************
'                              DOLIB.BAS                               *
'    DOLIB is a program to update the private libraries used with      *
' Microsoft BASIC compiler (BC) version 7.  It adds (or replaces)      *
' named modules to the private searchable libraries, PB.LIB and        *
' PBF.LIB, by constructing and then running a batch file.  The batch   *
' file also runs the compiled BASIC program PBBI.EXE to update the     *
' declaration header file, PB.BI.                                      *
'    The command-line call is "DOLIB [<path>]<modname>"                *
'           where <modname> is the name of the module to be added.     *
'                 <path> is required if the source-code file for       *
'                        <modname> is not in a directory in the PATH   *
'                        environment string.                           *
'    If the source file for <modname> is <modname>.ASM, DOLIB will be  *
' assembled before adding it to both libraries.  If the source file is *
' <modname>.BAS, the file will be compiled twice: in default mode for  *
' PB.LIB, and for "far strings" for PBF.LIB.  If the BASIC source file *
' contains local error trapping, the compilation will be made with the *
' "/E" switch.                                                         *
'    DOLIB updates copies of the libraries and header file in the      *
' default directory.  If any of these files is not in the default      *
' directory, DOLIB will copy it from the directory named in the LIB or *
' INCLUDE environment string.  If <modname> already exists in either   *
' library copy, it will be replaced by the new version.  An existing   *
' SUB or FUNCTION declaration statement in the PB.BI file for the same *
' procedure name will be replaced.                                     *
'----------------------------------------------------------------------*
'               Written by M. L. Lesser, April 14, 1990                *
'                 Compiled with BC v. 7.1, switch "/O"                 *
'        Linked to COMMAND, FINDFILE, NOCOM, NOLPT, and NOFLTIN        *
'                        with switches "/E/NOE"                        *
'***********************************************************************

    DEFINT I
    DEFSTR E,F,M,P,T
    DECLARE FUNCTION FINDFILE$ (A$)
    DECLARE FUNCTION MAKNAME$ (A$)
    DECLARE SUB COMMAND (A$)

'  Local subroutine to write $$$.BAT command that copies file from
'    directory designated in Environment string to default directory:
SUB WRITIT(ENVIRONMENT, FILENAME)
    LET PATH = ENVIRON$(UCASE$(ENVIRONMENT))
    IF RIGHT$(PATH,1) <> "\" THEN LET PATH = PATH + "\"
    PRINT #1, "COPY " PATH FILENAME
END SUB 

    COLOR 2,0                           'Dealer's choice
    CLS
    PRINT TAB(20) "Private Library Update Program for BC 7"
    PRINT STRING$(80,"-")
    LET TEXT = COMMAND$                 'Get <modname> from command line
' Make sure there is a <modname> to add:
    WHILE LEN(TEXT) = 0
        LINE INPUT "Enter [<path>]<modname> for update:  "; TEXT
    WEND
    LET I = INSTR(TEXT,".")             'Remove any extension
    IF I <> 0 THEN LET TEXT = LEFT$(TEXT,I-1)
    LET MODNAME = LCASE$(MAKNAME(TEXT))
    PRINT "Adding Module " CHR$(34) MODNAME CHR$(34);
    PRINT " to private libraries PB.LIB and PBF.LIB."
    PRINT
    OPEN "$$$.BAT" FOR OUTPUT AS #1
    PRINT #1, "@ECHO OFF"               '"@" requires DOS 3.3 (or later)
' Check for private libraries and header file in default directory:
    IF LEN(DIR$("PB.LIB")) = 0 THEN CALL WRITIT("LIB","PB.LIB")
    IF LEN(DIR$("PBF.LIB")) = 0 THEN CALL WRITIT("LIB","PBF.LIB")
    IF LEN(DIR$("PB.BI")) = 0 THEN CALL WRITIT("INCLUDE","PB.BI")
' Try assembled module first:
    LET FILE = FINDFILE(UCASE$(TEXT) + ".ASM")
    IF LEN(FILE) <> 0 THEN              'Assemble it
        PRINT #1, "MASM " FILE ";"
    ELSE
        LET FILE = FINDFILE(UCASE$(TEXT) + ".BAS")
        IF LEN(FILE) <> 0 THEN
            OPEN FILE FOR INPUT AS #2      'Read first, to check for
            WHILE NOT EOF(2)               ' local error trapping
                LINE INPUT #2, TEXT        'Variable name is reused
                IF INSTR(UCASE$(TEXT),"LOCAL ERROR GOTO") THEN
                    LET FILE = FILE + "/E"
                    GOTO DONE
                END IF
            WEND
DONE:       CLOSE #2
            PRINT #1, "BC " FILE ";"
        ELSE                            'Abnormal end if not source file
            PRINT TAB(5) "Source code for " CHR$(34) MODNAME CHR$(34);
            PRINT " module not found.  Terminating program."
            CLOSE #1
            KILL "$$$.BAT"
            END
        END IF
    END IF
    PRINT #1, "IF ERRORLEVEL 1 GOTO END"        'Assemble/compile error
' Replace/Add module in PB.LIB (near strings):
    PRINT #1, "LIB PB-+" MODNAME ",PB.IDX;"
    PRINT #1, "IF ERRORLEVEL 1 GOTO END"
' If module was compiled, recompile for far strings for PBF.LIB
    IF MID$(FILE,INSTR(FILE,"."),4) = ".BAS" THEN
        PRINT #1, "BC " FILE "/Fs;"
        PRINT #1, "IF ERRORLEVEL 1 GOTO END
    END IF    
' Replace/Add module in PBF.LIB (far strings):
    PRINT #1, "LIB PBF-+" MODNAME ",PBF.IDX;" 
    PRINT #1, "IF ERRORLEVEL 1 GOTO END
' Clean up default directory by removing object file:
    PRINT #1, "DEL " MODNAME ".OBJ"
' Update PB.BI header file after deleting "/E" switch from file:
    LET I = INSTR(FILE,"/")
    IF I THEN LET FILE = LEFT$(FILE,I-1)
    PRINT #1, "PBBI " FILE
' Closeout
    PRINT #1, ":END"
    PRINT #1, "DEL $$$.BAT";
    CLOSE #1
    LET FILE = ENVIRON$("COMSPEC")      'Use COMMAND.COM
    CALL COMMAND("/C $$$")              '  to run $$$.BAT
    RUN FILE
