/* 
 *	Source Code Illustrating Use of VM Calls 
 *	by Stephen Kuhn (The Iliad Group)
 */

typedef	unsigned long	TOKEN;

typedef TOKEN			TOKLINE;
typedef TOKLINE			STRING;
typedef struct strline	STRLINE;

struct strline	{
	TOKLINE	next;			/* token of next line in chain */
	TOKLINE	prev;			/* token of prev line in chain */
	STRING	text;			/* token of text for this line */
};

#define		lineref(linetok)		((STRLINE *)vmderef(linetok))
#define		stringref(stringtok)	((char *)vmderef(stringtok))
#define		TOKLINE0			((TOKLINE)0)
#define		STRING0			((STRING)0)

/* This function takes a head line token and a tail line token and
   scans the lines between head and tail (inclusive) for a line that
   begins with a number sign "#".

   Returns the token of the line if found, TOKLINE0 if not found.
*/

TOKLINE	linescan(headtok, tailtok)

{
	TOKLINE	line;

	for	(line=headtok; line != TOKLINE0; line=lineref(line)->next)
	{
		if	(*stringref(lineref(line)->text) == '#')
			return(line);
	}
	return(TOKLINE0);
}
