/*	v_puts.c- Write String to Viewport */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <tools/viewport.h>

int v_puts( viewport *v, char *s )
{
    /* Write string to current cursor position. Only that part of the
     * string that will fit on the current line is written. The cursor
     * moves to the character following end of string if it can. If the
     * output string was truncated, it will rest at the far right of the
     * line.  Return false if the string won't fit on the line, so was
     * truncated. Return true otherwise.
     */

    if( v->magic != VMAGIC )
        return 0;
    while( *s )
        if( !v_putc(v, *s++, 1) )
            return 0;
    return 1;
}
