        PAGE    ,105
        TITLE   Time in Hundredth-seconds
        .MODEL  MEDIUM
;***********************************************************************
;                             HUNDSECS.ASM                             *
;   HUNDSECS [DECLARE FUNCTION HUNDSECS& ()] is an assembled function  *
; for compiled BASIC programs that returns the system time of day in   *
; hundredths of seconds as a long integer.  It serves the same purpose *
; the intrinsic BASIC function "TIMER" except it doesn't require the   *
; use of floating-point arithmetic.                                    *
;              Written by M. L. Lesser, December 25, 1990              *
;              Assembled with Microsoft MASM, version 5.1              *
;***********************************************************************

.CODE
        PUBLIC  HUNDSECS
HUNDSECS PROC
        PUSH    BP
        MOV     AH,2CH          ;DOS "Get time" function
        INT     21H
        MOV     AL,60
        MUL     CH              ;Hours -> minutes in AX
        XOR     CH,CH
        ADD     AX,CX           ; + Minutes
        XCHG    DX,BX           ;Put Seconds and Hundreds in BX
        MOV     CX,6000         ;Hours + minutes -> seconds * 100
        MUL     CX              ;  in DX:AX
        XCHG    AX,CX           ;Now in DX:CX
        MOV     AL,100
        MUL     BH              ;Seconds * 100 in AX
        XOR     BH,BH
        ADD     AX,BX           ; + Hunds
        ADD     AX,CX           ;Low order of final value
        ADC     DX,0            ;High order
        POP     BP
        RET
HUNDSECS ENDP
        END
