/* testdpmi.c - based on Intel 0.9 DPMI spec 
 *
 *	By M. Steven baker
 *	July 17, 1991
 */

#include <stdio.h>

unsigned short GoProtected();
unsigned short getdpmiInfo();

main()
{
     unsigned short regCS, regDS, regES, regSS, regSP;
     unsigned dpmiES, dpmiDI;
     unsigned short dpmiFlags, dpmiParas;
     unsigned dpmiCputype = 0;

     struct {
         unsigned char minor;
         unsigned char major;
     }   dpmiVer;

     _asm mov    regCS,cs                ;store real mode CS
     _asm mov    regDS,ds                ; and DS for display

     printf("Operating in real mode with CS=%04xh DS=%04xh\n\n",
             regCS,regDS);

     if ( getdpmiInfo() ) {
         printf("A DPMI server was not found .., exiting\n");
         exit(1);
     }
     _asm {
          mov    dpmiES,es               ; also the DPMI entry point
          mov    dpmiDI,di               ; for later
          mov    dpmiVer,dx              ; Also the DPMI version
          mov    dpmiCputype,cl          ; the Processor type 
          mov    dpmiFlags,bx            ; if BX bit 0=1, 32-bit apps ok
          mov    dpmiParas,si            ; Private data area required by
                                         ;   DOS extender in paragraphs
     }
     printf("DPMI version = %d.%d  entry point = %04x:%04xh\n",
                   dpmiVer.major, dpmiVer.minor, dpmiES,dpmiDI);
     printf("Processor type is an 80%d86 and the dpmiFlags are %04xh\n",
         dpmiCputype, dpmiFlags);
     if (dpmiFlags && 1)
         printf("32-bit applications are supported\n");
     else
         printf("32-bit applications are not supported\n");

     printf("DPMI requires %04xh paragraphs of private data area\n\n",
             dpmiParas);

     if ( GoProtected() ) {
         printf("Not able to switch to protected mode or DOS malloc failed\n");
         exit(1);
     }
     _asm {
         mov     regCS,cs                ;store registers we got from
         mov     regDS,ds                ; protected mode 
         mov     regES,es
         mov     regSS,ss
         mov     regSP,sp
     }
     printf("We're in DPMI protected mode now with registers set as\n");
     printf("CS=%04xh  DS=%04xh ES=%04xh  SS=%04xh  SP=%04xh\n", 
             regCS, regDS, regES, regSS, regSP);

     _asm mov    ah,4ch              ;the only documented way out 
     _asm int    21h                 ; from DPMI is to use this DOS exit
}

unsigned short getdpmiInfo(void)
{
     _asm    mov ax,1687h
     _asm    int 2fh
}

unsigned short GoProtected(void)
{
     void far *dpmi_entry;

     _asm {
         mov     ax,1687h                ; just get the registers again
         int     2fh                     ;  it's easier
         or      ax,ax                   ; we should get a zero again
         jnz     dpmi_error

         mov     word ptr dpmi_entry,di  ;store the entry address
         mov     word ptr dpmi_entry+2,es
         or      si,si                   ;is memory needed ?
         jz      call_dpmi           

         mov     bx,si                   ; allocate memory for DPMI  
         mov     ah,48h                  ; private area
         int     21h
         jc      dpmi_error

     call_dpmi:
         mov     es,ax               ;pass segment of data area
         mov     ax,0                ;indicate we are a 16-bit app
         call    dpmi_entry          ;switch to protected mode
         xor     ax,ax               ;signal success 
     }
     dpmi_error: ;
}
     