;***********************************************************************
;                              GARLIC.ASM                              *
;    GARLIC.COM is a tiny TSR that circumvents the midnight vampire,   *
; sometime known as the lost date problem.  GARLIC intercepts BIOS     *
; INT 1Ah, AH = 0 (read time) and returns the removed "after midnight" *
; flag if that interrupt was not requested from inside DOS.            *
;                   Written by M. L. Lesser, 7/20/91                   *
; Assembled with Borland TASM 2.5; Linked with TLINK 4.0, switch "/t"  *
;***********************************************************************

CODE    SEGMENT PARA PUBLIC 'CODE'
        ASSUME CS:CODE, DS:CODE, ES:CODE

        ORG     100H
BEGIN:  JMP SHORT INIT

ALIGN   4
OLDHANDLER DD   0               ;Original INT 1Ah vector

NEWHANDLER:                     ;New INT 1Ah handler
        STI
        PUSH    AX
        MOV     AX,DS           ;Did we come from DOS?
        SUB     AX,0070H        ;  if so, DS will hold 0070h
        POP     AX
        JNZ     NODOS           ;If not, check for AH=0
;-----------------------------------------------------------------------
;  NOTE:  "Uncommenting" the four statements just below this note
;         converts GARLIC.ASM to GARLICP.ASM.  The addition removes the
;         forward tie between the DOS clock and the real-time clock.
;-----------------------------------------------------------------------
;       cmp     ah,3            ;AH=3 sets real-time clock time
;       jz      done
;       cmp     ah,5            ;AH=5 sets real-time clock date
;       jz      done
OK:     CLI
        JMP     CS:OLDHANDLER   ;If OK, continue with old interrupt
NODOS:  OR      AH,AH           ;We are looking only for AH=0 calls
        JNZ     OK              ;If not AH=0, use old interrupt
        PUSHF                   ;Simulate INT 1Ah, returning
        CLI                     ;   to this handler
        CALL    CS:OLDHANDLER
        OR      AL,AL           ;Check "after midnight" flag
        JNZ     FIXIT           ;If set, replace flag
DONE:   IRET                    ;Else return to caller
FIXIT:  PUSH    ES              ;Return flag to BIOS data area
        PUSH    DI
        XOR     DI,DI           ;Set ES:DI to address of BIOS
        MOV     ES,DI           ; "after midnight" flag
        MOV     DI,470H
        STOSB                   ; and return flag value
        POP     DI
        POP     ES
        IRET
ALIGN   16                      ;Transient code starts on paragraph
;  End of resident code
INIT:   MOV     AX,ES:[2CH]     ;Set ES to segment address of
        MOV     ES,AX           ;  GARLIC's environment block
        MOV     AH,49H          ;  and release memory block
        INT     21H
        MOV     AX,351AH        ;Save original INT 1Ah vector
        INT     21H
        MOV     WORD PTR OLDHANDLER,BX
        MOV     WORD PTR OLDHANDLER+2,ES
        MOV     AX,251AH        ; and replace it with NEWHANDLER
        MOV     DX,OFFSET NEWHANDLER
        INT     21H
;  Terminate and stay resident, freeing memory starting at INIT
        MOV     DX,OFFSET INIT
        MOV     CL,4
        SHR     DX,CL
        MOV     AX,3100H
        INT     21H
CODE    ENDS
        END     BEGIN
