TITLE  'Character width for current font'
NAME   CHARWID
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1991 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      02 Feb 91                                              |
; function:      Return width of the character for the current font     |
;   caller:      FAR call (QuickBASIC convention)                       |
;                wid = CHARWID(char)                                    |
;    stack:     +06 = char                                              |
;  returns:      width of character in pixels as taken from width table |
;                or 8 if from ROM (segment C000h or greater)            |
;------------------------------------------------------------------------
PARMS           = 1
ARGchar         EQU [bp+06]

CHARWID_TEXT    SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:CHARWID_TEXT

                PUBLIC  CHARWID
CHARWID         PROC FAR

                push    bp
                mov     bp,sp
                push    ds
                push    di

                mov     bx,ARGchar
                mov     bp,[bx]         ;ASCII of character

                sub     ax,ax
                mov     ds,ax           ;ds->0 seg
                ASSUME ds:nothing
                mov     cx,ds:[0485h]   ;BIOS points

                mov     bx,043h * 4     ;ds:bx->int 43h vector
                lds     di,[bx]         ;ds:di->start of char table

                mov     al,8            ;ROM width
                mov     bx,ds
                cmp     bx,0C000h       ;a ROM font?
                jae     X1              ;yes, then no width table

                mov     ax,256
                mul     cx
                add     ax,di           ;ds:ax->start of width table
                mov     bx,ax           ;start of width table for XLAT
                mov     ax,bp           ;ds:[bx+al]->width for this char
                xlat                    ;get width byte for this char into al

X1:             sub     ah,ah
                pop     di
                pop     ds
                pop     bp
                RET     PARMS*2

CHARWID         ENDP
CHARWID_TEXT    ENDS
                END

