TITLE  'Draw Character EGA - VIDEO SYSTEMS p.288'
NAME   DRAWCHM
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1991 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      11 Feb 91                                              |
; function:      Draw a character in EGA\VGA using MOUSE EGA INTERFACE  |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call DRAWCHM(0,65,0,0,7,0)                             |
;    stack:     +06 = bg                                                |
;                08 = fg                                                |
;                10 = y0                                                |
;                12 = x0                                                |
;                14 = character code                                    |
;                16 = replacement type(if bit 7 then foreground only)   |
;  returns:      none                                                   |
;     NOTE:     SS overrides used to access some BSS data               |
;     NOTE:     uses MOUSE EGA INTERFACE-can be used w/o hiding mouse   |
;------------------------------------------------------------------------

PARMS           = 6
ARGaddtype      EQU [bp+16]
ARGchar         EQU [bp+14]
ARGx            EQU [bp+12]
ARGy            EQU [bp+10]
ARGfg           EQU [bp+08]
ARGbg           EQU [bp+06]
ByteOffsetShift EQU 3

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

EXTRN PixelAddr:far

DrawChM_TEXT    SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:DrawChM_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  DrawChM
DrawChM         PROC    FAR

                push    bp
                mov     bp,sp
                push    ds
                push    si
                push    di

                cld
                mov     bx,ARGaddtype
                mov     ax,[bx]
                mov     RMWbits,ax
                mov     bx,ARGchar
                mov     ax,[bx]
                mov     char,ax
                mov     bx,ARGx
                mov     ax,[bx]
                mov     x0,ax
                mov     bx,ARGy
                mov     ax,[bx]
                mov     y0,ax
                mov     bx,ARGfg
                mov     ax,[bx]
                mov     fg,ax
                mov     bx,ARGbg
                mov     ax,[bx]
                mov     bg,ax

                ;calculate first pixel address

                mov     ax,y0
                mov     bx,x0
                mov     cx,bpl
                call    PixelAddr       ;es:bx -> buffer
                                        ;cl = bits to shift left to mask pixel
                inc     cx
                and     cl,7            ;cl = bits to shift to mask char

                mov     ch,0FFh
                shl     ch,cl           ;ch = bit mask for right side of char
                mov     shift,cx

                push    es
                mov     si,bx           ;si = video buffer offset

                ;set up character definition addressing

                mov     ax,040h         ;BIOS data seg
                mov     ds,ax
                ASSUME ds:nothing
                mov     cx,ds:[085h]    ;cx = POINTS

                xor     ax,ax
                mov     ds,ax
                ASSUME ds:nothing

                mov     ax,ss:char
                mov     bx,043h * 4     ;ds:bx -> int 43h vector
                les     di,ds:[bx]      ;es:di -> start of character table
                mul     cl              ;ax = offset into char def table

                add     di,ax           ;di = addr of char def
                pop     ds              ;ds:si -> video buffer
                ASSUME ds:nothing

                ;set up graphics controller using MOUSE EGA INTERFACE

                mov     ah,0F1h         ;write one register
                mov     bx,0A05h        ;5=mode reg/0A=wmode2+rmode1
                mov     dx,10h          ;GC
                int 10h
                mov     bh,byte ptr ss:RMWbits
                and     bh,7Fh          ;bit 7 off
                mov     bl,3            ;3=data rotate reg
                mov     dx,10h          ;GC
                int 10h
                mov     bx,0007         ;7=color don't care reg/0=bits
                mov     dx,10h          ;GC
                int 10h

                ;select output routine depending if byte-aligned

                mov     bl,byte ptr ss:fg
                mov     bh,byte ptr ss:bg
                cmp     byte ptr ss:shift,0     ;test bits to shift
                jne     L20             ;jump if char not byte-aligned

                ;routine for byte-aligned characters

                mov     al,8            ;al = bit mask reg
L10:            mov     ah,es:[di]      ;ah = pattern for next row of pixels
                push    ax              ;bit mask reg/pattern
                push    bx              ;pixel bits

                mov     bx,ax           ;bl=reg/bh=data
                mov     ah,0F1h         ;write one register
                mov     dx,10h          ;GC
                int 10h                 ;update bit mask reg fg

                pop     bx
                pop     ax
                and     [si],bl         ;update fg pixels

                test    byte ptr ss:RMWbits,0080h  ;fg only?
                jnz     L11             ;yes

                not     ah
                push    bx

                mov     bx,ax           ;bl=reg/bh=data
                mov     ah,0F1h         ;write one register
                mov     dx,10h          ;GC
                int 10h                 ;update bit mask reg

                pop     bx

                and     [si],bh         ;update bg pixels
L11:            inc     di              ;es:di -> next byte in char def table
                add     si,ss:bpl       ;increment to next line in video buffer
                loop    L10
                jmp     short Lexit

                ;routine for non-byte-aligned characters

L20:            push    cx
                mov     cx,ss:shift     ;ch = mask for left side of char
                                        ;cl = bits to shift left
                ;left side of character

                mov     al,es:[di]      ;al = bits for next row of pixels
                xor     ah,ah
                shl     ax,cl           ;ah = bits for left side of char
                                        ;al = bits for right side of char
                push    ax              ;save bits for right side

                mov     al,8            ;al = bit mask reg
                push    ax              ;bit mask reg/pattern
                push    bx              ;pixel bits

                mov     bx,ax           ;bh=reg/bl=data
                mov     ah,0F1h         ;write one register
                mov     dx,10h          ;GC
                int 10h                 ;update bit mask reg fg left

                pop     bx
                pop     ax
                and     [si],bl         ;update fg pixels

                not     ch              ;ch = mask for left side of char
                xor     ah,ch           ;ah = bits for bg pixels

                test    byte ptr ss:RMWbits,0080h  ;fg only?
                jnz     L21             ;yes

                push    bx              ;pixel bits

                mov     bx,ax           ;bh=reg/bl=data
                mov     ah,0F1h         ;write one register
                mov     dx,10h          ;GC
                int 10h                 ;update bit mask reg bg left

                pop     bx
                and     [si],bh         ;update bg pixels left

                ;right side of character

L21:            pop     ax
                mov     ah,al           ;ah = bits for right side of char

                mov     al,8
                push    ax              ;bit mask reg/pattern
                push    bx              ;pixel bits

                mov     bx,ax           ;bh=reg/bl=data
                mov     ah,0F1h         ;write one register
                mov     dx,10h          ;GC
                int 10h                 ;update bit mask reg fg right

                pop     bx
                pop     ax
                inc     si              ;ds:si -> right side of char buffer
                and     [si],bl         ;update fg pixels

                not     ch              ;ch = mask for right side of char
                xor     ah,ch           ;ah = bits for bg pixels

                test    byte ptr ss:RMWbits,0080h  ;fg only?
                jnz     L22             ;yes

                push    bx              ;pixel bits

                mov     bx,ax           ;bh=reg/bl=data
                mov     ah,0F1h         ;write one register
                mov     dx,10h          ;GC
                int 10h                 ;update bit mask reg bg right

                pop     bx
                and     [si],bh         ;update background pixels

                ;increment to next row of pixels in character

L22:            inc     di              ;es:di -> next byte in char def table
                dec     si
                add     si,ss:bpl       ;ds:si -> next line in video buffer

                pop     cx
                loop    L20

                ;restore default graphics controller with MOUSE EGA INTERFACE

Lexit:          mov     ah,0F1h         ;write one register
                mov     bx,0FF08h       ;8=bit mask reg/FF=bit mask
                mov     dx,10h          ;GC
                int 10h
                mov     bx,0005h        ;5=mode reg/00=data
                mov     dx,10h          ;GC
                int 10h
                mov     bx,0003         ;3=data rotate reg/data
                mov     dx,10h          ;GC
                int 10h
                mov     bx,0F07h        ;7=color don't care reg/0F=bits
                mov     dx,10h          ;GC
                int 10h

                pop     di
                pop     si
                pop     ds
                pop     bp
                RET     PARMS*2

DrawChM         ENDP
DrawChM_TEXT    ENDS
                END

